/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContent
extends DiffContent {
    @NotNull
    private final VirtualFile myFile;
    private Document myDocument;
    private final Project myProject;
    private final FileType myType;

    public FileContent(Project project, @NotNull VirtualFile file) {
        this.myProject = project;
        this.myFile = file;
        this.myType = file.getFileType();
    }

    @Override
    public Document getDocument() {
        if (this.myDocument == null && DiffContentUtil.isTextFile(this.myFile)) {
            this.myDocument = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(this.myFile));
        }
        return this.myDocument;
    }

    @Override
    public Navigatable getOpenFileDescriptor(int offset) {
        return PsiNavigationSupport.getInstance().createNavigatable(this.myProject, this.myFile, offset);
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    @Nullable
    public FileType getContentType() {
        return this.myType;
    }

    @Override
    public byte[] getBytes() throws IOException {
        if (this.myFile.isDirectory()) {
            return null;
        }
        return this.myFile.contentsToByteArray();
    }

    @Override
    public boolean isBinary() {
        return !this.myFile.isDirectory() && this.myType.isBinary();
    }

    public static FileContent createFromTempFile(Project project, String name, String ext, @NotNull byte[] content) throws IOException {
        File tempFile = FileUtil.createTempFile((String)name, (String)("." + ext));
        if (content.length != 0) {
            FileUtil.writeToFile((File)tempFile, (byte[])content);
        }
        tempFile.deleteOnExit();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile file = lfs.findFileByIoFile(tempFile);
        if (file == null) {
            file = lfs.refreshAndFindFileByIoFile(tempFile);
        }
        if (file != null) {
            return new FileContent(project, file);
        }
        throw new IOException("Can not create temp file for revision content");
    }

    @Override
    @NotNull
    public LineSeparator getLineSeparator() {
        return LineSeparator.fromString((String)FileDocumentManager.getInstance().getLineSeparator(this.myFile, this.myProject));
    }
}

