/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CaretModel {
    public void moveCaretRelatively(int var1, int var2, boolean var3, boolean var4, boolean var5);

    public void moveToLogicalPosition(@NotNull LogicalPosition var1);

    public void moveToVisualPosition(@NotNull VisualPosition var1);

    public void moveToOffset(int var1);

    public void moveToOffset(int var1, boolean var2);

    public boolean isUpToDate();

    @NotNull
    public LogicalPosition getLogicalPosition();

    @NotNull
    public VisualPosition getVisualPosition();

    public int getOffset();

    public void addCaretListener(@NotNull CaretListener var1);

    default public void addCaretListener(@NotNull CaretListener listener, @NotNull Disposable parentDisposable) {
        this.addCaretListener(listener);
        Disposer.register((Disposable)parentDisposable, () -> this.removeCaretListener(listener));
    }

    public void removeCaretListener(@NotNull CaretListener var1);

    public int getVisualLineStart();

    public int getVisualLineEnd();

    public TextAttributes getTextAttributes();

    public boolean supportsMultipleCarets();

    @NotNull
    public Caret getCurrentCaret();

    @NotNull
    public Caret getPrimaryCaret();

    public int getCaretCount();

    @NotNull
    public List<Caret> getAllCarets();

    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition var1);

    @Nullable
    public Caret addCaret(@NotNull VisualPosition var1);

    @Nullable
    public Caret addCaret(@NotNull VisualPosition var1, boolean var2);

    public boolean removeCaret(@NotNull Caret var1);

    public void removeSecondaryCarets();

    public void setCaretsAndSelections(@NotNull List<CaretState> var1);

    public void setCaretsAndSelections(@NotNull List<CaretState> var1, boolean var2);

    @NotNull
    public List<CaretState> getCaretsAndSelections();

    public void runForEachCaret(@NotNull CaretAction var1);

    public void runForEachCaret(@NotNull CaretAction var1, boolean var2);

    public void addCaretActionListener(@NotNull CaretActionListener var1, @NotNull Disposable var2);

    public void runBatchCaretOperation(@NotNull Runnable var1);
}

