/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.text.CharArrayUtil;
import java.beans.PropertyChangeListener;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Document
extends UserDataHolder {
    public static final Document[] EMPTY_ARRAY = new Document[0];
    @NonNls
    public static final String PROP_WRITABLE = "writable";

    @NotNull
    @Contract(pure=true)
    default public String getText() {
        return this.getImmutableCharSequence().toString();
    }

    @NotNull
    @Contract(pure=true)
    default public String getText(@NotNull TextRange range) {
        return range.substring(this.getText());
    }

    @Contract(pure=true)
    @NotNull
    default public CharSequence getCharsSequence() {
        return this.getImmutableCharSequence();
    }

    @NotNull
    @Contract(pure=true)
    public CharSequence getImmutableCharSequence();

    @Deprecated
    @NotNull
    default public char[] getChars() {
        return CharArrayUtil.fromSequence((CharSequence)this.getImmutableCharSequence());
    }

    @Contract(pure=true)
    default public int getTextLength() {
        return this.getImmutableCharSequence().length();
    }

    @Contract(pure=true)
    public int getLineCount();

    @Contract(pure=true)
    public int getLineNumber(int var1);

    @Contract(pure=true)
    public int getLineStartOffset(int var1);

    @Contract(pure=true)
    public int getLineEndOffset(int var1);

    default public boolean isLineModified(int line) {
        return false;
    }

    public void insertString(int var1, @NotNull CharSequence var2);

    public void deleteString(int var1, int var2);

    public void replaceString(int var1, int var2, @NotNull CharSequence var3);

    @Contract(pure=true)
    public boolean isWritable();

    @Contract(pure=true)
    public long getModificationStamp();

    default public void fireReadOnlyModificationAttempt() {
    }

    default public void addDocumentListener(@NotNull DocumentListener listener) {
    }

    default public void addDocumentListener(@NotNull DocumentListener listener, @NotNull Disposable parentDisposable) {
    }

    default public void removeDocumentListener(@NotNull DocumentListener listener) {
    }

    @NotNull
    default public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        return this.createRangeMarker(startOffset, endOffset, false);
    }

    @NotNull
    public RangeMarker createRangeMarker(int var1, int var2, boolean var3);

    default public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    default public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    default public void setReadOnly(boolean isReadOnly) {
    }

    @NotNull
    public RangeMarker createGuardedBlock(int var1, int var2);

    default public void removeGuardedBlock(@NotNull RangeMarker block) {
    }

    @Nullable
    default public RangeMarker getOffsetGuard(int offset) {
        return this.getRangeGuard(offset, offset);
    }

    @Nullable
    default public RangeMarker getRangeGuard(int start, int end) {
        return null;
    }

    default public void startGuardedBlockChecking() {
    }

    default public void stopGuardedBlockChecking() {
    }

    default public void setCyclicBufferSize(int bufferSize) {
    }

    public void setText(@NotNull CharSequence var1);

    @NotNull
    default public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        return this.createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset());
    }

    @Contract(pure=true)
    default public int getLineSeparatorLength(int line) {
        return 0;
    }
}

