/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Point;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface InlayModel {
    @Nullable
    default public <T extends EditorCustomElementRenderer> Inlay<T> addInlineElement(int offset, @NotNull T renderer) {
        return this.addInlineElement(offset, false, renderer);
    }

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addInlineElement(int var1, boolean var2, @NotNull T var3);

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addBlockElement(int var1, boolean var2, boolean var3, int var4, @NotNull T var5);

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addAfterLineEndElement(int var1, boolean var2, @NotNull T var3);

    @NotNull
    public List<Inlay> getInlineElementsInRange(int var1, int var2);

    default public <T> List<Inlay<? extends T>> getInlineElementsInRange(int startOffset, int endOffset, Class<T> type) {
        return ContainerUtil.filter(this.getInlineElementsInRange(startOffset, endOffset), inlay -> type.isInstance(inlay.getRenderer()));
    }

    @NotNull
    public List<Inlay> getBlockElementsInRange(int var1, int var2);

    default public <T> List<Inlay<? extends T>> getBlockElementsInRange(int startOffset, int endOffset, Class<T> type) {
        return ContainerUtil.filter(this.getBlockElementsInRange(startOffset, endOffset), inlay -> type.isInstance(inlay.getRenderer()));
    }

    @NotNull
    public List<Inlay> getBlockElementsForVisualLine(int var1, boolean var2);

    default public boolean hasBlockElements() {
        return !this.getBlockElementsInRange(0, Integer.MAX_VALUE).isEmpty();
    }

    default public boolean hasInlineElementsInRange(int startOffset, int endOffset) {
        return !this.getInlineElementsInRange(startOffset, endOffset).isEmpty();
    }

    default public boolean hasInlineElements() {
        return this.hasInlineElementsInRange(0, Integer.MAX_VALUE);
    }

    public boolean hasInlineElementAt(int var1);

    default public boolean hasInlineElementAt(@NotNull VisualPosition visualPosition) {
        return this.getInlineElementAt(visualPosition) != null;
    }

    @Nullable
    public Inlay getInlineElementAt(@NotNull VisualPosition var1);

    @Nullable
    public Inlay getElementAt(@NotNull Point var1);

    @NotNull
    public List<Inlay> getAfterLineEndElementsInRange(int var1, int var2);

    @NotNull
    default public <T> List<Inlay<? extends T>> getAfterLineEndElementsInRange(int startOffset, int endOffset, Class<T> type) {
        return ContainerUtil.filter(this.getAfterLineEndElementsInRange(startOffset, endOffset), inlay -> type.isInstance(inlay.getRenderer()));
    }

    @NotNull
    public List<Inlay> getAfterLineEndElementsForLogicalLine(int var1);

    public void setConsiderCaretPositionOnDocumentUpdates(boolean var1);

    public void addListener(@NotNull Listener var1, @NotNull Disposable var2);

    public static abstract class SimpleAdapter
    implements Listener {
        @Override
        public void onAdded(@NotNull Inlay inlay) {
            this.onUpdated(inlay);
        }

        @Override
        public void onUpdated(@NotNull Inlay inlay) {
        }

        @Override
        public void onRemoved(@NotNull Inlay inlay) {
            this.onUpdated(inlay);
        }
    }

    public static interface Listener
    extends EventListener {
        public void onAdded(@NotNull Inlay var1);

        public void onUpdated(@NotNull Inlay var1);

        public void onRemoved(@NotNull Inlay var1);
    }
}

