/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SelectionModel {
    public int getSelectionStart();

    @Nullable
    public VisualPosition getSelectionStartPosition();

    public int getSelectionEnd();

    @Nullable
    public VisualPosition getSelectionEndPosition();

    @Nullable
    public String getSelectedText();

    @Nullable
    public String getSelectedText(boolean var1);

    public int getLeadSelectionOffset();

    @Nullable
    public VisualPosition getLeadSelectionPosition();

    public boolean hasSelection();

    public boolean hasSelection(boolean var1);

    public void setSelection(int var1, int var2);

    public void setSelection(int var1, @Nullable VisualPosition var2, int var3);

    public void setSelection(@Nullable VisualPosition var1, int var2, @Nullable VisualPosition var3, int var4);

    public void removeSelection();

    public void removeSelection(boolean var1);

    public void addSelectionListener(@NotNull SelectionListener var1);

    default public void addSelectionListener(@NotNull SelectionListener listener, @NotNull Disposable parentDisposable) {
        this.addSelectionListener(listener);
        Disposer.register((Disposable)parentDisposable, () -> this.removeSelectionListener(listener));
    }

    public void removeSelectionListener(@NotNull SelectionListener var1);

    public void selectLineAtCaret();

    public void selectWordAtCaret(boolean var1);

    public void copySelectionToClipboard();

    public void setBlockSelection(@NotNull LogicalPosition var1, @NotNull LogicalPosition var2);

    @NotNull
    public int[] getBlockSelectionStarts();

    @NotNull
    public int[] getBlockSelectionEnds();

    public TextAttributes getTextAttributes();
}

