/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VisualPosition {
    public final int line;
    public final int column;
    public final boolean leansRight;

    public VisualPosition(int line, int column) {
        this(line, column, false);
    }

    public VisualPosition(int line, int column, boolean leansRight) {
        if (line < 0) {
            throw new IllegalArgumentException("line must be non negative: " + line);
        }
        if (column < 0) {
            throw new IllegalArgumentException("column must be non negative: " + column);
        }
        this.line = line;
        this.column = column;
        this.leansRight = leansRight;
    }

    public boolean after(@NotNull VisualPosition other) {
        if (this.line == other.line) {
            return this.column > other.column;
        }
        return this.line > other.line;
    }

    public VisualPosition leanRight(boolean value) {
        return new VisualPosition(this.line, this.column, value);
    }

    @NonNls
    public String toString() {
        return "VisualPosition: (" + this.line + ", " + this.column + ")" + (this.leansRight ? " leans right" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VisualPosition)) {
            return false;
        }
        VisualPosition that = (VisualPosition)o;
        if (this.column != that.column) {
            return false;
        }
        return this.line == that.line;
    }

    public int hashCode() {
        int result2 = this.line;
        result2 = 31 * result2 + this.column;
        return result2;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }
}

