/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DialogAwareDataContext;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionHandlerBean;
import com.intellij.openapi.editor.actionSystem.LatencyAwareEditorAction;
import com.intellij.openapi.editor.actionSystem.LatencyRecorder;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorAction
extends AnAction
implements DumbAware,
UpdateInBackground {
    private static final Logger LOG = Logger.getInstance(EditorAction.class);
    private EditorActionHandler myHandler;
    private boolean myHandlersLoaded;

    public final EditorActionHandler getHandler() {
        this.ensureHandlersLoaded();
        return this.myHandler;
    }

    protected EditorAction(EditorActionHandler defaultHandler) {
        this.myHandler = defaultHandler;
        this.setEnabledInModalContext(true);
    }

    public final EditorActionHandler setupHandler(@NotNull EditorActionHandler newHandler) {
        this.ensureHandlersLoaded();
        EditorActionHandler tmp = this.myHandler;
        this.myHandler = newHandler;
        this.myHandler.setWorksInInjected(this.isInInjectedContext());
        return tmp;
    }

    private void ensureHandlersLoaded() {
        if (!this.myHandlersLoaded) {
            this.myHandlersLoaded = true;
            String id = ActionManager.getInstance().getId(this);
            List extensions = EditorActionHandlerBean.EP_NAME.getExtensionList();
            for (int i = extensions.size() - 1; i >= 0; --i) {
                EditorActionHandler handler;
                EditorActionHandlerBean handlerBean = (EditorActionHandlerBean)((Object)extensions.get(i));
                if (!handlerBean.action.equals(id) || (handler = handlerBean.getHandler(this.myHandler)) == null) continue;
                this.myHandler = handler;
                this.myHandler.setWorksInInjected(this.isInInjectedContext());
            }
        }
    }

    @Override
    public void setInjectedContext(boolean worksInInjected) {
        super.setInjectedContext(worksInInjected);
        this.myHandler.setWorksInInjected(this.isInInjectedContext());
    }

    @Override
    public final void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Editor editor = this.getEditor(dataContext);
        if (this instanceof LatencyAwareEditorAction && editor != null) {
            String actionId = ActionManager.getInstance().getId(this);
            InputEvent inputEvent = e.getInputEvent();
            if (actionId != null && inputEvent != null) {
                LatencyRecorder.getInstance().recordLatencyAwareAction(editor, actionId, inputEvent.getWhen());
            }
        }
        this.actionPerformed(editor, dataContext);
    }

    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext) {
        return CommonDataKeys.EDITOR.getData(dataContext);
    }

    public final void actionPerformed(Editor editor, @NotNull DataContext dataContext) {
        if (editor == null) {
            return;
        }
        if (editor.isDisposed()) {
            VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
            LOG.error("Action " + this + " invoked on a disposed editor" + (file == null ? "" : " for file " + file));
            return;
        }
        EditorActionHandler handler = this.getHandler();
        Runnable command = () -> handler.execute(editor, null, EditorAction.getProjectAwareDataContext(editor, dataContext));
        if (!handler.executeInCommand(editor, dataContext)) {
            command.run();
            return;
        }
        String commandName = this.getTemplatePresentation().getText();
        if (commandName == null) {
            commandName = "";
        }
        CommandProcessor.getInstance().executeCommand(editor.getProject(), command, commandName, (Object)handler.getCommandGroupId(editor), UndoConfirmationPolicy.DEFAULT, editor.getDocument());
    }

    public void update(Editor editor, Presentation presentation, DataContext dataContext) {
        presentation.setEnabled(this.getHandler().isEnabled(editor, null, dataContext));
    }

    public void updateForKeyboardAccess(Editor editor, Presentation presentation, DataContext dataContext) {
        this.update(editor, presentation, dataContext);
    }

    @Override
    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        Editor editor;
        if (this.isInInjectedContext() && (editor = CommonDataKeys.HOST_EDITOR.getData(e.getDataContext())) != null) {
            for (Caret caret : editor.getCaretModel().getAllCarets()) {
                if (EditorActionHandler.ensureInjectionUpToDate(caret)) break;
            }
        }
        super.beforeActionPerformedUpdate(e);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Editor editor = this.getEditor(dataContext);
        if (editor == null) {
            presentation.setEnabled(false);
        } else if (editor.isDisposed()) {
            LOG.error("Disposed editor in " + dataContext + " for " + this);
            presentation.setEnabled(false);
        } else if (e.getInputEvent() instanceof KeyEvent) {
            this.updateForKeyboardAccess(editor, presentation, dataContext);
        } else {
            this.update(editor, presentation, dataContext);
        }
    }

    private static DataContext getProjectAwareDataContext(Editor editor, @NotNull DataContext original) {
        if (CommonDataKeys.PROJECT.getData(original) == editor.getProject()) {
            return new DialogAwareDataContext(original);
        }
        return dataId -> {
            Project project;
            if (CommonDataKeys.PROJECT.is(dataId) && (project = editor.getProject()) != null) {
                return project;
            }
            return original.getData(dataId);
        };
    }
}

