/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTypedHandlerBean;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.actionSystem.TypedActionHandlerEx;
import com.intellij.openapi.project.Project;
import com.intellij.reporting.FreezeLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypedAction {
    private TypedActionHandler myRawHandler;
    private TypedActionHandler myHandler = new Handler();
    private boolean myHandlersLoaded;

    private void ensureHandlersLoaded() {
        if (!this.myHandlersLoaded) {
            this.myHandlersLoaded = true;
            for (EditorTypedHandlerBean handlerBean : EditorTypedHandlerBean.EP_NAME.getExtensionList()) {
                this.myHandler = handlerBean.getHandler(this.myHandler);
            }
        }
    }

    private void loadRawHandlers() {
        for (EditorTypedHandlerBean handlerBean : EditorTypedHandlerBean.RAW_EP_NAME.getExtensionList()) {
            this.myRawHandler = handlerBean.getHandler(this.myRawHandler);
        }
    }

    public TypedActionHandler getHandler() {
        this.ensureHandlersLoaded();
        return this.myHandler;
    }

    public TypedActionHandler setupHandler(TypedActionHandler handler) {
        this.ensureHandlersLoaded();
        TypedActionHandler tmp = this.myHandler;
        this.myHandler = handler;
        return tmp;
    }

    @NotNull
    public TypedActionHandler getRawHandler() {
        return this.myRawHandler;
    }

    public TypedActionHandler setupRawHandler(@NotNull TypedActionHandler handler) {
        TypedActionHandler tmp = this.myRawHandler;
        this.myRawHandler = handler;
        if (tmp == null) {
            this.loadRawHandlers();
        }
        return tmp;
    }

    public void beforeActionPerformed(@NotNull Editor editor, char c, @NotNull DataContext context, @NotNull ActionPlan plan) {
        if (this.myRawHandler instanceof TypedActionHandlerEx) {
            ((TypedActionHandlerEx)this.myRawHandler).beforeExecute(editor, c, context, plan);
        }
    }

    public final void actionPerformed(@Nullable Editor editor, char charTyped, DataContext dataContext) {
        if (editor == null) {
            return;
        }
        Project project = CommonDataKeys.PROJECT.getData(dataContext);
        FreezeLogger.getInstance().runUnderPerformanceMonitor(project, () -> this.myRawHandler.execute(editor, charTyped, dataContext));
    }

    private static class Handler
    implements TypedActionHandler {
        private Handler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            if (editor.isViewer()) {
                return;
            }
            Document doc = editor.getDocument();
            doc.startGuardedBlockChecking();
            try {
                String str = String.valueOf(charTyped);
                CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message("typing.in.editor.command.name", new Object[0]));
                EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, true);
            }
            catch (ReadOnlyFragmentModificationException e) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
            }
            finally {
                doc.stopGuardedBlockChecking();
            }
        }
    }
}

