/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.util.ConcurrencyUtil;
import java.awt.Color;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorKey
implements Comparable<ColorKey> {
    public static final Key<Function<ColorKey, Color>> FUNCTION_KEY = Key.create((String)"COLOR_KEY_FUNCTION");
    private static final ConcurrentMap<String, ColorKey> ourRegistry = new ConcurrentHashMap<String, ColorKey>();
    @NotNull
    private final String myExternalName;
    private final Color myDefaultColor;

    private ColorKey(@NotNull String externalName, Color defaultColor) {
        this.myExternalName = externalName;
        this.myDefaultColor = defaultColor;
    }

    @NotNull
    public static ColorKey find(@NotNull String externalName) {
        return ourRegistry.computeIfAbsent(externalName, name -> new ColorKey((String)name, null));
    }

    public String toString() {
        return this.myExternalName;
    }

    @NotNull
    public String getExternalName() {
        return this.myExternalName;
    }

    @Override
    public int compareTo(@NotNull ColorKey key) {
        return this.myExternalName.compareTo(key.myExternalName);
    }

    public Color getDefaultColor() {
        return this.myDefaultColor;
    }

    @Deprecated
    @Nullable
    public ColorKey getFallbackColorKey() {
        return null;
    }

    @NotNull
    public static ColorKey createColorKey(@NonNls @NotNull String externalName) {
        return ColorKey.find(externalName);
    }

    @NotNull
    public static ColorKey createColorKey(@NonNls @NotNull String externalName, @Nullable Color defaultColor) {
        ColorKey existing = (ColorKey)ourRegistry.get(externalName);
        if (existing != null) {
            if (Comparing.equal((Object)existing.getDefaultColor(), (Object)defaultColor)) {
                return existing;
            }
            ourRegistry.remove(externalName, existing);
        }
        ColorKey newKey = new ColorKey(externalName, defaultColor);
        return (ColorKey)ConcurrencyUtil.cacheOrGet(ourRegistry, (Object)externalName, (Object)newKey);
    }

    public int hashCode() {
        return this.myExternalName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ColorKey && this.myExternalName.equals(((ColorKey)obj).myExternalName);
    }
}

