/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorsUtil {
    private EditorColorsUtil() {
    }

    @NotNull
    public static EditorColorsScheme getGlobalOrDefaultColorScheme() {
        return EditorColorsUtil.getColorSchemeForBackground(null);
    }

    @Nullable
    public static Color getGlobalOrDefaultColor(@NotNull ColorKey colorKey) {
        Color color = EditorColorsUtil.getColorSchemeForBackground(null).getColor(colorKey);
        return color != null ? color : colorKey.getDefaultColor();
    }

    @NotNull
    public static EditorColorsScheme getColorSchemeForComponent(@Nullable JComponent component) {
        return EditorColorsUtil.getColorSchemeForBackground(component != null ? component.getBackground() : null);
    }

    public static EditorColorsScheme getColorSchemeForBackground(@Nullable Color background) {
        EditorColorsScheme scheme;
        EditorColorsScheme globalScheme;
        boolean dark2;
        boolean dark1 = background == null ? UIUtil.isUnderDarcula() : ColorUtil.isDark((Color)background);
        if (dark1 != (dark2 = ColorUtil.isDark((Color)(globalScheme = EditorColorsManager.getInstance().getGlobalScheme()).getDefaultBackground())) && (scheme = EditorColorsManager.getInstance().getScheme("Default")) != null) {
            return scheme;
        }
        return globalScheme;
    }

    @NotNull
    public static EditorColorsScheme getColorSchemeForPrinting() {
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        return colorsManager.isDarkEditor() ? colorsManager.getScheme("Default") : colorsManager.getGlobalScheme();
    }

    public static void updateNotInHierarchyComponentUIAndColors(@Nullable Component component) {
        if (component == null || component.isValid()) {
            return;
        }
        for (Component o : UIUtil.uiTraverser((Component)component).postOrderDfsTraversal()) {
            if (o instanceof JComponent) {
                ((JComponent)o).updateUI();
            }
            if (o instanceof UISettingsListener) {
                ((UISettingsListener)((Object)o)).uiSettingsChanged(UISettings.getInstance());
            }
            if (!(o instanceof EditorColorsListener)) continue;
            ((EditorColorsListener)((Object)o)).globalSchemeChange(EditorColorsManager.getInstance().getGlobalScheme());
        }
    }
}

