/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextAttributesKey
implements Comparable<TextAttributesKey> {
    private static final Logger LOG = Logger.getInstance(TextAttributesKey.class);
    private static final String TEMP_PREFIX = "TEMP::";
    private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();
    private static final ConcurrentMap<String, TextAttributesKey> ourRegistry = new ConcurrentHashMap<String, TextAttributesKey>();
    private static final NullableLazyValue<TextAttributeKeyDefaultsProvider> ourDefaultsProvider = new VolatileNullableLazyValue<TextAttributeKeyDefaultsProvider>(){

        @Nullable
        protected TextAttributeKeyDefaultsProvider compute() {
            return ServiceManager.getService(TextAttributeKeyDefaultsProvider.class);
        }
    };
    private final String myExternalName;
    private final TextAttributes myDefaultAttributes;
    private final TextAttributesKey myFallbackAttributeKey;
    private static final ThreadLocal<Set<String>> CALLED_RECURSIVELY = ThreadLocal.withInitial(() -> new THashSet());
    @Deprecated
    static final TextAttributesKey DUMMY_DEPRECATED_ATTRIBUTES = TextAttributesKey.createTextAttributesKey("__deprecated__");

    private TextAttributesKey(@NotNull String externalName, TextAttributes defaultAttributes, TextAttributesKey fallbackAttributeKey) {
        JBIterable it;
        this.myExternalName = externalName;
        this.myDefaultAttributes = defaultAttributes;
        this.myFallbackAttributeKey = fallbackAttributeKey;
        if (fallbackAttributeKey != null && this.equals((it = JBIterable.generate((Object)this.myFallbackAttributeKey, o -> o == this ? null : o.myFallbackAttributeKey)).find(o -> this.equals(o)))) {
            throw new IllegalArgumentException("Can't use this fallback key: " + fallbackAttributeKey + ": Cycle detected: " + StringUtil.join((Iterable)it, (String)"->"));
        }
    }

    public TextAttributesKey(@NotNull Element element) {
        String name = JDOMExternalizerUtil.readField((Element)element, (String)"myExternalName");
        Element myDefaultAttributesElement = JDOMExternalizerUtil.readOption((Element)element, (String)"myDefaultAttributes");
        TextAttributes defaultAttributes = myDefaultAttributesElement == null ? null : new TextAttributes(myDefaultAttributesElement);
        this.myExternalName = name;
        this.myDefaultAttributes = defaultAttributes;
        this.myFallbackAttributeKey = null;
    }

    @NotNull
    public static TextAttributesKey find(@NotNull @NonNls String externalName) {
        return ourRegistry.computeIfAbsent(externalName, name -> new TextAttributesKey((String)name, null, null));
    }

    public String toString() {
        return this.myExternalName;
    }

    @NotNull
    public String getExternalName() {
        return this.myExternalName;
    }

    @Override
    public int compareTo(@NotNull TextAttributesKey key) {
        return this.myExternalName.compareTo(key.myExternalName);
    }

    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName) {
        return TextAttributesKey.find(externalName);
    }

    public void writeExternal(Element element) {
        JDOMExternalizerUtil.writeField((Element)element, (String)"myExternalName", (String)this.myExternalName);
        if (this.myDefaultAttributes != null) {
            Element option = JDOMExternalizerUtil.writeOption((Element)element, (String)"myDefaultAttributes");
            this.myDefaultAttributes.writeExternal(option);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextAttributesKey that = (TextAttributesKey)o;
        return this.myExternalName.equals(that.myExternalName);
    }

    public int hashCode() {
        return this.myExternalName.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextAttributes getDefaultAttributes() {
        TextAttributeKeyDefaultsProvider provider;
        TextAttributes defaultAttributes = this.myDefaultAttributes;
        if (defaultAttributes == null && (provider = (TextAttributeKeyDefaultsProvider)ourDefaultsProvider.getValue()) != null) {
            Set<String> called = CALLED_RECURSIVELY.get();
            if (!called.add(this.myExternalName)) {
                return null;
            }
            try {
                TextAttributes textAttributes = (TextAttributes)ObjectUtils.notNull((Object)provider.getDefaultAttributes(this), (Object)NULL_ATTRIBUTES);
                return textAttributes;
            }
            finally {
                called.remove(this.myExternalName);
            }
        }
        return defaultAttributes;
    }

    @Deprecated
    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName, TextAttributes defaultAttributes) {
        return TextAttributesKey.getOrCreate(externalName, defaultAttributes, null);
    }

    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName, TextAttributesKey fallbackAttributeKey) {
        return TextAttributesKey.getOrCreate(externalName, null, fallbackAttributeKey);
    }

    @NotNull
    private static TextAttributesKey getOrCreate(@NotNull @NonNls String externalName, TextAttributes defaultAttributes, TextAttributesKey fallbackAttributeKey) {
        TextAttributesKey existing = (TextAttributesKey)ourRegistry.get(externalName);
        if (existing != null && (defaultAttributes == null || Comparing.equal((Object)existing.myDefaultAttributes, (Object)defaultAttributes)) && (fallbackAttributeKey == null || Comparing.equal((Object)existing.myFallbackAttributeKey, (Object)fallbackAttributeKey))) {
            return existing;
        }
        return ourRegistry.compute(externalName, (oldName, oldKey) -> TextAttributesKey.mergeKeys(oldName, oldKey, defaultAttributes, fallbackAttributeKey));
    }

    @NotNull
    private static TextAttributesKey mergeKeys(@NonNls @NotNull String externalName, @Nullable TextAttributesKey oldKey, TextAttributes defaultAttributes, TextAttributesKey fallbackAttributeKey) {
        if (oldKey == null) {
            return new TextAttributesKey(externalName, defaultAttributes, fallbackAttributeKey);
        }
        if (oldKey.myFallbackAttributeKey != null && !oldKey.myFallbackAttributeKey.equals(fallbackAttributeKey)) {
            LOG.error((Throwable)new IllegalStateException("TextAttributeKey(name:'" + externalName + "', fallbackAttributeKey:'" + fallbackAttributeKey + "')  was already registered with the other fallback attribute key: " + oldKey.myFallbackAttributeKey));
        }
        if (oldKey.myDefaultAttributes != null && !oldKey.myDefaultAttributes.equals(defaultAttributes)) {
            LOG.error((Throwable)new IllegalStateException("TextAttributeKey(name:'" + externalName + "', defaultAttributes:'" + defaultAttributes + "')  was already registered with the other defaultAttributes: " + oldKey.myDefaultAttributes));
        }
        TextAttributes newDefaults = (TextAttributes)ObjectUtils.chooseNotNull((Object)defaultAttributes, (Object)oldKey.myDefaultAttributes);
        TextAttributesKey newFallback = (TextAttributesKey)ObjectUtils.chooseNotNull((Object)fallbackAttributeKey, (Object)oldKey.myFallbackAttributeKey);
        return new TextAttributesKey(externalName, newDefaults, newFallback);
    }

    @NotNull
    public static TextAttributesKey createTempTextAttributesKey(@NonNls @NotNull String externalName, TextAttributes defaultAttributes) {
        return TextAttributesKey.createTextAttributesKey(TEMP_PREFIX + externalName, defaultAttributes);
    }

    @Nullable
    public TextAttributesKey getFallbackAttributeKey() {
        return this.myFallbackAttributeKey;
    }

    @Deprecated
    public void setFallbackAttributeKey(@Nullable TextAttributesKey fallbackAttributeKey) {
    }

    static void removeTextAttributesKey(@NonNls @NotNull String externalName) {
        ourRegistry.remove(externalName);
    }

    public static boolean isTemp(@NotNull TextAttributesKey key) {
        return key.getExternalName().startsWith(TEMP_PREFIX);
    }

    @FunctionalInterface
    public static interface TextAttributeKeyDefaultsProvider {
        public TextAttributes getDefaultAttributes(@NotNull TextAttributesKey var1);
    }
}

