/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.highlighter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FragmentedEditorHighlighter
implements EditorHighlighter {
    private final List<Element> myPieces;
    private final Document myDocument;
    private final int myAdditionalOffset;
    private final boolean myMergeByTextAttributes;

    public FragmentedEditorHighlighter(EditorHighlighter highlighter, TextRange range) {
        this(highlighter.createIterator(range.getStartOffset()), Collections.singletonList(range));
    }

    public FragmentedEditorHighlighter(HighlighterIterator sourceIterator, List<? extends TextRange> ranges2) {
        this(sourceIterator, ranges2, 0, false);
    }

    public FragmentedEditorHighlighter(HighlighterIterator sourceIterator, List<? extends TextRange> ranges2, int additionalOffset, boolean mergeByTextAttributes) {
        this.myMergeByTextAttributes = mergeByTextAttributes;
        this.myDocument = sourceIterator.getDocument();
        this.myPieces = new ArrayList<Element>();
        this.myAdditionalOffset = additionalOffset;
        this.translate(sourceIterator, ranges2);
    }

    private void translate(HighlighterIterator iterator, List<? extends TextRange> ranges2) {
        int offset = 0;
        int index2 = 0;
        while (!iterator.atEnd() && index2 < ranges2.size()) {
            TextRange range = ranges2.get(index2);
            if (range.getStartOffset() >= iterator.getEnd()) {
                iterator.advance();
                continue;
            }
            if (range.getEndOffset() >= iterator.getStart()) {
                int relativeStart = Math.max(iterator.getStart() - range.getStartOffset(), 0);
                int relativeEnd = Math.min(iterator.getEnd() - range.getStartOffset(), range.getLength() + 1);
                this.addElement(new Element(offset + relativeStart, offset + relativeEnd, iterator.getTokenType(), iterator.getTextAttributes()));
            }
            if (range.getEndOffset() < iterator.getEnd()) {
                int lastEnd = this.myPieces.isEmpty() ? -1 : this.myPieces.get(this.myPieces.size() - 1).getEnd();
                this.addElement(new Element(Math.max((offset += range.getLength() + 1 + this.myAdditionalOffset) - 1 - this.myAdditionalOffset, lastEnd), offset, null, TextAttributes.ERASE_MARKER));
                ++index2;
                continue;
            }
            iterator.advance();
        }
    }

    private void addElement(@NotNull Element element) {
        Element oldElement;
        boolean merged = false;
        if (this.myMergeByTextAttributes && !this.myPieces.isEmpty() && (oldElement = this.myPieces.get(this.myPieces.size() - 1)).getEnd() >= element.getStart() && Comparing.equal((Object)oldElement.getAttributes(), (Object)element.getAttributes()) && Comparing.equal((Object)oldElement.getElementType(), (Object)element.getElementType())) {
            merged = true;
            this.myPieces.remove(this.myPieces.size() - 1);
            this.myPieces.add(new Element(oldElement.getStart(), element.getEnd(), element.getElementType(), element.getAttributes()));
        }
        if (!merged) {
            this.myPieces.add(element);
        }
    }

    @Override
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        int index2 = Collections.binarySearch(this.myPieces, new Element(startOffset, 0, null, null), Comparator.comparingInt(Element::getStart));
        if (index2 < 0) {
            index2 = Math.max(-index2 - 2, 0);
        }
        return new ProxyIterator(this.myDocument, index2);
    }

    @Override
    public void setEditor(@NotNull HighlighterClient editor) {
    }

    private static class Element {
        private final int myStart;
        private final int myEnd;
        private final IElementType myElementType;
        private final TextAttributes myAttributes;

        private Element(int start, int end, IElementType elementType, TextAttributes attributes) {
            this.myStart = start;
            this.myEnd = end;
            this.myElementType = elementType;
            this.myAttributes = attributes;
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }

        public IElementType getElementType() {
            return this.myElementType;
        }

        public TextAttributes getAttributes() {
            return this.myAttributes;
        }
    }

    private class ProxyIterator
    implements HighlighterIterator {
        private final Document myDocument;
        private int myIdx;

        private ProxyIterator(Document document, int idx) {
            this.myDocument = document;
            this.myIdx = idx;
        }

        @Override
        public TextAttributes getTextAttributes() {
            return ((Element)FragmentedEditorHighlighter.this.myPieces.get(this.myIdx)).getAttributes();
        }

        @Override
        public int getStart() {
            return ((Element)FragmentedEditorHighlighter.this.myPieces.get(this.myIdx)).getStart();
        }

        @Override
        public int getEnd() {
            return ((Element)FragmentedEditorHighlighter.this.myPieces.get(this.myIdx)).getEnd();
        }

        @Override
        public IElementType getTokenType() {
            return ((Element)FragmentedEditorHighlighter.this.myPieces.get(this.myIdx)).myElementType;
        }

        @Override
        public void advance() {
            if (this.myIdx < FragmentedEditorHighlighter.this.myPieces.size()) {
                ++this.myIdx;
            }
        }

        @Override
        public void retreat() {
            if (this.myIdx > -1) {
                --this.myIdx;
            }
        }

        @Override
        public boolean atEnd() {
            return this.myIdx < 0 || this.myIdx >= FragmentedEditorHighlighter.this.myPieces.size();
        }

        @Override
        public Document getDocument() {
            return this.myDocument;
        }
    }
}

