/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.CompositeIcon;
import com.intellij.ui.RetrievableIcon;
import com.intellij.util.ui.accessibility.SimpleAccessible;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GutterIconRenderer
implements GutterMark,
PossiblyDumbAware,
SimpleAccessible {
    @Nullable
    public ActionGroup getPopupMenuActions() {
        return null;
    }

    @Override
    @Nullable
    public String getTooltipText() {
        return null;
    }

    @Nullable
    public AnAction getClickAction() {
        return null;
    }

    @Nullable
    public AnAction getMiddleButtonClickAction() {
        return null;
    }

    @Nullable
    public AnAction getRightButtonClickAction() {
        return null;
    }

    public boolean isNavigateAction() {
        return false;
    }

    @NotNull
    public Alignment getAlignment() {
        return Alignment.CENTER;
    }

    @Nullable
    public GutterDraggableObject getDraggableObject() {
        return null;
    }

    @NotNull
    public String getAccessibleName() {
        return GutterIconRenderer.getAccessibleName(this.getIcon(), "icon: ");
    }

    private static String getAccessibleName(@Nullable Icon icon, @NotNull String prefix) {
        String path2;
        if (icon instanceof RetrievableIcon) {
            return GutterIconRenderer.getAccessibleName(((RetrievableIcon)icon).retrieveIcon(), prefix);
        }
        if (icon instanceof CompositeIcon) {
            StringBuilder b = new StringBuilder("composite icon: ");
            int count = ((CompositeIcon)icon).getIconCount();
            for (int i = 0; i < count; ++i) {
                b.append(GutterIconRenderer.getAccessibleName(((CompositeIcon)icon).getIcon(i), ""));
                if (i >= count - 1) continue;
                b.append(" & ");
            }
            return b.toString();
        }
        if (icon instanceof IconLoader.CachedImageIcon && (path2 = ((IconLoader.CachedImageIcon)icon).getOriginalPath()) != null) {
            String[] split = path2.split(Pattern.quote("/") + "|" + Pattern.quote("\\"));
            String name = split[split.length - 1];
            return prefix + name.split(Pattern.quote("."))[0];
        }
        return prefix + "unknown";
    }

    @Nullable
    public String getAccessibleTooltipText() {
        return this.getTooltipText();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static enum Alignment {
        LEFT(1),
        RIGHT(3),
        CENTER(2);

        private final int myWeight;

        private Alignment(int weight) {
            this.myWeight = weight;
        }

        public int getWeight() {
            return this.myWeight;
        }
    }
}

