/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNodeSerializer;
import com.intellij.openapi.externalSystem.model.FSTSerializer;
import com.intellij.openapi.externalSystem.model.JDKSerializer;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataNode<T>
implements Serializable,
UserDataHolderEx {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getInstance(DataNode.class);
    @NotNull
    private final List<DataNode<?>> myChildren = ContainerUtilRt.newArrayList();
    @NotNull
    private transient List<DataNode<?>> myChildrenView = Collections.unmodifiableList(this.myChildren);
    @NotNull
    private transient UserDataHolderBase myUserData = new UserDataHolderBase();
    @NotNull
    private final Key<T> myKey;
    private transient T myData;
    private byte[] myRawData;
    private boolean myIgnored;
    @Nullable
    private DataNode<?> myParent;

    public DataNode(@NotNull Key<T> key, @NotNull T data, @Nullable DataNode<?> parent) {
        this.myKey = key;
        this.myData = data;
        this.myParent = parent;
    }

    private DataNode(@NotNull Key<T> key) {
        this.myKey = key;
    }

    @Nullable
    public DataNode<?> getParent() {
        return this.myParent;
    }

    @NotNull
    public <T> DataNode<T> createChild(@NotNull Key<T> key, @NotNull T data) {
        DataNode<T> result2 = new DataNode<T>(key, data, this);
        this.myChildren.add(result2);
        return result2;
    }

    @NotNull
    public Key<T> getKey() {
        return this.myKey;
    }

    @NotNull
    public T getData() {
        if (this.myData == null) {
            this.prepareData(this.getClass().getClassLoader(), Thread.currentThread().getContextClassLoader());
        }
        return this.myData;
    }

    public boolean isIgnored() {
        return this.myIgnored;
    }

    public void setIgnored(boolean ignored) {
        this.myIgnored = ignored;
    }

    public void prepareData(ClassLoader ... loaders) {
        if (this.myData != null) {
            return;
        }
        if (this.myRawData == null) {
            throw new IllegalStateException(String.format("Data node of key '%s' does not contain raw or prepared data", this.myKey));
        }
        try {
            this.myData = this.getSerializer().readData(this.myRawData, loaders);
            assert (this.myData != null);
            this.myRawData = null;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException(String.format("Can't deserialize target data of key '%s'. Given class loaders: %s", this.myKey, Arrays.toString(loaders)), e);
        }
    }

    public void visitData(@Nullable Function visitor) {
        if (visitor == null) {
            return;
        }
        Object newData = visitor.apply(this.getData());
        if (newData != null) {
            this.myData = newData;
            this.myRawData = null;
        }
    }

    @Nullable
    public <T> T getData(@NotNull Key<T> key) {
        if (this.myKey.equals(key)) {
            return this.myData;
        }
        DataNode<?> p = this.myParent;
        while (p != null) {
            if (p.myKey.equals(key)) {
                return p.myData;
            }
            p = p.myParent;
        }
        return null;
    }

    @Nullable
    public <T> DataNode<T> getDataNode(@NotNull Key<T> key) {
        if (this.myKey.equals(key)) {
            return this;
        }
        DataNode<?> p = this.myParent;
        while (p != null) {
            if (p.myKey.equals(key)) {
                return p;
            }
            p = p.myParent;
        }
        return null;
    }

    @Nullable
    public <P> DataNode<P> getParent(@NotNull Class<P> dataClass) {
        if (dataClass.isInstance(this.myData)) {
            return this;
        }
        DataNode<?> p = this.myParent;
        while (p != null) {
            if (dataClass.isInstance(p.myData)) {
                return p;
            }
            p = p.myParent;
        }
        return null;
    }

    public void addChild(@NotNull DataNode<?> child) {
        child.myParent = this;
        this.myChildren.add(child);
    }

    @NotNull
    public Collection<DataNode<?>> getChildren() {
        return this.myChildrenView;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.myRawData = this.getDataBytes();
        }
        catch (IOException e) {
            LOG.warn("Unable to serialize the data node - " + this.toString());
            throw e;
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.myChildrenView = Collections.unmodifiableList(this.myChildren);
        this.myUserData = new UserDataHolderBase();
    }

    public void checkIsSerializable() throws IOException {
        if (this.myRawData != null) {
            return;
        }
        try (ObjectOutputStream oOut = new ObjectOutputStream(NoopOutputStream.getInstance());){
            oOut.writeObject(this.myData);
        }
    }

    public byte[] getDataBytes() throws IOException {
        if (this.myRawData != null) {
            return this.myRawData;
        }
        return this.getSerializer().getBytes(this.myData);
    }

    public int hashCode() {
        return 31 * this.myKey.hashCode() + this.getData().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataNode node = (DataNode)o;
        if (!this.myChildren.equals(node.myChildren)) {
            return false;
        }
        if (!this.getData().equals(node.getData())) {
            return false;
        }
        return this.myKey.equals(node.myKey);
    }

    public String toString() {
        String dataDescription;
        try {
            dataDescription = this.getData().toString();
        }
        catch (Exception e) {
            dataDescription = "failed to load";
            LOG.debug((Throwable)e);
        }
        return String.format("%s: %s", this.myKey, dataDescription);
    }

    public void clear(boolean removeFromGraph) {
        if (removeFromGraph && this.myParent != null) {
            Iterator<DataNode<?>> iterator = this.myParent.myChildren.iterator();
            while (iterator.hasNext()) {
                DataNode<?> dataNode = iterator.next();
                if (System.identityHashCode(dataNode) != System.identityHashCode(this)) continue;
                iterator.remove();
                break;
            }
        }
        this.myParent = null;
        this.myRawData = null;
        this.myChildren.clear();
    }

    private DataNodeSerializer<T> getSerializer() {
        switch (Registry.stringValue((String)"ext.project.data.serializer")) {
            case "auto": {
                if (SystemInfo.IS_AT_LEAST_JAVA9) {
                    return JDKSerializer.getInstance();
                }
                return FSTSerializer.getInstance();
            }
            case "jdk": {
                return JDKSerializer.getInstance();
            }
            case "fst": {
                return FSTSerializer.getInstance();
            }
        }
        return JDKSerializer.getInstance();
    }

    @NotNull
    public DataNode<T> graphCopy() {
        return DataNode.copy(this, null);
    }

    @NotNull
    public DataNode<T> nodeCopy() {
        return DataNode.nodeCopy(this);
    }

    @Nullable
    public <U> U getUserData(@NotNull com.intellij.openapi.util.Key<U> key) {
        return (U)this.myUserData.getUserData(key);
    }

    public <U> void putUserData(@NotNull com.intellij.openapi.util.Key<U> key, U value) {
        this.myUserData.putUserData(key, value);
    }

    public <U> void removeUserData(@NotNull com.intellij.openapi.util.Key<U> key) {
        this.myUserData.putUserData(key, null);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull com.intellij.openapi.util.Key<T> key, @NotNull T value) {
        return (T)this.myUserData.putUserDataIfAbsent(key, value);
    }

    public <T> boolean replace(@NotNull com.intellij.openapi.util.Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        return this.myUserData.replace(key, oldValue, newValue);
    }

    public <T> void putCopyableUserData(@NotNull com.intellij.openapi.util.Key<T> key, T value) {
        this.myUserData.putCopyableUserData(key, value);
    }

    public boolean isUserDataEmpty() {
        return this.myUserData.isUserDataEmpty();
    }

    public <T> T getCopyableUserData(@NotNull com.intellij.openapi.util.Key<T> key) {
        return (T)this.myUserData.getCopyableUserData(key);
    }

    @NotNull
    public static <T> DataNode<T> nodeCopy(@NotNull DataNode<T> dataNode) {
        DataNode<T> copy = new DataNode<T>(dataNode.myKey);
        copy.myData = dataNode.myData;
        copy.myRawData = dataNode.myRawData;
        copy.myIgnored = dataNode.myIgnored;
        dataNode.myUserData.copyCopyableDataTo(copy.myUserData);
        return copy;
    }

    @NotNull
    private static <T> DataNode<T> copy(@NotNull DataNode<T> dataNode, @Nullable DataNode<?> newParent) {
        DataNode<T> copy = DataNode.nodeCopy(dataNode);
        copy.myParent = newParent;
        for (DataNode<?> child : dataNode.myChildren) {
            copy.addChild(DataNode.copy(child, copy));
        }
        return copy;
    }

    private static class NoopOutputStream
    extends OutputStream {
        private static final NoopOutputStream ourInstance = new NoopOutputStream();

        public static NoopOutputStream getInstance() {
            return ourInstance;
        }

        private NoopOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

