/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import org.jetbrains.annotations.NotNull;

class MultiLoaderObjectInputStream
extends ObjectInputStream {
    private final ClassLoader[] myLoaders;

    MultiLoaderObjectInputStream(InputStream inputStream, ClassLoader ... loaders) throws IOException {
        super(inputStream);
        this.myLoaders = loaders;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        for (ClassLoader loader : this.myLoaders) {
            try {
                return Class.forName(name, false, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return super.resolveClass(desc);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        for (ClassLoader loader : this.myLoaders) {
            try {
                return this.doResolveProxyClass(interfaces, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return super.resolveProxyClass(interfaces);
    }

    private Class<?> doResolveProxyClass(@NotNull String[] interfaces, @NotNull ClassLoader loader) throws ClassNotFoundException {
        ClassLoader nonPublicLoader = null;
        boolean hasNonPublicInterface = false;
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> cl = Class.forName(interfaces[i], false, loader);
            if ((cl.getModifiers() & 1) == 0) {
                if (hasNonPublicInterface) {
                    if (nonPublicLoader != cl.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    nonPublicLoader = cl.getClassLoader();
                    hasNonPublicInterface = true;
                }
            }
            classObjs[i] = cl;
        }
        try {
            return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : loader, classObjs);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

