/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class ExternalProjectPojo
implements Comparable<ExternalProjectPojo> {
    @NotNull
    private String myName;
    @NotNull
    private String myPath;

    public ExternalProjectPojo() {
        this("___DUMMY___", "___DUMMY___");
    }

    public ExternalProjectPojo(@NotNull String name, @NotNull String path2) {
        this.myName = name;
        this.myPath = path2;
    }

    @NotNull
    public static <T extends Named & ExternalConfigPathAware> ExternalProjectPojo from(@NotNull T data) {
        String projectUniqueName = StringUtil.isEmpty((String)((Identifiable)data).getId()) ? data.getExternalName() : ((Identifiable)data).getId();
        return new ExternalProjectPojo(projectUniqueName, ((ExternalConfigPathAware)data).getLinkedExternalProjectPath());
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public void setName(@NotNull String name) {
        this.myName = name;
    }

    @NotNull
    public String getPath() {
        return this.myPath;
    }

    public void setPath(@NotNull String path2) {
        this.myPath = path2;
    }

    @Override
    public int compareTo(@NotNull ExternalProjectPojo that) {
        return this.myName.compareTo(that.myName);
    }

    public int hashCode() {
        int result2 = this.myName.hashCode();
        result2 = 31 * result2 + this.myPath.hashCode();
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalProjectPojo pojo = (ExternalProjectPojo)o;
        if (!this.myName.equals(pojo.myName)) {
            return false;
        }
        return this.myPath.equals(pojo.myPath);
    }

    public String toString() {
        return this.myName;
    }
}

