/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryData
extends AbstractNamedData
implements Named,
ProjectCoordinate {
    private static final long serialVersionUID = 1L;
    private final Map<LibraryPathType, Set<String>> myPaths = new HashMap<LibraryPathType, Set<String>>();
    private final boolean myUnresolved;
    private String myGroup;
    private String myArtifactId;
    private String myVersion;

    public LibraryData(@NotNull ProjectSystemId owner, @NotNull String name) {
        this(owner, name, false);
    }

    public LibraryData(@NotNull ProjectSystemId owner, @NotNull String name, boolean unresolved) {
        super(owner, name, name.isEmpty() ? "" : owner.getReadableName() + ": " + name);
        this.myUnresolved = unresolved;
    }

    @Override
    @Nullable
    public String getGroupId() {
        return this.myGroup;
    }

    public void setGroup(String group) {
        this.myGroup = group;
    }

    @Override
    @Nullable
    public String getArtifactId() {
        return this.myArtifactId;
    }

    public void setArtifactId(String artifactId) {
        this.myArtifactId = artifactId;
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(String version) {
        this.myVersion = version;
    }

    public boolean isUnresolved() {
        return this.myUnresolved;
    }

    @NotNull
    public Set<String> getPaths(@NotNull LibraryPathType type) {
        Set<String> result2 = this.myPaths.get((Object)type);
        return result2 == null ? Collections.emptySet() : result2;
    }

    public void addPath(@NotNull LibraryPathType type, @NotNull String path2) {
        Set<String> paths = this.myPaths.get((Object)type);
        if (paths == null) {
            paths = new LinkedHashSet<String>();
            this.myPaths.put(type, paths);
        }
        paths.add(ExternalSystemApiUtil.toCanonicalPath(path2));
    }

    public void forgetAllPaths() {
        this.myPaths.clear();
    }

    @Override
    public int hashCode() {
        int result2 = this.myPaths.hashCode();
        result2 = 31 * result2 + super.hashCode();
        result2 = 31 * result2 + (this.myUnresolved ? 0 : 1);
        result2 = 31 * result2 + (this.myGroup != null ? this.myGroup.hashCode() : 0);
        result2 = 31 * result2 + (this.myArtifactId != null ? this.myArtifactId.hashCode() : 0);
        result2 = 31 * result2 + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        return result2;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        LibraryData that = (LibraryData)o;
        if (this.myGroup != null ? !this.myGroup.equals(that.myGroup) : that.myGroup != null) {
            return false;
        }
        if (this.myArtifactId != null ? !this.myArtifactId.equals(that.myArtifactId) : that.myArtifactId != null) {
            return false;
        }
        if (this.myVersion != null ? !this.myVersion.equals(that.myVersion) : that.myVersion != null) {
            return false;
        }
        return super.equals(that) && this.myUnresolved == that.myUnresolved && this.myPaths.equals(that.myPaths);
    }

    public String toString() {
        String externalName = this.getExternalName();
        String displayName = StringUtil.isEmpty((String)externalName) ? this.myPaths.toString() : externalName;
        return String.format("library %s%s", displayName, this.myUnresolved ? "(unresolved)" : "");
    }
}

