/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectId
implements Serializable,
ProjectCoordinate {
    public static final String UNKNOWN_VALUE = "Unknown";
    @Nullable
    private final String myGroupId;
    @Nullable
    private final String myArtifactId;
    @Nullable
    private final String myVersion;

    public ProjectId(@Nullable String groupId, @Nullable String artifactId, @Nullable String version) {
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
        this.myVersion = version;
    }

    @Override
    @Nullable
    public String getGroupId() {
        return this.myGroupId;
    }

    @Override
    @Nullable
    public String getArtifactId() {
        return this.myArtifactId;
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    @NotNull
    public String getKey() {
        StringBuilder builder = new StringBuilder();
        ProjectId.append(builder, this.myGroupId);
        ProjectId.append(builder, this.myArtifactId);
        ProjectId.append(builder, this.myVersion);
        return builder.toString();
    }

    @NotNull
    public String getDisplayString() {
        return this.getKey();
    }

    public static void append(StringBuilder builder, String part) {
        if (builder.length() != 0) {
            builder.append(':');
        }
        builder.append(part == null ? "<unknown>" : part);
    }

    public String toString() {
        return this.getDisplayString();
    }

    public boolean equals(@Nullable String groupId, @Nullable String artifactId) {
        if (this.myArtifactId != null ? !this.myArtifactId.equals(artifactId) : artifactId != null) {
            return false;
        }
        return !(this.myGroupId != null ? !this.myGroupId.equals(groupId) : groupId != null);
    }

    public boolean equals(@Nullable String groupId, @Nullable String artifactId, @Nullable String version) {
        if (!this.equals(groupId, artifactId)) {
            return false;
        }
        return !(this.myVersion != null ? !this.myVersion.equals(version) : version != null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectId other = (ProjectId)o;
        return this.equals(other.getGroupId(), other.myArtifactId, other.myVersion);
    }

    public int hashCode() {
        int result2 = this.myGroupId != null ? this.myGroupId.hashCode() : 0;
        result2 = 31 * result2 + (this.myArtifactId != null ? this.myArtifactId.hashCode() : 0);
        result2 = 31 * result2 + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        return result2;
    }
}

