/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.settings;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemLocalSettings<S extends State> {
    protected S state;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final Project myProject;

    protected AbstractExternalSystemLocalSettings(@NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull S state) {
        this.myExternalSystemId = externalSystemId;
        this.myProject = project;
        this.state = state;
    }

    protected AbstractExternalSystemLocalSettings(@NotNull ProjectSystemId externalSystemId, @NotNull Project project) {
        this(externalSystemId, project, new State());
    }

    public void forgetExternalProjects(@NotNull Set<String> linkedProjectPathsToForget) {
        Map.Entry entry;
        Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> projects = ((State)this.state).availableProjects;
        Iterator<Object> it = projects.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!linkedProjectPathsToForget.contains(entry.getKey().getPath())) continue;
            it.remove();
        }
        if (!ContainerUtil.isEmpty(((State)this.state).recentTasks)) {
            it = ((State)this.state).recentTasks.iterator();
            while (it.hasNext()) {
                ExternalTaskExecutionInfo taskInfo = (ExternalTaskExecutionInfo)it.next();
                String path2 = taskInfo.getSettings().getExternalProjectPath();
                if (!linkedProjectPathsToForget.contains(path2) && !linkedProjectPathsToForget.contains(ExternalSystemApiUtil.getRootProjectPath(path2, this.myExternalSystemId, this.myProject))) continue;
                it.remove();
            }
        }
        it = ((State)this.state).projectBuildClasspath.entrySet().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            if (!linkedProjectPathsToForget.contains(entry.getKey()) && !linkedProjectPathsToForget.contains(ExternalSystemApiUtil.getRootProjectPath((String)entry.getKey(), this.myExternalSystemId, this.myProject))) continue;
            it.remove();
        }
        it = ((State)this.state).projectSyncType.entrySet().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            if (!linkedProjectPathsToForget.contains(entry.getKey()) && !linkedProjectPathsToForget.contains(ExternalSystemApiUtil.getRootProjectPath((String)entry.getKey(), this.myExternalSystemId, this.myProject))) continue;
            it.remove();
        }
        Map<String, Long> modificationStamps = ((State)this.state).modificationStamps;
        for (String path2 : linkedProjectPathsToForget) {
            modificationStamps.remove(path2);
        }
    }

    @NotNull
    public Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> getAvailableProjects() {
        return ((State)this.state).availableProjects;
    }

    public void setAvailableProjects(@NotNull Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> projects) {
        ((State)this.state).availableProjects = projects;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019")
    @NotNull
    public Map<String, Collection<ExternalTaskPojo>> getAvailableTasks() {
        return Collections.emptyMap();
    }

    @NotNull
    public List<ExternalTaskExecutionInfo> getRecentTasks() {
        return ContainerUtil.notNullize(((State)this.state).recentTasks);
    }

    @NotNull
    public Map<String, Long> getExternalConfigModificationStamps() {
        return ((State)this.state).modificationStamps;
    }

    @NotNull
    public Map<String, ExternalProjectBuildClasspathPojo> getProjectBuildClasspath() {
        return ((State)this.state).projectBuildClasspath;
    }

    @NotNull
    public Map<String, SyncType> getProjectSyncType() {
        return ((State)this.state).projectSyncType;
    }

    @Nullable
    public S getState() {
        return this.state;
    }

    public void loadState(@NotNull State state) {
        this.state = state;
        this.pruneOutdatedEntries();
    }

    private void pruneOutdatedEntries() {
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(this.myExternalSystemId);
        assert (manager != null);
        HashSet pathsToForget = ContainerUtilRt.newHashSet();
        for (ExternalProjectPojo pojo : ((State)this.state).availableProjects.keySet()) {
            pathsToForget.add(pojo.getPath());
        }
        for (ExternalTaskExecutionInfo taskInfo : ContainerUtil.notNullize(((State)this.state).recentTasks)) {
            pathsToForget.add(taskInfo.getSettings().getExternalProjectPath());
        }
        AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject);
        for (ExternalProjectSettings projectSettings : settings.getLinkedProjectsSettings()) {
            pathsToForget.remove(projectSettings.getExternalProjectPath());
        }
        for (Module module : ModuleManager.getInstance(this.myProject).getModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule(this.myExternalSystemId, module)) continue;
            pathsToForget.remove(ExternalSystemApiUtil.getExternalProjectPath(module));
        }
        if (!pathsToForget.isEmpty()) {
            this.forgetExternalProjects(pathsToForget);
        }
    }

    public void setProjectBuildClasspath(Map<String, ExternalProjectBuildClasspathPojo> value) {
        ((State)this.state).projectBuildClasspath = value;
    }

    @Deprecated
    public void fillState(@NotNull State otherState) {
        otherState.recentTasks.clear();
        otherState.availableProjects = ((State)this.state).availableProjects;
        otherState.modificationStamps = ((State)this.state).modificationStamps;
        otherState.projectBuildClasspath = ((State)this.state).projectBuildClasspath;
        otherState.projectSyncType = ((State)this.state).projectSyncType;
    }

    public static enum SyncType {
        PREVIEW,
        IMPORT,
        RE_IMPORT;

    }

    public static class State {
        public final List<ExternalTaskExecutionInfo> recentTasks = new SmartList();
        public Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> availableProjects = new THashMap();
        public Map<String, Long> modificationStamps = new THashMap();
        public Map<String, ExternalProjectBuildClasspathPojo> projectBuildClasspath = new THashMap();
        public Map<String, SyncType> projectSyncType = new THashMap();
    }
}

