/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemApiUtil {
    @NotNull
    public static final String PATH_SEPARATOR = "/";
    @NotNull
    public static final Comparator<Object> ORDER_AWARE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(@NotNull Object o1, @NotNull Object o2) {
            int order1 = this.getOrder(o1);
            int order2 = this.getOrder(o2);
            return Integer.compare(order1, order2);
        }

        private int getOrder(@NotNull Object o) {
            ArrayDeque toCheck = new ArrayDeque();
            toCheck.add(o.getClass());
            while (!toCheck.isEmpty()) {
                Class clazz = (Class)toCheck.poll();
                Order annotation = clazz.getAnnotation(Order.class);
                if (annotation != null) {
                    return annotation.value();
                }
                Class c = clazz.getSuperclass();
                if (c != null) {
                    toCheck.add(c);
                }
                Class<?>[] interfaces = clazz.getInterfaces();
                Collections.addAll(toCheck, interfaces);
            }
            return 1000;
        }
    };
    @NotNull
    private static final NullableFunction<DataNode<?>, Key<?>> GROUPER = node -> node.getKey();

    private ExternalSystemApiUtil() {
    }

    @NotNull
    public static String extractNameFromPath(@NotNull String path2) {
        String strippedPath = ExternalSystemApiUtil.stripPath(path2);
        int i = strippedPath.lastIndexOf(PATH_SEPARATOR);
        String result2 = i < 0 || i >= strippedPath.length() - 1 ? strippedPath : strippedPath.substring(i + 1);
        return result2;
    }

    @NotNull
    private static String stripPath(@NotNull String path2) {
        String[] endingsToStrip = new String[]{PATH_SEPARATOR, "!", ".jar"};
        StringBuilder buffer = new StringBuilder(path2);
        for (String ending : endingsToStrip) {
            if (buffer.lastIndexOf(ending) != buffer.length() - ending.length()) continue;
            buffer.setLength(buffer.length() - ending.length());
        }
        return buffer.toString();
    }

    @NotNull
    public static String getLibraryName(@NotNull Library library) {
        String result2 = library.getName();
        if (result2 != null) {
            return result2;
        }
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            for (String url : library.getUrls(type)) {
                String candidate = ExternalSystemApiUtil.extractNameFromPath(url);
                if (StringUtil.isEmpty((String)candidate)) continue;
                return candidate;
            }
        }
        assert (false);
        return "unknown-lib";
    }

    public static boolean isRelated(@NotNull Library library, @NotNull LibraryData libraryData) {
        return ExternalSystemApiUtil.getLibraryName(library).equals(libraryData.getInternalName());
    }

    public static boolean isExternalSystemLibrary(@NotNull Library library, @NotNull ProjectSystemId externalSystemId) {
        return library.getName() != null && StringUtil.startsWithIgnoreCase((String)library.getName(), (String)(externalSystemId.getId() + ": "));
    }

    public static void orderAwareSort(@NotNull List<?> data) {
        Collections.sort(data, ORDER_AWARE_COMPARATOR);
    }

    @NotNull
    public static String toCanonicalPath(@NotNull String path2) {
        String p = ExternalSystemApiUtil.normalizePath(new File(path2).getAbsolutePath());
        assert (p != null);
        return PathUtil.getCanonicalPath(p);
    }

    @NotNull
    public static String getLocalFileSystemPath(@NotNull VirtualFile file) {
        VirtualFile jar;
        if (file.getFileType() == ArchiveFileType.INSTANCE && (jar = JarFileSystem.getInstance().getVirtualFileForJar(file)) != null) {
            return jar.getPath();
        }
        return ExternalSystemApiUtil.toCanonicalPath(file.getPath());
    }

    @Nullable
    public static ExternalSystemManager<?, ?, ?, ?, ?> getManager(@NotNull ProjectSystemId externalSystemId) {
        for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
            if (!externalSystemId.equals(manager.getSystemId())) continue;
            return manager;
        }
        return null;
    }

    @NotNull
    public static List<ExternalSystemManager<?, ?, ?, ?, ?>> getAllManagers() {
        return ExternalSystemManager.EP_NAME.getExtensionList();
    }

    public static MultiMap<Key<?>, DataNode<?>> recursiveGroup(@NotNull Collection<DataNode<?>> nodes) {
        ContainerUtil.KeyOrderedMultiMap result2 = new ContainerUtil.KeyOrderedMultiMap();
        LinkedList queue = ContainerUtil.newLinkedList();
        queue.add(nodes);
        while (!queue.isEmpty()) {
            Collection _nodes = (Collection)queue.remove();
            result2.putAllValues(ExternalSystemApiUtil.group(_nodes));
            for (DataNode _node : _nodes) {
                queue.add(_node.getChildren());
            }
        }
        return result2;
    }

    @NotNull
    public static MultiMap<Key<?>, DataNode<?>> group(@NotNull Collection<? extends DataNode<?>> nodes) {
        return ContainerUtil.groupBy(nodes, GROUPER);
    }

    @NotNull
    public static <K, V> MultiMap<DataNode<K>, DataNode<V>> groupBy(@NotNull Collection<? extends DataNode<V>> nodes, Class<K> moduleDataClass) {
        return ContainerUtil.groupBy(nodes, node -> node.getParent(moduleDataClass));
    }

    @NotNull
    public static <K, V> MultiMap<DataNode<K>, DataNode<V>> groupBy(@NotNull Collection<? extends DataNode<V>> nodes, @NotNull Key<K> key) {
        return ContainerUtil.groupBy(nodes, node -> node.getDataNode(key));
    }

    @NotNull
    public static <T> Collection<DataNode<T>> getChildren(@NotNull DataNode<?> node, @NotNull Key<T> key) {
        ArrayList result2 = null;
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey())) continue;
            if (result2 == null) {
                result2 = ContainerUtilRt.newArrayList();
            }
            result2.add(child);
        }
        return result2 == null ? Collections.emptyList() : result2;
    }

    @Nullable
    public static <T> DataNode<T> find(@NotNull DataNode<?> node, @NotNull Key<T> key) {
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey())) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static <T> DataNode<T> find(@NotNull DataNode<?> node, @NotNull Key<T> key, BooleanFunction<? super DataNode<T>> predicate) {
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey()) || !predicate.fun(child)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static <T> DataNode<T> findParent(@NotNull DataNode<?> node, @NotNull Key<T> key) {
        return ExternalSystemApiUtil.findParent(node, key, null);
    }

    @Nullable
    public static <T> DataNode<T> findParent(@NotNull DataNode<?> node, @NotNull Key<T> key, @Nullable BooleanFunction<? super DataNode<T>> predicate) {
        DataNode<?> parent = node.getParent();
        if (parent == null) {
            return null;
        }
        return key.equals(parent.getKey()) && (predicate == null || predicate.fun(parent)) ? parent : ExternalSystemApiUtil.findParent(parent, key, predicate);
    }

    @NotNull
    public static <T> Collection<DataNode<T>> findAll(@NotNull DataNode<?> parent, @NotNull Key<T> key) {
        return ExternalSystemApiUtil.getChildren(parent, key);
    }

    public static void visit(@Nullable DataNode node, @NotNull Consumer<? super DataNode<?>> consumer) {
        if (node == null) {
            return;
        }
        Stack toProcess = ContainerUtil.newStack((Object[])new DataNode[]{node});
        while (!toProcess.isEmpty()) {
            DataNode node0 = (DataNode)toProcess.pop();
            consumer.consume((Object)node0);
            for (DataNode<?> child : node0.getChildren()) {
                toProcess.push(child);
            }
        }
    }

    @NotNull
    public static <T> Collection<DataNode<T>> findAllRecursively(@Nullable DataNode<?> node, @NotNull Key<T> key) {
        if (node == null) {
            return Collections.emptyList();
        }
        Collection<DataNode<?>> nodes = ExternalSystemApiUtil.findAllRecursively(node.getChildren(), node1 -> node1.getKey().equals(key));
        return new SmartList(nodes);
    }

    @NotNull
    public static Collection<DataNode<?>> findAllRecursively(@NotNull Collection<? extends DataNode<?>> nodes) {
        return ExternalSystemApiUtil.findAllRecursively(nodes, null);
    }

    @NotNull
    public static Collection<DataNode<?>> findAllRecursively(@Nullable DataNode<?> node, @Nullable BooleanFunction<? super DataNode<?>> predicate) {
        if (node == null) {
            return Collections.emptyList();
        }
        return ExternalSystemApiUtil.findAllRecursively(node.getChildren(), predicate);
    }

    @NotNull
    public static Collection<DataNode<?>> findAllRecursively(@NotNull Collection<? extends DataNode<?>> nodes, @Nullable BooleanFunction<? super DataNode<?>> predicate) {
        SmartList result2 = new SmartList();
        for (DataNode<?> node : nodes) {
            if (predicate != null && !predicate.fun(node)) continue;
            result2.add(node);
        }
        for (DataNode<?> node : nodes) {
            result2.addAll(ExternalSystemApiUtil.findAllRecursively(node.getChildren(), predicate));
        }
        return result2;
    }

    @Nullable
    public static DataNode<?> findFirstRecursively(@NotNull DataNode<?> parentNode, @NotNull BooleanFunction<? super DataNode<?>> predicate) {
        LinkedList queue = new LinkedList();
        queue.add(parentNode);
        return ExternalSystemApiUtil.findInQueue(queue, predicate);
    }

    @Nullable
    public static DataNode<?> findFirstRecursively(@NotNull Collection<? extends DataNode<?>> nodes, @NotNull BooleanFunction<? super DataNode<?>> predicate) {
        return ExternalSystemApiUtil.findInQueue(new LinkedList(nodes), predicate);
    }

    @Nullable
    private static DataNode<?> findInQueue(@NotNull Queue<DataNode<?>> queue, @NotNull BooleanFunction<? super DataNode<?>> predicate) {
        while (!queue.isEmpty()) {
            DataNode<?> node = queue.remove();
            if (predicate.fun(node)) {
                return node;
            }
            queue.addAll(node.getChildren());
        }
        return null;
    }

    public static void executeProjectChangeAction(@NotNull DisposeAwareProjectChange task) {
        ExternalSystemApiUtil.executeProjectChangeAction(true, task);
    }

    public static void executeProjectChangeAction(boolean synchronous, @NotNull DisposeAwareProjectChange task) {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        }
        ExternalSystemApiUtil.executeOnEdt(synchronous, () -> ApplicationManager.getApplication().runWriteAction(task));
    }

    public static void executeOnEdt(boolean synchronous, @NotNull Runnable task) {
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            task.run();
            return;
        }
        if (synchronous) {
            app.invokeAndWait(task);
        } else {
            app.invokeLater(task);
        }
    }

    public static <T> T executeOnEdt(@NotNull Computable<T> task) {
        Application app = ApplicationManager.getApplication();
        Ref result2 = Ref.create();
        app.invokeAndWait(() -> result2.set(task.compute()));
        return (T)result2.get();
    }

    public static <T> T doWriteAction(@NotNull Computable<T> task) {
        return ExternalSystemApiUtil.executeOnEdt(() -> ApplicationManager.getApplication().runWriteAction(task));
    }

    public static void doWriteAction(@NotNull Runnable task) {
        ExternalSystemApiUtil.executeOnEdt(true, () -> ApplicationManager.getApplication().runWriteAction(task));
    }

    public static void addToInvokeLater(Runnable runnable) {
        Application application = ApplicationManager.getApplication();
        boolean unitTestMode = application.isUnitTestMode();
        if (unitTestMode) {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        } else if (application.isHeadlessEnvironment() || application.isDispatchThread()) {
            runnable.run();
        } else {
            EdtExecutorService.getInstance().execute(runnable);
        }
    }

    public static void addBundle(@NotNull PathsList classPath, @NotNull String bundlePath, @NotNull Class<?> contextClass) {
        String root;
        String pathToUse = bundlePath.replace('.', '/');
        if (!pathToUse.endsWith(".properties")) {
            pathToUse = pathToUse + ".properties";
        }
        if (!pathToUse.startsWith(PATH_SEPARATOR)) {
            pathToUse = '/' + pathToUse;
        }
        if ((root = PathManager.getResourceRoot(contextClass, (String)pathToUse)) != null) {
            classPath.add(root);
        }
    }

    @Nullable
    public static String normalizePath(@Nullable String s) {
        return StringUtil.isEmpty((String)s) ? null : s.replace('\\', '/');
    }

    public static boolean isOneToOneMapping(@NotNull Project ideProject, @NotNull ProjectData projectData) {
        String linkedExternalProjectPath = null;
        for (ExternalSystemManager<?, ?, ?, ?, ?> manager : ExternalSystemApiUtil.getAllManagers()) {
            ProjectSystemId externalSystemId = manager.getSystemId();
            AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings(ideProject, externalSystemId);
            Collection projectsSettings = systemSettings.getLinkedProjectsSettings();
            int linkedProjectsNumber = projectsSettings.size();
            if (linkedProjectsNumber > 1) {
                return false;
            }
            if (linkedProjectsNumber != 1) continue;
            if (linkedExternalProjectPath == null) {
                linkedExternalProjectPath = ((ExternalProjectSettings)projectsSettings.iterator().next()).getExternalProjectPath();
                continue;
            }
            return false;
        }
        if (linkedExternalProjectPath != null && !linkedExternalProjectPath.equals(projectData.getLinkedExternalProjectPath())) {
            return false;
        }
        for (Module module : ModuleManager.getInstance(ideProject).getModules()) {
            if (ExternalSystemApiUtil.isExternalSystemAwareModule(projectData.getOwner(), module)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static String getProjectRepresentationName(@NotNull String targetProjectPath, @Nullable String rootProjectPath) {
        File targetProjectDir;
        if (rootProjectPath == null) {
            File rootProjectDir = new File(targetProjectPath);
            if (rootProjectDir.isFile()) {
                rootProjectDir = rootProjectDir.getParentFile();
            }
            return rootProjectDir.getName();
        }
        File rootProjectDir = new File(rootProjectPath);
        if (rootProjectDir.isFile()) {
            rootProjectDir = rootProjectDir.getParentFile();
        }
        if ((targetProjectDir = new File(targetProjectPath)).isFile()) {
            targetProjectDir = targetProjectDir.getParentFile();
        }
        StringBuilder buffer = new StringBuilder();
        for (File f = targetProjectDir; f != null && !FileUtil.filesEqual((File)f, (File)rootProjectDir); f = f.getParentFile()) {
            buffer.insert(0, f.getName()).insert(0, ":");
        }
        buffer.insert(0, rootProjectDir.getName());
        return buffer.toString();
    }

    @Nullable
    public static String getRootProjectPath(@NotNull String externalProjectPath, @NotNull ProjectSystemId externalSystemId, @NotNull Project project) {
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(externalSystemId);
        if (manager == null) {
            return null;
        }
        if (manager instanceof ExternalSystemAutoImportAware) {
            return ((ExternalSystemAutoImportAware)((Object)manager)).getAffectedExternalProjectPath(externalProjectPath, project);
        }
        return null;
    }

    @NotNull
    public static String buildErrorMessage(@NotNull Throwable e) {
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)e);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return ExternalSystemApiUtil.stacktraceAsString(unwrapped);
        }
        String reason = unwrapped.getLocalizedMessage();
        if (!StringUtil.isEmpty((String)reason)) {
            return reason;
        }
        if (unwrapped.getClass() == ExternalSystemException.class) {
            return String.format("exception during working with external system: %s", ((ExternalSystemException)unwrapped).getOriginalReason());
        }
        return ExternalSystemApiUtil.stacktraceAsString(unwrapped);
    }

    private static String stacktraceAsString(Throwable unwrapped) {
        StringWriter writer = new StringWriter();
        unwrapped.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    @NotNull
    public static AbstractExternalSystemSettings getSettings(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) throws IllegalArgumentException {
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(externalSystemId);
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve external system settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        return (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
    }

    public static <S extends AbstractExternalSystemLocalSettings> S getLocalSettings(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) throws IllegalArgumentException {
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(externalSystemId);
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve local external system settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        return (S)((AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project));
    }

    public static <S extends ExternalSystemExecutionSettings> S getExecutionSettings(@NotNull Project project, @NotNull String linkedProjectPath, @NotNull ProjectSystemId externalSystemId) throws IllegalArgumentException {
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(externalSystemId);
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve external system execution settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        return (S)((ExternalSystemExecutionSettings)manager.getExecutionSettingsProvider().fun((Object)Pair.create((Object)project, (Object)linkedProjectPath)));
    }

    public static boolean isInProcessMode(ProjectSystemId externalSystemId) {
        return Registry.is((String)(externalSystemId.getId() + ".system.in.process"), (boolean)false);
    }

    public static ProjectModelExternalSource toExternalSource(@NotNull ProjectSystemId systemId) {
        return ExternalProjectSystemRegistry.getInstance().getSourceById(systemId.getId());
    }

    @Contract(value="_, null -> false", pure=true)
    public static boolean isExternalSystemAwareModule(@NotNull ProjectSystemId systemId, @Nullable Module module) {
        return module != null && !module.isDisposed() && systemId.getId().equals(ExternalSystemModulePropertyManager.getInstance(module).getExternalSystemId());
    }

    @Contract(value="_, null -> false", pure=true)
    public static boolean isExternalSystemAwareModule(@NotNull String systemId, @Nullable Module module) {
        return module != null && !module.isDisposed() && systemId.equals(ExternalSystemModulePropertyManager.getInstance(module).getExternalSystemId());
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectPath(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getLinkedProjectPath() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalRootProjectPath(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getRootProjectPath() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectId(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getLinkedProjectId() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectGroup(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getExternalModuleGroup() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectVersion(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getExternalModuleVersion() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalModuleType(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getExternalModuleType() : null;
    }

    public static void subscribe(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull ExternalSystemSettingsListener listener) {
        ExternalSystemApiUtil.getSettings(project, systemId).subscribe(listener);
    }

    @NotNull
    public static Collection<TaskData> findProjectTasks(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull String projectPath) {
        AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings(project, systemId);
        Object linkedProjectSettings = settings.getLinkedProjectSettings(projectPath);
        if (linkedProjectSettings == null) {
            return Collections.emptyList();
        }
        ExternalProjectInfo projectInfo = ProjectDataManager.getInstance().getExternalProjectsData(project, systemId).stream().filter(info -> FileUtil.pathsEqual((String)linkedProjectSettings.getExternalProjectPath(), (String)info.getExternalProjectPath())).findFirst().orElse(null);
        if (projectInfo == null) {
            return Collections.emptyList();
        }
        DataNode<ProjectData> projectStructure = projectInfo.getExternalProjectStructure();
        if (projectStructure == null) {
            return Collections.emptyList();
        }
        List tasks = ContainerUtil.newSmartList();
        DataNode moduleDataNode = ExternalSystemApiUtil.findAll(projectStructure, ProjectKeys.MODULE).stream().filter(moduleNode -> FileUtil.pathsEqual((String)projectPath, (String)((ModuleData)moduleNode.getData()).getLinkedExternalProjectPath())).findFirst().orElse(null);
        if (moduleDataNode == null) {
            return Collections.emptyList();
        }
        ExternalSystemApiUtil.findAll(moduleDataNode, ProjectKeys.TASK).stream().map(DataNode::getData).forEach(tasks::add);
        return tasks;
    }

    @ApiStatus.Experimental
    @Nullable
    public static DataNode<ModuleData> findModuleData(@NotNull Module module, @NotNull ProjectSystemId systemId) {
        String externalProjectPath = ExternalSystemApiUtil.getExternalProjectPath(module);
        if (externalProjectPath == null) {
            return null;
        }
        Project project = module.getProject();
        DataNode<ProjectData> projectNode = ExternalSystemApiUtil.findProjectData(project, systemId, externalProjectPath);
        if (projectNode == null) {
            return null;
        }
        return ExternalSystemApiUtil.find(projectNode, ProjectKeys.MODULE, node -> externalProjectPath.equals(((ModuleData)node.getData()).getLinkedExternalProjectPath()));
    }

    @ApiStatus.Experimental
    @Nullable
    public static DataNode<ProjectData> findProjectData(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull String projectPath) {
        ExternalProjectInfo projectInfo = ExternalSystemApiUtil.findProjectInfo(project, systemId, projectPath);
        if (projectInfo == null) {
            return null;
        }
        return projectInfo.getExternalProjectStructure();
    }

    @ApiStatus.Experimental
    @Nullable
    public static ExternalProjectInfo findProjectInfo(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull String projectPath) {
        AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings(project, systemId);
        Object linkedProjectSettings = settings.getLinkedProjectSettings(projectPath);
        if (linkedProjectSettings == null) {
            return null;
        }
        return ProjectDataManager.getInstance().getExternalProjectsData(project, systemId).stream().filter(info -> FileUtil.pathsEqual((String)linkedProjectSettings.getExternalProjectPath(), (String)info.getExternalProjectPath())).findFirst().orElse(null);
    }

    @Deprecated
    @ApiStatus.Experimental
    public static boolean isJavaCompatibleIde() {
        return PlatformUtils.isIdeaUltimate() || PlatformUtils.isIdeaCommunity() || "AndroidStudio".equals(PlatformUtils.getPlatformPrefix());
    }
}

