/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.Topic;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

public interface FileEditorManagerListener
extends EventListener {
    public static final Topic<FileEditorManagerListener> FILE_EDITOR_MANAGER = new Topic("file editor events", FileEditorManagerListener.class, Topic.BroadcastDirection.TO_PARENT);

    default public void fileOpenedSync(@NotNull FileEditorManager source, @NotNull VirtualFile file, @NotNull Pair<FileEditor[], FileEditorProvider[]> editors) {
    }

    default public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
    }

    default public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
    }

    default public void selectionChanged(@NotNull FileEditorManagerEvent event) {
    }

    public static interface Before
    extends EventListener {
        public static final Topic<Before> FILE_EDITOR_MANAGER = new Topic("file editor before events", Before.class, Topic.BroadcastDirection.TO_PARENT);

        default public void beforeFileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        }

        default public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        }

        @Deprecated
        public static class Adapter
        implements Before {
            @Override
            public void beforeFileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            }

            @Override
            public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            }
        }
    }
}

