/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.ide.DataManager;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenFileDescriptor
implements Navigatable,
Comparable<OpenFileDescriptor> {
    public static final DataKey<Editor> NAVIGATE_IN_EDITOR = DataKey.create("NAVIGATE_IN_EDITOR");
    private final Project myProject;
    private final VirtualFile myFile;
    private final int myLogicalLine;
    private final int myLogicalColumn;
    private final int myOffset;
    private final RangeMarker myRangeMarker;
    private boolean myUseCurrentWindow;
    private ScrollType myScrollType = ScrollType.CENTER;

    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, int offset) {
        this(project, file, -1, -1, offset, false);
    }

    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, int logicalLine, int logicalColumn) {
        this(project, file, logicalLine, logicalColumn, -1, false);
    }

    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, int logicalLine, int logicalColumn, boolean persistent) {
        this(project, file, logicalLine, logicalColumn, -1, persistent);
    }

    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file) {
        this(project, file, -1, -1, -1, false);
    }

    private OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, int logicalLine, int logicalColumn, int offset, boolean persistent) {
        this.myProject = project;
        this.myFile = file;
        this.myLogicalLine = logicalLine;
        this.myLogicalColumn = logicalColumn;
        this.myOffset = offset;
        this.myRangeMarker = offset >= 0 ? LazyRangeMarkerFactory.getInstance(project).createRangeMarker(file, offset) : (logicalLine >= 0 ? LazyRangeMarkerFactory.getInstance(project).createRangeMarker(file, logicalLine, Math.max(0, logicalColumn), persistent) : null);
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Nullable
    public RangeMarker getRangeMarker() {
        return this.myRangeMarker;
    }

    public int getOffset() {
        return this.myRangeMarker != null && this.myRangeMarker.isValid() ? this.myRangeMarker.getStartOffset() : this.myOffset;
    }

    public int getLine() {
        return this.myLogicalLine;
    }

    public int getColumn() {
        return this.myLogicalColumn;
    }

    @Override
    public void navigate(boolean requestFocus) {
        if (!this.canNavigate()) {
            throw new IllegalStateException("target not valid");
        }
        if (!this.myFile.isDirectory() && this.navigateInEditorOrNativeApp(this.myProject, requestFocus)) {
            return;
        }
        if (this.navigateInProjectView(requestFocus)) {
            return;
        }
        String message = IdeBundle.message("error.files.of.this.type.cannot.be.opened", ApplicationNamesInfo.getInstance().getProductName());
        Messages.showErrorDialog(this.myProject, message, IdeBundle.message("title.cannot.open.file", new Object[0]));
    }

    private boolean navigateInEditorOrNativeApp(@NotNull Project project, boolean requestFocus) {
        FileType type = FileTypeManager.getInstance().getKnownFileTypeOrAssociate(this.myFile, project);
        if (type == null || !this.myFile.isValid()) {
            return false;
        }
        if (type instanceof INativeFileType) {
            return ((INativeFileType)type).openFileInAssociatedApplication(project, this.myFile);
        }
        return this.navigateInEditor(project, requestFocus);
    }

    public boolean navigateInEditor(@NotNull Project project, boolean requestFocus) {
        return this.navigateInRequestedEditor() || this.navigateInAnyFileEditor(project, requestFocus);
    }

    private boolean navigateInRequestedEditor() {
        DataContext ctx = DataManager.getInstance().getDataContext();
        Editor e = NAVIGATE_IN_EDITOR.getData(ctx);
        if (e == null) {
            return false;
        }
        if (!Comparing.equal((Object)FileDocumentManager.getInstance().getFile(e.getDocument()), (Object)this.myFile)) {
            return false;
        }
        this.navigateIn(e);
        return true;
    }

    protected boolean navigateInAnyFileEditor(Project project, boolean focusEditor) {
        List<FileEditor> editors = FileEditorManager.getInstance(project).openEditor(this, focusEditor);
        for (FileEditor editor : editors) {
            if (!(editor instanceof TextEditor)) continue;
            Editor e = ((TextEditor)editor).getEditor();
            FileEditorManager.getInstance(this.myProject).runWhenLoaded(e, () -> {
                OpenFileDescriptor.unfoldCurrentLine(e);
                if (focusEditor) {
                    IdeFocusManager.getInstance(this.myProject).requestFocus(e.getContentComponent(), true);
                }
            });
        }
        return !editors.isEmpty();
    }

    private boolean navigateInProjectView(boolean requestFocus) {
        FileSelectInContext context = new FileSelectInContext(this.myProject, this.myFile, null);
        for (SelectInTarget target : SelectInManager.getInstance(this.myProject).getTargets()) {
            if (!context.selectIn(target, requestFocus)) continue;
            return true;
        }
        return false;
    }

    public void navigateIn(@NotNull Editor e) {
        int offset = this.getOffset();
        CaretModel caretModel = e.getCaretModel();
        boolean caretMoved = false;
        if (this.myLogicalLine >= 0) {
            LogicalPosition pos = new LogicalPosition(this.myLogicalLine, Math.max(this.myLogicalColumn, 0));
            if (offset < 0 || offset == e.logicalPositionToOffset(pos)) {
                caretModel.removeSecondaryCarets();
                caretModel.moveToLogicalPosition(pos);
                caretMoved = true;
            }
        }
        if (!caretMoved && offset >= 0) {
            caretModel.removeSecondaryCarets();
            caretModel.moveToOffset(Math.min(offset, e.getDocument().getTextLength()));
            caretMoved = true;
        }
        if (caretMoved) {
            e.getSelectionModel().removeSelection();
            FileEditorManager.getInstance(this.myProject).runWhenLoaded(e, () -> {
                this.scrollToCaret(e);
                OpenFileDescriptor.unfoldCurrentLine(e);
            });
        }
    }

    protected static void unfoldCurrentLine(@NotNull Editor editor) {
        FoldRegion[] allRegions = editor.getFoldingModel().getAllFoldRegions();
        TextRange range = OpenFileDescriptor.getRangeToUnfoldOnNavigation(editor);
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            for (FoldRegion region : allRegions) {
                if (region.isExpanded() || !range.intersects(TextRange.create((Segment)region))) continue;
                region.setExpanded(true);
            }
        });
    }

    @NotNull
    public static TextRange getRangeToUnfoldOnNavigation(@NotNull Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        int line = editor.getDocument().getLineNumber(offset);
        int start = editor.getDocument().getLineStartOffset(line);
        int end = editor.getDocument().getLineEndOffset(line);
        return new TextRange(start, end);
    }

    private void scrollToCaret(@NotNull Editor e) {
        e.getScrollingModel().scrollToCaret(this.myScrollType);
    }

    @Override
    public boolean canNavigate() {
        return this.myFile.isValid();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public OpenFileDescriptor setUseCurrentWindow(boolean search) {
        this.myUseCurrentWindow = search;
        return this;
    }

    public boolean isUseCurrentWindow() {
        return this.myUseCurrentWindow;
    }

    public void setScrollType(@NotNull ScrollType scrollType) {
        this.myScrollType = scrollType;
    }

    public void dispose() {
        if (this.myRangeMarker != null) {
            this.myRangeMarker.dispose();
        }
    }

    @Override
    public int compareTo(@NotNull OpenFileDescriptor o) {
        int i = this.myProject.getName().compareTo(o.myProject.getName());
        if (i != 0) {
            return i;
        }
        i = this.myFile.getName().compareTo(o.myFile.getName());
        if (i != 0) {
            return i;
        }
        if (this.myRangeMarker != null) {
            if (o.myRangeMarker == null) {
                return 1;
            }
            i = this.myRangeMarker.getStartOffset() - o.myRangeMarker.getStartOffset();
            if (i != 0) {
                return i;
            }
            return this.myRangeMarker.getEndOffset() - o.myRangeMarker.getEndOffset();
        }
        return o.myRangeMarker == null ? 0 : -1;
    }
}

