/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.nio.charset.Charset;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharsetUtil {
    private static final Map<LanguageFileType, Boolean> ourSupportsCharsetDetection = ConcurrentFactoryMap.createMap(fileType -> {
        Class<?> ftClass = fileType.getClass();
        String methodName = "extractCharsetFromFileContent";
        Class declaring1 = ReflectionUtil.getMethodDeclaringClass(ftClass, (String)methodName, (Class[])new Class[]{Project.class, VirtualFile.class, String.class});
        Class declaring2 = ReflectionUtil.getMethodDeclaringClass(ftClass, (String)methodName, (Class[])new Class[]{Project.class, VirtualFile.class, CharSequence.class});
        return !LanguageFileType.class.equals((Object)declaring1) || !LanguageFileType.class.equals((Object)declaring2);
    });

    public static Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile virtualFile2, @Nullable FileType fileType, @NotNull CharSequence text) {
        if (fileType instanceof LanguageFileType && ourSupportsCharsetDetection.get(fileType).booleanValue()) {
            return ((LanguageFileType)fileType).extractCharsetFromFileContent(project, virtualFile2, text);
        }
        return null;
    }
}

