/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeEditorHighlighterProviders
extends FileTypeExtension<EditorHighlighterProvider> {
    public static final FileTypeEditorHighlighterProviders INSTANCE = new FileTypeEditorHighlighterProviders();

    private FileTypeEditorHighlighterProviders() {
        super("com.intellij.editorHighlighterProvider");
    }

    @Override
    @NotNull
    protected List<EditorHighlighterProvider> buildExtensions(@NotNull String stringKey, @NotNull FileType key) {
        List<EditorHighlighterProvider> fromEP = super.buildExtensions(stringKey, key);
        if (fromEP.isEmpty()) {
            EditorHighlighterProvider defaultProvider = new EditorHighlighterProvider(){

                @Override
                public EditorHighlighter getEditorHighlighter(@Nullable Project project, @NotNull FileType fileType, @Nullable VirtualFile virtualFile2, @NotNull EditorColorsScheme colors) {
                    return EditorHighlighterFactory.getInstance().createEditorHighlighter(SyntaxHighlighterFactory.getSyntaxHighlighter(fileType, project, virtualFile2), colors);
                }
            };
            return Collections.singletonList(defaultProvider);
        }
        return fromEP;
    }
}

