/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class UserFileType<T extends UserFileType>
implements FileType,
Cloneable {
    @NotNull
    private String myName = "";
    private String myDescription = "";
    private Icon myIcon;

    public abstract SettingsEditor<T> getEditor();

    public UserFileType clone() {
        try {
            return (UserFileType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.myDescription;
    }

    public void setName(@NotNull String name) {
        this.myName = name;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    @Override
    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    @Override
    public Icon getIcon() {
        return (Icon)ObjectUtils.chooseNotNull((Object)this.myIcon, (Object)PlatformIcons.CUSTOM_FILE_ICON);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        return null;
    }

    public void copyFrom(@NotNull UserFileType newType) {
        this.myName = newType.getName();
        this.myDescription = newType.getDescription();
    }

    public void setIcon(@NotNull Icon icon) {
        this.myIcon = icon;
    }

    public String toString() {
        return this.myName;
    }
}

