/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ide;

import com.intellij.openapi.editor.Document;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KillRingTransferable
implements Transferable {
    private static final DataFlavor[] DATA_FLAVORS = new DataFlavor[]{DataFlavor.stringFlavor};
    private final String myData;
    private final WeakReference<Document> myDocument;
    private final int myStartOffset;
    private final int myEndOffset;
    private final boolean myCut;
    private volatile boolean myReadyToCombine = true;

    public KillRingTransferable(@NotNull String data, @NotNull Document document, int startOffset, int endOffset, boolean cut) {
        this.myData = data;
        this.myDocument = new WeakReference<Document>(document);
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myCut = cut;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return DATA_FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == DataFlavor.stringFlavor;
    }

    @Override
    @Nullable
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return this.isDataFlavorSupported(flavor) ? this.myData : null;
    }

    @Nullable
    public Document getDocument() {
        return (Document)this.myDocument.get();
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public boolean isCut() {
        return this.myCut;
    }

    public boolean isReadyToCombine() {
        return this.myReadyToCombine;
    }

    public void setReadyToCombine(boolean readyToCombine) {
        this.myReadyToCombine = readyToCombine;
    }

    public String toString() {
        return "data='" + this.myData + "', startOffset=" + this.myStartOffset + ", endOffset=" + this.myEndOffset + ", cut=" + this.myCut;
    }
}

