/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.awt.Component;
import java.awt.im.InputContext;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="KeyboardSettings", storages={@Storage(value="keyboard.xml")})
public class KeyboardSettingsExternalizable
implements PersistentStateComponent<OptionSet> {
    private static final String[] supportedNonEnglishLanguages = new String[]{"de", "fr", "it", "uk"};
    private OptionSet myOptions = new OptionSet();

    public static boolean isSupportedKeyboardLayout(@NotNull Component component) {
        String keyboardLayoutLanguage = KeyboardSettingsExternalizable.getLanguageForComponent(component);
        for (String language : supportedNonEnglishLanguages) {
            if (!language.equals(keyboardLayoutLanguage)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getLanguageForComponent(@NotNull Component component) {
        Locale locale = KeyboardSettingsExternalizable.getLocaleForComponent(component);
        return locale == null ? null : locale.getLanguage();
    }

    @Nullable
    protected static Locale getLocaleForComponent(@NotNull Component component) {
        InputContext context = component.getInputContext();
        return context == null ? null : context.getLocale();
    }

    @Nullable
    public static String getDisplayLanguageNameForComponent(@NotNull Component component) {
        Locale locale = KeyboardSettingsExternalizable.getLocaleForComponent(component);
        return locale == null ? null : locale.getDisplayLanguage();
    }

    public static KeyboardSettingsExternalizable getInstance() {
        if (ApplicationManager.getApplication().isDisposed()) {
            return new KeyboardSettingsExternalizable();
        }
        return ServiceManager.getService(KeyboardSettingsExternalizable.class);
    }

    @Override
    @Nullable
    public OptionSet getState() {
        return this.myOptions;
    }

    @Override
    public void loadState(@NotNull OptionSet state) {
        state.PREFER_KEY_POSITION_OVER_CHAR_OPTION = state.PREFER_KEY_POSITION_OVER_CHAR_OPTION || "true".equals(System.getProperty("com.jetbrains.use.old.keyevent.processing"));
        this.myOptions = state;
    }

    public boolean isPreferKeyPositionOverCharOption() {
        return this.myOptions.PREFER_KEY_POSITION_OVER_CHAR_OPTION;
    }

    public void setPreferKeyPositionOverCharOption(boolean enabled) {
        this.myOptions.PREFER_KEY_POSITION_OVER_CHAR_OPTION = enabled;
    }

    public static final class OptionSet {
        public boolean PREFER_KEY_POSITION_OVER_CHAR_OPTION = "true".equals(System.getProperty("com.jetbrains.use.old.keyevent.processing"));
    }
}

