/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class MacKeymapUtil {
    public static final String ESCAPE = "\u238b";
    public static final String TAB = "\u21e5";
    public static final String TAB_BACK = "\u21e4";
    public static final String CAPS_LOCK = "\u21ea";
    public static final String SHIFT = "\u21e7";
    public static final String CONTROL = "\u2303";
    public static final String OPTION = "\u2325";
    public static final String APPLE = "\uf8ff";
    public static final String COMMAND = "\u2318";
    public static final String SPACE = "\u2423";
    public static final String RETURN = "\u23ce";
    public static final String BACKSPACE = "\u232b";
    public static final String DELETE = "\u2326";
    public static final String HOME = "\u2196";
    public static final String END = "\u2198";
    public static final String PAGE_UP = "\u21de";
    public static final String PAGE_DOWN = "\u21df";
    public static final String UP = "\u2191";
    public static final String DOWN = "\u2193";
    public static final String LEFT = "\u2190";
    public static final String RIGHT = "\u2192";
    public static final String CLEAR = "\u2327";
    public static final String NUMBER_LOCK = "\u21ed";
    public static final String ENTER = "\u2324";
    public static final String EJECT = "\u23cf";
    public static final String POWER3 = "\u233d";
    public static final String NUM_PAD = "\u2328";

    @NotNull
    static String getModifiersText(@JdkConstants.InputEventMask int modifiers) {
        StringBuilder buf = new StringBuilder();
        if ((modifiers & 2) != 0) {
            buf.append(MacKeymapUtil.get(CONTROL, "Ctrl+"));
        }
        if ((modifiers & 8) != 0) {
            buf.append(MacKeymapUtil.get(OPTION, "Alt+"));
        }
        if ((modifiers & 1) != 0) {
            buf.append(MacKeymapUtil.get(SHIFT, "Shift+"));
        }
        if ((modifiers & 0x20) != 0) {
            buf.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
        }
        if ((modifiers & 0x10) != 0) {
            buf.append(Toolkit.getProperty("AWT.button1", "Button1"));
        }
        if ((modifiers & 4) != 0) {
            buf.append(MacKeymapUtil.get(COMMAND, "Cmd+"));
        }
        return buf.toString();
    }

    @NotNull
    public static String getKeyText(int code) {
        switch (code) {
            case 8: {
                return MacKeymapUtil.get(BACKSPACE, "Backspace");
            }
            case 27: {
                return MacKeymapUtil.get(ESCAPE, "Escape");
            }
            case 20: {
                return MacKeymapUtil.get(CAPS_LOCK, "Caps Lock");
            }
            case 9: {
                return MacKeymapUtil.get(TAB, "Tab");
            }
            case 32: {
                return "Space";
            }
            case 127: {
                return MacKeymapUtil.get(DELETE, "Delete");
            }
            case 36: {
                return MacKeymapUtil.get(HOME, "Home");
            }
            case 35: {
                return MacKeymapUtil.get(END, "End");
            }
            case 33: {
                return MacKeymapUtil.get(PAGE_UP, "Page Up");
            }
            case 34: {
                return MacKeymapUtil.get(PAGE_DOWN, "Page Down");
            }
            case 38: {
                return MacKeymapUtil.get(UP, "Up Arrow");
            }
            case 40: {
                return MacKeymapUtil.get(DOWN, "Down Arrow");
            }
            case 37: {
                return MacKeymapUtil.get(LEFT, "Left Arrow");
            }
            case 39: {
                return MacKeymapUtil.get(RIGHT, "Right Arrow");
            }
            case 144: {
                return MacKeymapUtil.get(NUMBER_LOCK, "Num Lock");
            }
            case 10: {
                return MacKeymapUtil.get(RETURN, "Return");
            }
            case 520: {
                return MacKeymapUtil.get(NUM_PAD, "NumPad");
            }
            case 106: {
                return MacKeymapUtil.get(NUM_PAD, "NumPad") + " *";
            }
            case 109: {
                return "-";
            }
            case 107: {
                return "+";
            }
            case 45: {
                return "-";
            }
            case 521: {
                return "+";
            }
            case 111: {
                return "NumPad /";
            }
            case 96: {
                return "0";
            }
            case 97: {
                return "1";
            }
            case 98: {
                return "2";
            }
            case 99: {
                return "3";
            }
            case 100: {
                return "4";
            }
            case 101: {
                return "5";
            }
            case 102: {
                return "6";
            }
            case 103: {
                return "7";
            }
            case 104: {
                return "8";
            }
            case 105: {
                return "9";
            }
            case 0: {
                return "fn";
            }
        }
        return KeyEvent.getKeyText(code);
    }

    @NotNull
    public static String getKeyStrokeText(@NotNull KeyStroke keyStroke) {
        String modifiers = MacKeymapUtil.getModifiersText(keyStroke.getModifiers());
        String key = KeymapUtil.getKeyText(keyStroke.getKeyCode());
        return modifiers + key;
    }

    @NotNull
    private static String get(@NotNull String value, @NotNull String replacement) {
        Font font = UIUtil.getLabelFont();
        return font == null || font.canDisplayUpTo(value) == -1 ? value : replacement;
    }
}

