/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.InternalModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class ModuleType<T extends ModuleBuilder> {
    public static final ModuleType EMPTY = ModuleType.instantiate("com.intellij.openapi.module.EmptyModuleType");
    @NotNull
    private final String myId;
    private final FrameworkRole myFrameworkRole;

    protected ModuleType(@NotNull @NonNls String id) {
        this.myId = id;
        this.myFrameworkRole = new FrameworkRole(id);
    }

    @NotNull
    public abstract T createModuleBuilder();

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getDescription();

    public Icon getIcon() {
        return this.getNodeIcon(false);
    }

    public abstract Icon getNodeIcon(@Deprecated boolean var1);

    @NotNull
    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull T moduleBuilder, @NotNull ModulesProvider modulesProvider) {
        return ModuleWizardStep.EMPTY_ARRAY;
    }

    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder) {
        return null;
    }

    @Nullable
    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder) {
        return null;
    }

    @NotNull
    public final String getId() {
        return this.myId;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleType)) {
            return false;
        }
        ModuleType moduleType = (ModuleType)o;
        return this.myId.equals(moduleType.myId);
    }

    public final int hashCode() {
        return this.myId.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @NotNull
    private static ModuleType instantiate(String className) {
        try {
            return (ModuleType)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isValidSdk(@NotNull Module module, @Nullable Sdk projectSdk) {
        return true;
    }

    public static boolean is(@NotNull Module module, @NotNull ModuleType moduleType) {
        return moduleType.getId().equals(module.getModuleTypeName());
    }

    public static boolean isInternal(@NotNull Module module) {
        return ModuleType.get(module) instanceof InternalModuleType;
    }

    @NotNull
    public static ModuleType get(@NotNull Module module) {
        ModuleTypeManager instance = ModuleTypeManager.getInstance();
        if (instance == null) {
            return EMPTY;
        }
        return instance.findByID(module.getModuleTypeName());
    }

    @NotNull
    public FrameworkRole getDefaultAcceptableRole() {
        return this.myFrameworkRole;
    }

    public boolean isSupportedRootType(JpsModuleSourceRootType type) {
        return true;
    }

    public boolean isMarkInnerSupportedFor(JpsModuleSourceRootType type) {
        return false;
    }
}

