/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BeanConfigurable<T>
implements UnnamedConfigurable {
    private final T myInstance;
    private final List<BeanField> myFields = new ArrayList<BeanField>();

    protected BeanConfigurable(@NotNull T beanInstance) {
        this.myInstance = beanInstance;
    }

    @NotNull
    protected T getInstance() {
        return this.myInstance;
    }

    @Deprecated
    protected void checkBox(@NonNls String fieldName, String title) {
        this.myFields.add(new CheckboxField(fieldName, title));
    }

    protected void checkBox(@NotNull String title, final @NotNull Getter<Boolean> getter, final @NotNull Setter<Boolean> setter) {
        CheckboxField field = new CheckboxField("", title){

            @Override
            Object getBeanValue(@NotNull Object instance) {
                return getter.get();
            }

            @Override
            void setBeanValue(Object instance, Object value) {
                setter.set((Object)((Boolean)value));
            }
        };
        this.myFields.add(field);
    }

    protected <V> void component(final @NotNull JComponent component, final @NotNull Getter<? extends V> beanGetter, final @NotNull Setter<? super V> beanSetter, final @NotNull Getter<? extends V> componentGetter, final @NotNull Setter<? super V> componentSetter) {
        BeanField<JComponent> field = new BeanField<JComponent>(""){

            @Override
            @NotNull
            JComponent createComponent() {
                return component;
            }

            @Override
            Object getComponentValue() {
                return componentGetter.get();
            }

            @Override
            void setComponentValue(Object value) {
                componentSetter.set(value);
            }

            @Override
            protected Class getValueClass() {
                return null;
            }

            @Override
            Object getBeanValue(@NotNull Object instance) {
                return beanGetter.get();
            }

            @Override
            void setBeanValue(Object instance, Object value) {
                beanSetter.set(value);
            }
        };
        this.myFields.add(field);
    }

    @Override
    public JComponent createComponent() {
        JPanel panel = new JPanel(new GridLayout(this.myFields.size(), 1));
        for (BeanField field : this.myFields) {
            panel.add((Component)field.getComponent());
        }
        return panel;
    }

    @Override
    public boolean isModified() {
        for (BeanField field : this.myFields) {
            if (!field.isModified(this.myInstance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply() throws ConfigurationException {
        for (BeanField field : this.myFields) {
            field.apply(this.myInstance);
        }
    }

    @Override
    public void reset() {
        for (BeanField field : this.myFields) {
            field.reset(this.myInstance);
        }
    }

    private static class CheckboxField
    extends BeanField<JCheckBox> {
        private final String myTitle;

        private CheckboxField(String fieldName, String title) {
            super(fieldName);
            this.myTitle = title;
        }

        @Override
        @NotNull
        JCheckBox createComponent() {
            return new JCheckBox(this.myTitle);
        }

        @Override
        Object getComponentValue() {
            return ((JCheckBox)this.getComponent()).isSelected();
        }

        @Override
        void setComponentValue(Object value) {
            ((JCheckBox)this.getComponent()).setSelected((Boolean)value);
        }

        @Override
        protected String getterName() {
            return "is" + StringUtil.capitalize((String)this.myFieldName);
        }

        @Override
        protected Class getValueClass() {
            return Boolean.TYPE;
        }
    }

    private static abstract class BeanField<T extends JComponent> {
        String myFieldName;
        T myComponent;

        private BeanField(String fieldName) {
            this.myFieldName = fieldName;
        }

        T getComponent() {
            if (this.myComponent == null) {
                this.myComponent = this.createComponent();
            }
            return this.myComponent;
        }

        @NotNull
        abstract T createComponent();

        boolean isModified(@NotNull Object instance) {
            Object beanValue;
            Object componentValue = this.getComponentValue();
            return !Comparing.equal((Object)componentValue, (Object)(beanValue = this.getBeanValue(instance)));
        }

        void apply(@NotNull Object instance) {
            this.setBeanValue(instance, this.getComponentValue());
        }

        void reset(@NotNull Object instance) {
            this.setComponentValue(this.getBeanValue(instance));
        }

        abstract Object getComponentValue();

        abstract void setComponentValue(Object var1);

        Object getBeanValue(@NotNull Object instance) {
            try {
                Field field = instance.getClass().getField(this.myFieldName);
                return field.get(instance);
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method = instance.getClass().getMethod(this.getterName(), new Class[0]);
                    return method.invoke(instance, new Object[0]);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @NonNls
        protected String getterName() {
            return "get" + StringUtil.capitalize((String)this.myFieldName);
        }

        void setBeanValue(Object instance, Object value) {
            try {
                Field field = instance.getClass().getField(this.myFieldName);
                field.set(instance, value);
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method = instance.getClass().getMethod("set" + StringUtil.capitalize((String)this.myFieldName), this.getValueClass());
                    method.invoke(instance, value);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract Class getValueClass();
    }
}

