/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ExtendableSettingsEditor<T>
extends SettingsEditor<T> {
    private final SettingsEditor<T> myMainEditor;
    private final List<SettingsEditor<T>> myExtensionEditors;

    public ExtendableSettingsEditor(SettingsEditor<T> mainEditor) {
        this.myMainEditor = mainEditor;
        this.myExtensionEditors = new ArrayList<SettingsEditor<T>>();
    }

    @Override
    protected void resetEditorFrom(@NotNull T s) {
        this.myMainEditor.resetFrom(s);
        for (SettingsEditor<T> extensionEditor : this.myExtensionEditors) {
            extensionEditor.resetFrom(s);
        }
    }

    @Override
    protected void applyEditorTo(@NotNull T s) throws ConfigurationException {
        this.myMainEditor.applyTo(s);
        for (SettingsEditor<T> extensionEditor : this.myExtensionEditors) {
            extensionEditor.applyTo(s);
        }
    }

    public void addExtensionEditor(SettingsEditor<T> extensionSettingsEditor) {
        this.myExtensionEditors.add(extensionSettingsEditor);
    }

    @Override
    @NotNull
    protected JComponent createEditor() {
        JPanel result2 = new JPanel();
        result2.setLayout(new GridBagLayout());
        JComponent mainEditorComponent = this.myMainEditor.getComponent();
        GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0);
        result2.add((Component)mainEditorComponent, c);
        for (int i = 0; i < this.myExtensionEditors.size(); ++i) {
            c = (GridBagConstraints)c.clone();
            c.gridy = i + 1;
            result2.add((Component)this.myExtensionEditors.get(i).getComponent(), c);
        }
        return result2;
    }
}

