/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.Convertor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class SettingsEditorWrapper<Src, Dst>
extends SettingsEditor<Src> {
    private final Convertor<? super Src, ? extends Dst> mySrcToDstConvertor;
    private final SettingsEditor<Dst> myWrapped;
    private final SettingsEditorListener<Dst> myListener;

    public SettingsEditorWrapper(SettingsEditor<Dst> wrapped, Convertor<? super Src, ? extends Dst> convertor) {
        this.mySrcToDstConvertor = convertor;
        this.myWrapped = wrapped;
        this.myListener = new SettingsEditorListener<Dst>(){

            @Override
            public void stateChanged(@NotNull SettingsEditor<Dst> settingsEditor) {
                SettingsEditorWrapper.this.fireEditorStateChanged();
            }
        };
        this.myWrapped.addSettingsEditorListener(this.myListener);
    }

    @Override
    public void resetEditorFrom(@NotNull Src src) {
        this.myWrapped.resetFrom(this.mySrcToDstConvertor.convert(src));
    }

    @Override
    public void applyEditorTo(@NotNull Src src) throws ConfigurationException {
        this.myWrapped.applyTo(this.mySrcToDstConvertor.convert(src));
    }

    @Override
    @NotNull
    public JComponent createEditor() {
        return this.myWrapped.createEditor();
    }

    @Override
    public void disposeEditor() {
        this.myWrapped.removeSettingsEditorListener(this.myListener);
        Disposer.dispose(this.myWrapped);
    }
}

