/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathReferenceManager {
    public static final ExtensionPointName<PathReferenceProvider> PATH_REFERENCE_PROVIDER_EP = ExtensionPointName.create((String)"com.intellij.pathReferenceProvider");
    public static final ExtensionPointName<PathReferenceProvider> ANCHOR_REFERENCE_PROVIDER_EP = ExtensionPointName.create((String)"com.intellij.anchorReferenceProvider");

    @NotNull
    public static PathReferenceManager getInstance() {
        return ServiceManager.getService(PathReferenceManager.class);
    }

    @NotNull
    public abstract PsiReference[] createReferences(@NotNull PsiElement var1, boolean var2, PathReferenceProvider ... var3);

    @NotNull
    public abstract PsiReference[] createReferences(@NotNull PsiElement var1, boolean var2, boolean var3, boolean var4, PathReferenceProvider ... var5);

    public abstract PsiReference[] createReferences(@NotNull PsiElement var1, boolean var2, boolean var3, boolean var4, FileType[] var5, PathReferenceProvider ... var6);

    @NotNull
    public abstract PsiReference[] createCustomReferences(@NotNull PsiElement var1, boolean var2, PathReferenceProvider ... var3);

    @Nullable
    public abstract PathReference getPathReference(@NotNull String var1, @NotNull PsiElement var2, PathReferenceProvider ... var3);

    @Nullable
    public abstract PathReference getCustomPathReference(@NotNull String var1, @NotNull Module var2, @NotNull PsiElement var3, PathReferenceProvider ... var4);

    @NotNull
    public abstract PathReferenceProvider getGlobalWebPathReferenceProvider();

    @NotNull
    public abstract PathReferenceProvider createStaticPathReferenceProvider(boolean var1);

    public static PsiReference[] getReferencesFromProvider(@NotNull PathReferenceProvider provider, @NotNull PsiElement psiElement, boolean soft) {
        ArrayList<PsiReference> references = new ArrayList<PsiReference>();
        provider.createReferences(psiElement, references, soft);
        return references.toArray(PsiReference.EMPTY_ARRAY);
    }
}

