/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectCoreUtil {
    public static volatile Project theProject;

    public static boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file) {
        return ProjectCoreUtil.isProjectOrWorkspaceFile(file, FileTypeRegistry.getInstance().getFileTypeByFileName(file.getNameSequence()));
    }

    public static boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file, @Nullable FileType fileType) {
        return fileType instanceof InternalFileType || VfsUtilCore.findContainingDirectory(file, ".idea") != null;
    }

    @Nullable
    public static Project theOnlyOpenProject() {
        return theProject;
    }
}

