/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectLocator {
    private static final ThreadLocal<Map<VirtualFile, Project>> ourPreferredProjects = ThreadLocal.withInitial(() -> new HashMap());

    public static ProjectLocator getInstance() {
        return ServiceManager.getService(ProjectLocator.class);
    }

    @Nullable
    public abstract Project guessProjectForFile(@Nullable VirtualFile var1);

    @NotNull
    public abstract Collection<Project> getProjectsForFile(VirtualFile var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T computeWithPreferredProject(@NotNull VirtualFile file, @NotNull Project preferredProject, @NotNull ThrowableComputable<T, E> action) throws E {
        Map<VirtualFile, Project> local = ourPreferredProjects.get();
        local.put(file, preferredProject);
        try {
            Object object = action.compute();
            return (T)object;
        }
        finally {
            local.remove(file);
        }
    }

    @Nullable
    static Project getPreferredProject(@NotNull VirtualFile file) {
        return ourPreferredProjects.get().get(file);
    }
}

