/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.DefaultProjectTypeEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectType")
public class ProjectTypeService
implements PersistentStateComponent<ProjectType> {
    private ProjectType myProjectType;

    @Nullable
    public static ProjectType getProjectType(@Nullable Project project) {
        ProjectType projectType;
        if (project != null && (projectType = ProjectTypeService.getInstance((Project)project).myProjectType) != null) {
            return projectType;
        }
        return DefaultProjectTypeEP.getDefaultProjectType();
    }

    public static void setProjectType(@NotNull Project project, @Nullable ProjectType projectType) {
        ProjectTypeService.getInstance(project).loadState(projectType);
    }

    private static ProjectTypeService getInstance(@NotNull Project project) {
        return ServiceManager.getService(project, ProjectTypeService.class);
    }

    @Override
    @Nullable
    public ProjectType getState() {
        return this.myProjectType;
    }

    @Override
    public void loadState(@Nullable ProjectType state) {
        this.myProjectType = state;
    }
}

