/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.StringKt;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\fH\u0007\u001a\u0010\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a\u001c\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\b\u001a\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u001a:\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2#\b\u0004\u0010\u001b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u001a0\u001cH\u0086\b\u001a\"\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001fH\u0007\u001a\n\u0010 \u001a\u00020!*\u00020\n\u001a*\u0010\"\u001a\u00020\u0006*\u00020\n2\b\b\u0002\u0010#\u001a\u00020\f2\b\b\u0002\u0010$\u001a\u00020\u00062\b\b\u0002\u0010%\u001a\u00020\u0006H\u0007\u001a(\u0010&\u001a\u00020!*\u00020\n2\u0006\u0010'\u001a\u00020!2\b\b\u0002\u0010(\u001a\u00020\f2\b\b\u0002\u0010$\u001a\u00020\u0006H\u0007\u001a(\u0010&\u001a\u00020!*\u00020\n2\u0006\u0010)\u001a\u00020\u00062\b\b\u0002\u0010#\u001a\u00020\f2\b\b\u0002\u0010%\u001a\u00020\u0006H\u0007\u001a\f\u0010*\u001a\u0004\u0018\u00010\b*\u00020\n\u001a3\u0010+\u001a\u0002H,\"\u0004\b\u0000\u0010,*\u00020\n2\u0019\b\u0004\u0010-\u001a\u0013\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u0002H,0\u001c\u00a2\u0006\u0002\b/H\u0086\b\u00a2\u0006\u0002\u00100\u001a\u0012\u0010\u0019\u001a\u00020\u001a*\u00020\n2\u0006\u0010\u001b\u001a\u000201\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u00062"}, d2={"rootManager", "Lcom/intellij/openapi/roots/ModuleRootManager;", "Lcom/intellij/openapi/module/Module;", "getRootManager", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/roots/ModuleRootManager;", "calcRelativeToProjectPath", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "includeFilePath", "", "includeUniqueFilePath", "keepModuleAlwaysOnTheLeft", "guessCurrentProject", "component", "Ljavax/swing/JComponent;", "guessProjectForContentFile", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "guessProjectForFile", "isProjectDirectoryExistsUsingIo", "parent", "isProjectOrWorkspaceFile", "runWhenProjectOpened", "", "handler", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Ljava/util/function/Consumer;", "getExternalConfigurationDir", "Ljava/nio/file/Path;", "getProjectCacheFileName", "isForceNameUse", "hashSeparator", "extensionWithDot", "getProjectCachePath", "baseDir", "forceNameUse", "cacheDirName", "guessProjectDir", "modifyModules", "T", "task", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Ljava/lang/Runnable;", "intellij.platform.ide"})
@JvmName(name="ProjectUtil")
public final class ProjectUtil {
    @NotNull
    public static final ModuleRootManager getRootManager(@NotNull Module $receiver) {
        return ModuleRootManager.getInstance($receiver);
    }

    @JvmOverloads
    @NotNull
    public static final String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project, boolean includeFilePath, boolean includeUniqueFilePath, boolean keepModuleAlwaysOnTheLeft) {
        if (file instanceof VirtualFilePathWrapper && ((VirtualFilePathWrapper)((Object)file)).enforcePresentableName()) {
            return includeFilePath ? ((VirtualFilePathWrapper)((Object)file)).getPresentablePath() : file.getName();
        }
        String url = includeFilePath ? file.getPresentableUrl() : (includeUniqueFilePath && project != null ? UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file) : file.getName());
        return project == null ? url : ProjectUtilCore.displayUrlRelativeToProject(file, url, project, includeFilePath, keepModuleAlwaysOnTheLeft);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ String calcRelativeToProjectPath$default(VirtualFile virtualFile2, Project project, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return ProjectUtil.calcRelativeToProjectPath(virtualFile2, project, bl, bl2, bl3);
    }

    @JvmOverloads
    @NotNull
    public static final String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project, boolean includeFilePath, boolean includeUniqueFilePath) {
        return ProjectUtil.calcRelativeToProjectPath$default(file, project, includeFilePath, includeUniqueFilePath, false, 16, null);
    }

    @JvmOverloads
    @NotNull
    public static final String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project, boolean includeFilePath) {
        return ProjectUtil.calcRelativeToProjectPath$default(file, project, includeFilePath, false, false, 24, null);
    }

    @JvmOverloads
    @NotNull
    public static final String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project) {
        return ProjectUtil.calcRelativeToProjectPath$default(file, project, false, false, false, 28, null);
    }

    @Nullable
    public static final Project guessProjectForFile(@Nullable VirtualFile file) {
        return ProjectLocator.getInstance().guessProjectForFile(file);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @Nullable
    public static final Project guessProjectForContentFile(@NotNull VirtualFile file, @NotNull FileType fileType) {
        Project project;
        Object v1;
        List list;
        block4: {
            void $receiver$iv$iv;
            Object $receiver$iv;
            if (ProjectCoreUtil.isProjectOrWorkspaceFile(file, fileType)) {
                return null;
            }
            Object object = $receiver$iv = ProjectManager.getInstance().getOpenProjects();
            Collection destination$iv$iv = new ArrayList();
            void var6_5 = $receiver$iv$iv;
            int n = ((void)var6_5).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var6_5[i];
                boolean bl = false;
                if (!(!it.isDefault() && it.isInitialized() && !it.isDisposed() && ProjectRootManager.getInstance((Project)it).getFileIndex().isInContent(file))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
            $receiver$iv = list;
            object = $receiver$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                Project it = (Project)element$iv;
                boolean bl = false;
                JFrame jFrame = WindowManager.getInstance().getFrame(it);
                if (!(jFrame != null ? jFrame.isActive() : false)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        if ((project = (Project)v1) == null) {
            project = (Project)CollectionsKt.firstOrNull((List)list);
        }
        return project;
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ Project guessProjectForContentFile$default(VirtualFile virtualFile2, FileType fileType, int n, Object object) {
        if ((n & 2) != 0) {
            fileType = FileTypeManager.getInstance().getFileTypeByFileName(virtualFile2.getNameSequence());
        }
        return ProjectUtil.guessProjectForContentFile(virtualFile2, fileType);
    }

    @JvmOverloads
    @Nullable
    public static final Project guessProjectForContentFile(@NotNull VirtualFile file) {
        return ProjectUtil.guessProjectForContentFile$default(file, null, 2, null);
    }

    public static final boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file) {
        return ProjectCoreUtil.isProjectOrWorkspaceFile(file);
    }

    @NotNull
    public static final Project guessCurrentProject(@Nullable JComponent component) {
        Project project;
        Project project2;
        Project project3;
        Project project4 = null;
        if (component != null) {
            project4 = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(component));
        }
        if ((project3 = project4) == null) {
            project3 = project2 = (Project)ArraysKt.firstOrNull((Object[])ProjectManager.getInstance().getOpenProjects());
        }
        if (project3 == null) {
            project2 = project = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        }
        if (project2 == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        return project;
    }

    public static final <T> T modifyModules(@NotNull Project $receiver, @NotNull Function1<? super ModifiableModuleModel, ? extends T> task) {
        int $i$f$modifyModules = 0;
        ModifiableModuleModel model = ModuleManager.getInstance($receiver).getModifiableModel();
        Object result2 = task.invoke((Object)model);
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(model){
            final /* synthetic */ ModifiableModuleModel $model$inlined;
            {
                this.$model$inlined = modifiableModuleModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
        return (T)result2;
    }

    public static final boolean isProjectDirectoryExistsUsingIo(@NotNull VirtualFile parent) {
        boolean bl;
        try {
            bl = PathKt.exists(Paths.get(FileUtil.toSystemDependentName((String)parent.getPath()), ".idea"));
        }
        catch (InvalidPathException e) {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final VirtualFile guessProjectDir(@NotNull Project $receiver) {
        VirtualFile[] module;
        VirtualFile[] virtualFileArray;
        VirtualFile[] it;
        VirtualFile[] element$iv;
        int n;
        int n2;
        Object[] objectArray;
        Object[] $receiver$iv;
        Object object;
        block8: {
            if ($receiver.isDefault()) {
                throw (Throwable)new IllegalStateException("Not applicable for default project");
            }
            Object[] modules = ModuleManager.getInstance($receiver).getModules();
            if (modules.length == 1) {
                object = (VirtualFile[])ArraysKt.first((Object[])modules);
            } else {
                objectArray = $receiver$iv = modules;
                n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = objectArray[n];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)$receiver.getName())) continue;
                    object = element$iv;
                    break block8;
                }
                object = null;
            }
        }
        if ((virtualFileArray = (module = object)) != null && (virtualFileArray = ProjectUtil.getRootManager((Module)virtualFileArray)) != null && (virtualFileArray = virtualFileArray.getContentRoots()) != null) {
            VirtualFile[] virtualFileArray2;
            block9: {
                objectArray = $receiver$iv = virtualFileArray;
                n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = objectArray[n];
                    boolean bl = false;
                    if (!it.isDirectory()) continue;
                    virtualFileArray2 = element$iv;
                    break block9;
                }
                virtualFileArray2 = virtualFileArray = null;
            }
            if (virtualFileArray2 != null) {
                VirtualFile[] virtualFileArray3;
                VirtualFile[] it2 = virtualFileArray3 = virtualFileArray;
                boolean bl = false;
                return it2;
            }
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        String string = $receiver.getBasePath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return localFileSystem.findFileByPath(string);
    }

    @JvmOverloads
    @NotNull
    public static final String getProjectCacheFileName(@NotNull Project $receiver, boolean isForceNameUse, @NotNull String hashSeparator, @NotNull String extensionWithDot) {
        String string;
        String presentableUrl = $receiver.getPresentableUrl();
        if (isForceNameUse || presentableUrl == null) {
            string = $receiver.getName();
        } else {
            String string2 = PathUtilRt.getFileName((String)presentableUrl);
            Locale locale = Locale.US;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase(locale);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
            string = StringsKt.removeSuffix((String)string4, (CharSequence)".ipr");
        }
        String name = string;
        name = PathKt.sanitizeFileName$default(name, null, false, 2, null);
        String string5 = presentableUrl;
        if (string5 == null) {
            string5 = name;
        }
        String locationHash = Integer.toHexString(string5.hashCode());
        name = StringKt.trimMiddle(name, Math.min(name.length(), 255 - hashSeparator.length() - locationHash.length()), false);
        return name + hashSeparator + locationHash + extensionWithDot;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ String getProjectCacheFileName$default(Project project, boolean bl, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            string = ".";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        return ProjectUtil.getProjectCacheFileName(project, bl, string, string2);
    }

    @JvmOverloads
    @NotNull
    public static final String getProjectCacheFileName(@NotNull Project $receiver, boolean isForceNameUse, @NotNull String hashSeparator) {
        return ProjectUtil.getProjectCacheFileName$default($receiver, isForceNameUse, hashSeparator, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getProjectCacheFileName(@NotNull Project $receiver, boolean isForceNameUse) {
        return ProjectUtil.getProjectCacheFileName$default($receiver, isForceNameUse, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getProjectCacheFileName(@NotNull Project $receiver) {
        return ProjectUtil.getProjectCacheFileName$default($receiver, false, null, null, 7, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $receiver, @NotNull String cacheDirName, boolean isForceNameUse, @NotNull String extensionWithDot) {
        return PathManagerEx.getAppSystemDir().resolve(cacheDirName).resolve(ProjectUtil.getProjectCacheFileName$default($receiver, isForceNameUse, null, extensionWithDot, 2, null));
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ Path getProjectCachePath$default(Project project, String string, boolean bl, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        return ProjectUtil.getProjectCachePath(project, string, bl, string2);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $receiver, @NotNull String cacheDirName, boolean isForceNameUse) {
        return ProjectUtil.getProjectCachePath$default($receiver, cacheDirName, isForceNameUse, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $receiver, @NotNull String cacheDirName) {
        return ProjectUtil.getProjectCachePath$default($receiver, cacheDirName, false, null, 6, null);
    }

    @NotNull
    public static final Path getExternalConfigurationDir(@NotNull Project $receiver) {
        return ProjectUtil.getProjectCachePath$default($receiver, "external_build_system", false, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $receiver, @NotNull Path baseDir, boolean forceNameUse, @NotNull String hashSeparator) {
        return baseDir.resolve(ProjectUtil.getProjectCacheFileName$default($receiver, forceNameUse, hashSeparator, null, 4, null));
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ Path getProjectCachePath$default(Project project, Path path2, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            string = ".";
        }
        return ProjectUtil.getProjectCachePath(project, path2, bl, string);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $receiver, @NotNull Path baseDir, boolean forceNameUse) {
        return ProjectUtil.getProjectCachePath$default($receiver, baseDir, forceNameUse, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $receiver, @NotNull Path baseDir) {
        return ProjectUtil.getProjectCachePath$default($receiver, baseDir, false, null, 6, null);
    }

    public static final void runWhenProjectOpened(@NotNull Project $receiver, @NotNull Runnable handler) {
        boolean $i$f$runWhenProjectOpened = false;
        Project project = $receiver;
        MessageBusConnection connection$iv = (project != null ? (ComponentManager)project : (ComponentManager)ApplicationManager.getApplication()).getMessageBus().connect();
        connection$iv.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener($receiver, connection$iv, handler){
            final /* synthetic */ Project $project;
            final /* synthetic */ MessageBusConnection $connection;
            final /* synthetic */ Runnable $handler$inlined;
            {
                this.$project = $captured_local_variable$0;
                this.$connection = $captured_local_variable$1;
                this.$handler$inlined = runnable;
            }

            public void projectOpened(@NotNull Project eventProject) {
                if (this.$project == null || this.$project == eventProject) {
                    this.$connection.disconnect();
                    Project it = eventProject;
                    boolean bl = false;
                    this.$handler$inlined.run();
                }
            }
        });
    }

    @JvmOverloads
    public static final void runWhenProjectOpened(@Nullable Project project, @NotNull Consumer<Project> handler) {
        boolean $i$f$runWhenProjectOpened = false;
        Project project2 = project;
        MessageBusConnection connection$iv = (project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication()).getMessageBus().connect();
        connection$iv.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(project, connection$iv, handler){
            final /* synthetic */ Project $project;
            final /* synthetic */ MessageBusConnection $connection;
            final /* synthetic */ Consumer $handler$inlined;
            {
                this.$project = $captured_local_variable$0;
                this.$connection = $captured_local_variable$1;
                this.$handler$inlined = consumer;
            }

            public void projectOpened(@NotNull Project eventProject) {
                if (this.$project == null || this.$project == eventProject) {
                    this.$connection.disconnect();
                    Project it = eventProject;
                    boolean bl = false;
                    this.$handler$inlined.accept(it);
                }
            }
        });
    }

    @JvmOverloads
    public static /* synthetic */ void runWhenProjectOpened$default(Project project, Consumer consumer, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        ProjectUtil.runWhenProjectOpened(project, consumer);
    }

    @JvmOverloads
    public static final void runWhenProjectOpened(@NotNull Consumer<Project> handler) {
        ProjectUtil.runWhenProjectOpened$default(null, handler, 1, null);
    }

    public static final void runWhenProjectOpened(@Nullable Project project, @NotNull Function1<? super Project, Unit> handler) {
        int $i$f$runWhenProjectOpened = 0;
        Project project2 = project;
        MessageBusConnection connection = (project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication()).getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(project, connection, handler){
            final /* synthetic */ Project $project;
            final /* synthetic */ MessageBusConnection $connection;
            final /* synthetic */ Function1 $handler;

            public void projectOpened(@NotNull Project eventProject) {
                if (this.$project == null || this.$project == eventProject) {
                    this.$connection.disconnect();
                    this.$handler.invoke((Object)eventProject);
                }
            }
            {
                this.$project = $captured_local_variable$0;
                this.$connection = $captured_local_variable$1;
                this.$handler = $captured_local_variable$2;
            }
        });
    }

    public static /* synthetic */ void runWhenProjectOpened$default(Project project, Function1 handler, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        boolean $i$f$runWhenProjectOpened = false;
        Project project2 = project;
        MessageBusConnection connection = (project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication()).getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new /* invalid duplicate definition of identical inner class */);
    }
}

