/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.Topic;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectJdkTable {
    public static final Topic<Listener> JDK_TABLE_TOPIC = Topic.create((String)"Project JDK table", Listener.class);

    public static ProjectJdkTable getInstance() {
        return ServiceManager.getService(ProjectJdkTable.class);
    }

    @Nullable
    public abstract Sdk findJdk(@NotNull String var1);

    @Nullable
    public abstract Sdk findJdk(@NotNull String var1, @NotNull String var2);

    @NotNull
    public abstract Sdk[] getAllJdks();

    @NotNull
    public abstract List<Sdk> getSdksOfType(@NotNull SdkTypeId var1);

    @Nullable
    public Sdk findMostRecentSdkOfType(@NotNull SdkTypeId type) {
        return this.getSdksOfType(type).stream().max(type.versionComparator()).orElse(null);
    }

    @Deprecated
    public Sdk findMostRecentSdk(@NotNull Condition<? super Sdk> condition) {
        Sdk found = null;
        for (Sdk each : this.getAllJdks()) {
            if (!condition.value((Object)each) || found != null && Comparing.compare((Comparable)((Object)each.getVersionString()), (Comparable)((Object)found.getVersionString())) <= 0) continue;
            found = each;
        }
        return found;
    }

    public abstract void addJdk(@NotNull Sdk var1);

    public void addJdk(@NotNull Sdk jdk, @NotNull Disposable parentDisposable) {
        this.addJdk(jdk);
        Disposer.register((Disposable)parentDisposable, () -> WriteAction.runAndWait(() -> this.removeJdk(jdk)));
    }

    public abstract void removeJdk(@NotNull Sdk var1);

    public abstract void updateJdk(@NotNull Sdk var1, @NotNull Sdk var2);

    @Deprecated
    public abstract void addListener(@NotNull Listener var1);

    @Deprecated
    public abstract void removeListener(@NotNull Listener var1);

    @NotNull
    public abstract SdkTypeId getDefaultSdkType();

    @NotNull
    public abstract SdkTypeId getSdkTypeByName(@NotNull String var1);

    @NotNull
    public abstract Sdk createSdk(@NotNull String var1, @NotNull SdkTypeId var2);

    public static class Adapter
    implements Listener {
        @Override
        public void jdkAdded(@NotNull Sdk jdk) {
        }

        @Override
        public void jdkRemoved(@NotNull Sdk jdk) {
        }

        @Override
        public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
        }
    }

    public static interface Listener
    extends EventListener {
        public void jdkAdded(@NotNull Sdk var1);

        public void jdkRemoved(@NotNull Sdk var1);

        public void jdkNameChanged(@NotNull Sdk var1, @NotNull String var2);
    }
}

