/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class SimpleJavaSdkType
extends SdkType
implements JavaSdkType {
    public static SimpleJavaSdkType getInstance() {
        return SdkType.findInstance(SimpleJavaSdkType.class);
    }

    public SimpleJavaSdkType() {
        super("SimpleJavaSdkType");
    }

    public Sdk createJdk(@NotNull String jdkName, @NotNull String home) {
        Sdk jdk = ProjectJdkTable.getInstance().createSdk(jdkName, this);
        SdkModificator sdkModificator = jdk.getSdkModificator();
        sdkModificator.setHomePath(FileUtil.toSystemIndependentName((String)home));
        sdkModificator.commitChanges();
        return jdk;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return ProjectBundle.message("sdk.java.name", new Object[0]);
    }

    @Override
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        return null;
    }

    @Override
    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
    }

    @Override
    public String getBinPath(@NotNull Sdk sdk) {
        return new File(sdk.getHomePath(), "bin").getPath();
    }

    @Override
    public String getToolsPath(@NotNull Sdk sdk) {
        return new File(sdk.getHomePath(), "lib/tools.jar").getPath();
    }

    @Override
    public String getVMExecutablePath(@NotNull Sdk sdk) {
        return new File(sdk.getHomePath(), "bin/java").getPath();
    }

    @Override
    public String suggestHomePath() {
        return null;
    }

    @Override
    public boolean isValidSdkHome(String path2) {
        return JdkUtil.checkForJdk(path2);
    }

    @Override
    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, String sdkHome) {
        String suggestedName = JdkUtil.suggestJdkName(this.getVersionString(sdkHome));
        return suggestedName != null ? suggestedName : (currentSdkName != null ? currentSdkName : "");
    }

    @Override
    public final String getVersionString(String sdkHome) {
        JdkVersionDetector.JdkVersionInfo jdkInfo = SdkVersionUtil.getJdkVersionInfo(sdkHome);
        return jdkInfo != null ? JdkVersionDetector.formatVersionString(jdkInfo.version) : null;
    }

    @NotNull
    public static Condition<SdkTypeId> notSimpleJavaSdkType() {
        return sdkTypeId -> !(sdkTypeId instanceof SimpleJavaSdkType);
    }

    @NotNull
    public static Condition<SdkTypeId> notSimpleJavaSdkType(@Nullable Condition<? super SdkTypeId> condition) {
        return sdkTypeId -> SimpleJavaSdkType.notSimpleJavaSdkType().value(sdkTypeId) && (condition == null || condition.value(sdkTypeId));
    }
}

