/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProjectFileIndex
extends FileIndex {
    @NotNull
    public static ProjectFileIndex getInstance(@NotNull Project project) {
        return ServiceManager.getService(project, ProjectFileIndex.class);
    }

    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile var1);

    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile var1, boolean var2);

    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile var1);

    @Nullable
    public VirtualFile getClassRootForFile(@NotNull VirtualFile var1);

    @Nullable
    public VirtualFile getSourceRootForFile(@NotNull VirtualFile var1);

    @Nullable
    public VirtualFile getContentRootForFile(@NotNull VirtualFile var1);

    @Nullable
    public VirtualFile getContentRootForFile(@NotNull VirtualFile var1, boolean var2);

    @Nullable
    public String getPackageNameByDirectory(@NotNull VirtualFile var1);

    public boolean isLibraryClassFile(@NotNull VirtualFile var1);

    public boolean isInSource(@NotNull VirtualFile var1);

    public boolean isInLibraryClasses(@NotNull VirtualFile var1);

    public boolean isInLibrary(@NotNull VirtualFile var1);

    public boolean isInLibrarySource(@NotNull VirtualFile var1);

    @Deprecated
    public boolean isIgnored(@NotNull VirtualFile var1);

    public boolean isExcluded(@NotNull VirtualFile var1);

    public boolean isUnderIgnored(@NotNull VirtualFile var1);

    public static class SERVICE {
        private SERVICE() {
        }

        public static ProjectFileIndex getInstance(Project project) {
            return ProjectFileIndex.getInstance(project);
        }
    }
}

