/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import java.util.EventListener;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LibraryTable {
    @NotNull
    public Library[] getLibraries();

    @NotNull
    public Library createLibrary();

    @NotNull
    public Library createLibrary(@NonNls String var1);

    public void removeLibrary(@NotNull Library var1);

    @NotNull
    public Iterator<Library> getLibraryIterator();

    @Nullable
    public Library getLibraryByName(@NotNull String var1);

    @NotNull
    public String getTableLevel();

    @NotNull
    public LibraryTablePresentation getPresentation();

    default public boolean isEditable() {
        return true;
    }

    @NotNull
    public ModifiableModel getModifiableModel();

    public void addListener(@NotNull Listener var1);

    public void addListener(@NotNull Listener var1, @NotNull Disposable var2);

    public void removeListener(@NotNull Listener var1);

    public static interface Listener
    extends EventListener {
        default public void afterLibraryAdded(@NotNull Library newLibrary) {
        }

        default public void afterLibraryRenamed(@NotNull Library library) {
        }

        default public void beforeLibraryRemoved(@NotNull Library library) {
        }

        default public void afterLibraryRemoved(@NotNull Library library) {
        }
    }

    public static interface ModifiableModel
    extends Disposable {
        @NotNull
        public Library createLibrary(String var1);

        @NotNull
        public Library createLibrary(String var1, @Nullable PersistentLibraryKind var2);

        @NotNull
        public Library createLibrary(String var1, @Nullable PersistentLibraryKind var2, @Nullable ProjectModelExternalSource var3);

        public void removeLibrary(@NotNull Library var1);

        public void commit();

        @NotNull
        public Iterator<Library> getLibraryIterator();

        @Nullable
        public Library getLibraryByName(@NotNull String var1);

        @NotNull
        public Library[] getLibraries();

        public boolean isChanged();
    }
}

