/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.Objects;
import javax.swing.CellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboBox<E>
extends ComboBoxWithWidePopup<E>
implements AWTEventListener {
    public static final String TABLE_CELL_EDITOR_PROPERTY = "tableCellEditor";
    private int myMinimumAndPreferredWidth;
    private boolean mySwingPopup = true;
    private JBPopup myJBPopup;
    protected boolean myPaintingNow;

    public ComboBox() {
        this.init(-1);
    }

    public ComboBox(int width) {
        this.init(width);
    }

    public ComboBox(@NotNull ComboBoxModel<E> model) {
        super(model);
        this.init(-1);
    }

    public ComboBox(@NotNull E[] items) {
        super(items);
        this.init(-1);
    }

    public ComboBox(@NotNull E[] items, int width) {
        super(items);
        this.init(width);
    }

    public ComboBox(@NotNull ComboBoxModel<E> model, int width) {
        super(model);
        this.init(width);
    }

    private void init(int width) {
        this.myMinimumAndPreferredWidth = width;
        this.registerCancelOnEscape();
        UIUtil.installComboBoxCopyAction((JComboBox)this);
        JButton arrowButton = (JButton)UIUtil.findComponentOfType((JComponent)this, JButton.class);
        if (arrowButton != null) {
            arrowButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!ComboBox.this.mySwingPopup) {
                        e.consume();
                        ComboBox.this.setPopupVisible(true);
                    }
                }
            });
        }
    }

    public static void registerTableCellEditor(@NotNull JComboBox comboBox, @NotNull TableCellEditor cellEditor) {
        comboBox.putClientProperty(TABLE_CELL_EDITOR_PROPERTY, cellEditor);
        comboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
    }

    public void registerTableCellEditor(@NotNull TableCellEditor cellEditor) {
        ComboBox.registerTableCellEditor(this, cellEditor);
    }

    @Override
    public void setPopupVisible(boolean visible) {
        JBPopupFactory jbPopupFactory;
        if (!this.isSwingPopup()) {
            if (visible && (this.myJBPopup == null || this.myJBPopup.isDisposed())) {
                JBList list = this.createJBList(this.getModel());
                this.myJBPopup = ((PopupChooserBuilder)Objects.requireNonNull(ComboBox.getPopupFactory()).createListPopupBuilder(list).setItemChoosenCallback(() -> {
                    Object value = list.getSelectedValue();
                    if (value != null) {
                        this.configureEditor(this.getEditor(), value);
                        IdeFocusManager.getGlobalInstance().requestFocus(this, true);
                        assert (this.myJBPopup != null);
                        this.getUI().setPopupVisible(this, false);
                        this.myJBPopup.cancel();
                    }
                }).setFocusOwners(new Component[]{this}).setMinSize(new Dimension(this.getWidth(), -1))).createPopup();
                list.setBorder((Border)JBUI.Borders.empty());
                this.myJBPopup.showUnderneathOf(this);
                list.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        ComboBox.this.getUI().setPopupVisible(ComboBox.this, false);
                        ComboBox.this.myJBPopup.cancel();
                    }
                });
            }
            return;
        }
        if (this.getModel().getSize() == 0 && visible) {
            return;
        }
        if (visible && (jbPopupFactory = ComboBox.getPopupFactory()) != null && jbPopupFactory.getChildFocusedPopup(this) != null) {
            return;
        }
        boolean wasShown = this.isPopupVisible();
        super.setPopupVisible(visible);
        if (!wasShown && visible && this.isEditable() && !UIManager.getBoolean("ComboBox.isEnterSelectablePopup")) {
            ComboBoxEditor editor = this.getEditor();
            Object item = editor.getItem();
            Object selectedItem = this.getSelectedItem();
            if (this.isSwingPopup() && (item == null || item != selectedItem)) {
                this.configureEditor(editor, selectedItem);
            }
        }
    }

    @Nullable
    private static JBPopupFactory getPopupFactory() {
        if (ApplicationManager.getApplication() == null) {
            return null;
        }
        return JBPopupFactory.getInstance();
    }

    protected JBList<E> createJBList(ComboBoxModel<E> model) {
        return new JBList<E>(model);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getID() != 200) {
            return;
        }
        JBPopupFactory jbPopupFactory = ComboBox.getPopupFactory();
        if (jbPopupFactory == null) {
            return;
        }
        WindowEvent we = (WindowEvent)event;
        for (JBPopup each : jbPopupFactory.getChildPopups(this)) {
            if (each.getContent() == null || !SwingUtilities.isDescendingFrom(each.getContent(), we.getWindow())) continue;
            super.setPopupVisible(false);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.getParent() instanceof JTable) {
            this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        if (this.myJBPopup != null) {
            this.getUI().setPopupVisible(this, false);
            this.myJBPopup.cancel();
        }
    }

    @Nullable
    public ComboPopup getPopup() {
        return UIUtil.getComboBoxPopup((JComboBox)this);
    }

    public boolean isSwingPopup() {
        return this.mySwingPopup;
    }

    public void setSwingPopup(boolean swingPopup) {
        this.mySwingPopup = swingPopup;
    }

    public void setMinimumAndPreferredWidth(int minimumAndPreferredWidth) {
        this.myMinimumAndPreferredWidth = minimumAndPreferredWidth;
    }

    private void registerCancelOnEscape() {
        this.registerKeyboardAction(e -> {
            DialogWrapper dialogWrapper = DialogWrapper.findInstance(this);
            if (this.isPopupVisible()) {
                this.setPopupVisible(false);
            } else {
                Object clientProperty = this.getClientProperty(TABLE_CELL_EDITOR_PROPERTY);
                if (clientProperty instanceof CellEditor) {
                    ((CellEditor)clientProperty).cancelCellEditing();
                } else if (dialogWrapper != null) {
                    dialogWrapper.doCancelAction();
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    @Override
    public final void setEditor(ComboBoxEditor editor) {
        super.setEditor(new MyEditor(this, editor));
    }

    @Override
    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.myMinimumAndPreferredWidth;
        Dimension preferredSize = super.getPreferredSize();
        if (width < 0) {
            width = preferredSize.width;
        }
        return new Dimension(width, UIUtil.fixComboBoxHeight((int)preferredSize.height));
    }

    @Override
    public void paint(Graphics g) {
        try {
            this.myPaintingNow = true;
            super.paint(g);
            if (Boolean.TRUE != this.getClientProperty("JComboBox.isTableCellEditor") && this.isEditable) {
                MacUIUtil.drawComboboxFocusRing((JComboBox)this, (Graphics)g);
            }
        }
        finally {
            this.myPaintingNow = false;
        }
    }

    private static final class MyEditor
    implements ComboBoxEditor {
        private final JComboBox myComboBox;
        private final ComboBoxEditor myDelegate;

        MyEditor(JComboBox comboBox, ComboBoxEditor delegate) {
            this.myComboBox = comboBox;
            this.myDelegate = delegate;
            if (this.myDelegate != null) {
                this.myDelegate.addActionListener(e -> {
                    if (this.myComboBox.isPopupVisible()) {
                        this.myComboBox.setPopupVisible(false);
                    } else {
                        Object clientProperty = this.myComboBox.getClientProperty(ComboBox.TABLE_CELL_EDITOR_PROPERTY);
                        if (clientProperty instanceof CellEditor) {
                            ((CellEditor)clientProperty).stopCellEditing();
                        } else {
                            JButton button;
                            this.myComboBox.setSelectedItem(this.getItem());
                            JRootPane rootPane = this.myComboBox.getRootPane();
                            if (rootPane != null && (button = rootPane.getDefaultButton()) != null) {
                                button.doClick();
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public Component getEditorComponent() {
            return this.myDelegate == null ? null : this.myDelegate.getEditorComponent();
        }

        @Override
        public Object getItem() {
            return this.myDelegate == null ? null : this.myDelegate.getItem();
        }

        @Override
        public void selectAll() {
            if (this.myDelegate != null) {
                this.myDelegate.selectAll();
            }
        }

        @Override
        public void setItem(Object obj) {
            if (this.myDelegate != null) {
                this.myDelegate.setItem(obj);
            }
        }
    }
}

