/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentValidator {
    private static final String PROPERTY_NAME = "JComponent.componentValidator";
    private static final JBValue MAX_WIDTH = new JBValue.UIInteger("ValidationTooltip.maxWidth", 384);
    public static final Function<JComponent, JComponent> CWBB_PROVIDER = c -> ((ComponentWithBrowseButton)c).getChildComponent();
    private final Disposable parentDisposable;
    private Supplier<ValidationInfo> validator;
    private Supplier<ValidationInfo> focusValidator;
    private Function<JComponent, JComponent> outlineProvider = Function.identity();
    private HyperlinkListener hyperlinkListener;
    private ValidationInfo validationInfo;
    private final Alarm popupAlarm = new Alarm();
    private boolean isOverPopup;
    private ComponentPopupBuilder popupBuilder;
    private JBPopup popup;
    private RelativePoint popupLocation;
    private Dimension popupSize;
    private boolean disableValidation;

    public ComponentValidator(@NotNull Disposable parentDisposable) {
        this.parentDisposable = parentDisposable;
    }

    @Deprecated
    public ComponentValidator withValidator(@NotNull Consumer<ComponentValidator> validator) {
        this.validator = () -> {
            validator.accept(this);
            return this.validationInfo;
        };
        return this;
    }

    public ComponentValidator withValidator(@NotNull Supplier<ValidationInfo> validator) {
        this.validator = validator;
        return this;
    }

    public ComponentValidator withFocusValidator(@NotNull Supplier<ValidationInfo> focusValidator) {
        this.focusValidator = focusValidator;
        return this;
    }

    public ComponentValidator withHyperlinkListener(@NotNull HyperlinkListener hyperlinkListener) {
        this.hyperlinkListener = hyperlinkListener;
        return this;
    }

    public ComponentValidator withOutlineProvider(@NotNull Function<JComponent, JComponent> outlineProvider) {
        this.outlineProvider = outlineProvider;
        return this;
    }

    public ComponentValidator andStartOnFocusLost() {
        this.disableValidation = true;
        return this;
    }

    public ComponentValidator installOn(@NotNull JComponent component) {
        Component fc = ComponentValidator.getFocusable(component).orElse(this.outlineProvider.apply(component));
        component.putClientProperty(PROPERTY_NAME, this);
        ValidationFocusListener focusListener = new ValidationFocusListener();
        ValidationMouseListener mouseListener = new ValidationMouseListener();
        ComponentAdapter componentListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (ComponentValidator.this.popup != null && ComponentValidator.this.popup.isVisible() && ComponentValidator.this.popupLocation != null) {
                    ComponentValidator.this.popup.setLocation(ComponentValidator.this.popupLocation.getScreenPoint());
                }
            }
        };
        PropertyChangeListener ancestorListener = e -> {
            Window w = (Window)UIUtil.findParentByCondition((Component)((Component)e.getSource()), v -> v instanceof Window);
            if (w != null) {
                if (e.getNewValue() != null) {
                    w.addComponentListener(componentListener);
                } else {
                    w.removeComponentListener(componentListener);
                }
            }
        };
        Window w = (Window)UIUtil.findParentByCondition((Component)component, v -> v instanceof Window);
        if (w != null) {
            w.addComponentListener(componentListener);
        } else {
            component.addPropertyChangeListener("ancestor", ancestorListener);
        }
        fc.addFocusListener(focusListener);
        fc.addMouseListener(mouseListener);
        Disposer.register((Disposable)this.parentDisposable, () -> {
            fc.removeFocusListener(focusListener);
            fc.removeMouseListener(mouseListener);
            if (w != null) {
                w.removeComponentListener(componentListener);
            }
            this.validator = null;
            this.focusValidator = null;
            this.hyperlinkListener = null;
            this.outlineProvider = null;
            component.putClientProperty(PROPERTY_NAME, null);
        });
        return this;
    }

    public ComponentValidator andRegisterOnDocumentListener(final @NotNull JTextComponent textComponent) {
        textComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                ComponentValidator.getInstance(textComponent).ifPresent(ComponentValidator::revalidate);
            }
        });
        return this;
    }

    public void revalidate() {
        if (this.validator != null) {
            this.updateInfo(this.validator.get());
        }
    }

    public static Optional<ComponentValidator> getInstance(@NotNull JComponent component) {
        return Optional.ofNullable((ComponentValidator)component.getClientProperty(PROPERTY_NAME));
    }

    private void reset() {
        if (this.validationInfo != null && this.validationInfo.component != null) {
            this.outlineProvider.apply(this.validationInfo.component).putClientProperty("JComponent.outline", null);
            this.validationInfo.component.revalidate();
            this.validationInfo.component.repaint();
        }
        this.hidePopup(true);
        this.popupBuilder = null;
        this.popupLocation = null;
        this.popupSize = null;
        this.validationInfo = null;
    }

    public void updateInfo(@Nullable ValidationInfo info) {
        boolean newInfo;
        if (this.disableValidation) {
            return;
        }
        boolean resetInfo = info == null && this.validationInfo != null;
        boolean bl = newInfo = info != null && !info.equals(this.validationInfo);
        if (resetInfo || newInfo) {
            this.reset();
            this.validationInfo = info;
            if (newInfo) {
                JComponent component = this.validationInfo.component;
                if (component != null) {
                    this.outlineProvider.apply(component).putClientProperty("JComponent.outline", this.validationInfo.warning ? "warning" : "error");
                    component.revalidate();
                    component.repaint();
                }
                if (StringUtil.isNotEmpty((String)this.validationInfo.message)) {
                    this.popupBuilder = ComponentValidator.createPopupBuilder(this.validationInfo, tipComponent -> {
                        tipComponent.addHyperlinkListener(this.hyperlinkListener);
                        tipComponent.addMouseListener(new TipComponentMouseListener());
                        this.popupSize = tipComponent.getPreferredSize();
                    }).setCancelOnMouseOutCallback(e -> e.getID() == 501 && !ComponentValidator.withinComponent(info, e));
                    ComponentValidator.getFocusable(component).ifPresent(fc -> {
                        if (fc.hasFocus()) {
                            this.showPopup();
                        }
                    });
                }
            }
        }
    }

    @NotNull
    public static ComponentPopupBuilder createPopupBuilder(@NotNull ValidationInfo info, @Nullable Consumer<JEditorPane> configurator) {
        JEditorPane tipComponent = new JEditorPane();
        View v = BasicHTML.createHTMLView(tipComponent, String.format("<html>%s</html>", info.message));
        String text = v.getPreferredSpan(0) > (float)MAX_WIDTH.get() ? String.format("<html><div width=%d>%s</div></html>", MAX_WIDTH.get(), info.message) : String.format("<html><div>%s</div></html>", info.message);
        tipComponent.setContentType("text/html");
        tipComponent.setEditable(false);
        tipComponent.setEditorKit(UIUtil.getHTMLEditorKit());
        EditorKit kit = tipComponent.getEditorKit();
        if (kit instanceof HTMLEditorKit) {
            StyleSheet css = ((HTMLEditorKit)kit).getStyleSheet();
            css.addRule("a, a:link {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkColor()) + ";}");
            css.addRule("a:visited {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkVisitedColor()) + ";}");
            css.addRule("a:hover {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkHoverColor()) + ";}");
            css.addRule("a:active {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkPressedColor()) + ";}");
            css.addRule("body {background-color:#" + ColorUtil.toHex((Color)(info.warning ? JBUI.CurrentTheme.Validator.warningBackgroundColor() : JBUI.CurrentTheme.Validator.errorBackgroundColor())) + ";}");
        }
        if (tipComponent.getCaret() instanceof DefaultCaret) {
            ((DefaultCaret)tipComponent.getCaret()).setUpdatePolicy(1);
        }
        tipComponent.setCaretPosition(0);
        tipComponent.setText(text);
        tipComponent.setBackground(info.warning ? JBUI.CurrentTheme.Validator.warningBackgroundColor() : JBUI.CurrentTheme.Validator.errorBackgroundColor());
        tipComponent.setOpaque(true);
        tipComponent.setBorder(ComponentValidator.getBorder());
        if (configurator != null) {
            configurator.accept(tipComponent);
        }
        return JBPopupFactory.getInstance().createComponentPopupBuilder(tipComponent, null).setBorderColor(info.warning ? JBUI.CurrentTheme.Validator.warningBorderColor() : JBUI.CurrentTheme.Validator.errorBorderColor()).setCancelOnClickOutside(false).setShowShadow(false);
    }

    public static boolean withinComponent(@NotNull ValidationInfo info, @NotNull MouseEvent e) {
        if (info.component != null && info.component.isShowing()) {
            Rectangle screenBounds = new Rectangle(info.component.getLocationOnScreen(), info.component.getSize());
            return screenBounds.contains(e.getLocationOnScreen());
        }
        return false;
    }

    private void showPopup() {
        if ((this.popup == null || !this.popup.isVisible()) && this.popupBuilder != null && this.validationInfo != null && this.validationInfo.component != null && this.validationInfo.component.isEnabled()) {
            this.popup = this.popupBuilder.createPopup();
            Insets i = this.validationInfo.component.getInsets();
            Point point = new Point(JBUI.scale((int)40), i.top - JBUI.scale((int)6) - this.popupSize.height);
            this.popupLocation = new RelativePoint((Component)this.validationInfo.component, point);
            this.popup.show(this.popupLocation);
        }
    }

    private void hidePopup(boolean now) {
        if (this.popup != null && this.popup.isVisible()) {
            if (now || this.hyperlinkListener == null) {
                this.popup.cancel();
                this.popup = null;
            } else {
                this.popupAlarm.addRequest(() -> {
                    if (!this.isOverPopup || this.hyperlinkListener == null) {
                        this.hidePopup(true);
                    }
                }, Registry.intValue((String)"ide.tooltip.initialDelay.highlighter"));
            }
        }
    }

    public static Border getBorder() {
        Insets i = UIManager.getInsets("ValidationTooltip.borderInsets");
        return i != null ? new JBEmptyBorder(i) : JBUI.Borders.empty((int)4, (int)8);
    }

    private static Optional<Component> getFocusable(Component source) {
        return source instanceof JComboBox && !((JComboBox)source).isEditable() || source instanceof JCheckBox || source instanceof JRadioButton ? Optional.of(source) : ((JBTreeTraverser)UIUtil.uiTraverser((Component)source).filter(c -> c instanceof JTextComponent && c.isFocusable())).toList().stream().findFirst();
    }

    private class TipComponentMouseListener
    extends MouseAdapter {
        private TipComponentMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ComponentValidator.this.isOverPopup = true;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ComponentValidator.this.isOverPopup = false;
            if (ComponentValidator.this.popup != null) {
                ComponentValidator.getFocusable(((ComponentValidator)ComponentValidator.this).validationInfo.component).ifPresent(fc -> {
                    if (!fc.hasFocus()) {
                        ComponentValidator.this.popup.cancel();
                        ComponentValidator.this.popup = null;
                    }
                });
            }
        }
    }

    private class ValidationMouseListener
    extends MouseAdapter {
        private ValidationMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ComponentValidator.this.showPopup();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (ComponentValidator.this.validationInfo != null) {
                ComponentValidator.getFocusable(((ComponentValidator)ComponentValidator.this).validationInfo.component).ifPresent(fc -> {
                    if (!fc.hasFocus()) {
                        ComponentValidator.this.hidePopup(false);
                    }
                });
            }
        }
    }

    private class ValidationFocusListener
    implements FocusListener {
        private ValidationFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            ComponentValidator.this.showPopup();
        }

        @Override
        public void focusLost(FocusEvent e) {
            ComponentValidator.this.hidePopup(false);
            ValidationInfo info = null;
            if (ComponentValidator.this.focusValidator != null) {
                info = (ValidationInfo)ComponentValidator.this.focusValidator.get();
            }
            if (info != null) {
                ComponentValidator.this.updateInfo(info);
            } else if (ComponentValidator.this.disableValidation) {
                ComponentValidator.this.disableValidation = false;
                ComponentValidator.this.revalidate();
            }
        }
    }
}

