/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentWithBrowseButton<Comp extends JComponent>
extends JPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ComponentWithBrowseButton.class);
    private final Comp myComponent;
    private final FixedSizeButton myBrowseButton;
    private boolean myButtonEnabled = true;
    private KeyEvent myCurrentEvent = null;

    public ComponentWithBrowseButton(@NotNull Comp component, @Nullable ActionListener browseActionListener) {
        super(new BorderLayout(SystemInfo.isMac || UIUtil.isUnderDarcula() ? 0 : 2, 0));
        boolean inlineBrowseButton;
        this.myComponent = component;
        this.setFocusable(false);
        boolean bl = inlineBrowseButton = this.myComponent instanceof ExtendableTextComponent && Experiments.isFeatureEnabled("inline.browse.button");
        if (inlineBrowseButton) {
            ((ExtendableTextComponent)this.myComponent).addExtension(ExtendableTextComponent.Extension.create(this.getDefaultIcon(), this.getHoveredIcon(), this.getIconTooltip(), this::notifyActionListeners));
            new DumbAwareAction(){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    ComponentWithBrowseButton.this.notifyActionListeners();
                }
            }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64)), (JComponent)this.myComponent);
        }
        this.add((Component)this.myComponent, "Center");
        this.myBrowseButton = new FixedSizeButton((JComponent)this.myComponent);
        if (browseActionListener != null) {
            this.myBrowseButton.addActionListener(browseActionListener);
        }
        if (!inlineBrowseButton) {
            this.add((Component)this.myBrowseButton, "East");
        }
        this.myBrowseButton.setToolTipText(this.getIconTooltip());
        if (ApplicationManager.getApplication() != null) {
            new MyDoClickAction(this.myBrowseButton).registerShortcut((JComponent)this.myComponent);
        }
        if (ScreenReader.isActive()) {
            this.myBrowseButton.setFocusable(true);
            this.myBrowseButton.getAccessibleContext().setAccessibleName("Browse");
        }
    }

    @NotNull
    protected Icon getDefaultIcon() {
        return AllIcons.General.OpenDisk;
    }

    @NotNull
    protected Icon getHoveredIcon() {
        return AllIcons.General.OpenDiskHover;
    }

    @NotNull
    protected String getIconTooltip() {
        return UIBundle.message((String)"component.with.browse.button.browse.button.tooltip.text", (Object[])new Object[0]) + " (" + KeymapUtil.getKeystrokeText(KeyStroke.getKeyStroke(10, 64)) + ")";
    }

    private void notifyActionListeners() {
        ActionEvent event = new ActionEvent(this.myComponent, 1001, "action");
        for (ActionListener listener : this.myBrowseButton.getActionListeners()) {
            listener.actionPerformed(event);
        }
    }

    @NotNull
    public final Comp getChildComponent() {
        return this.myComponent;
    }

    public void setTextFieldPreferredWidth(int charCount) {
        Comp comp = this.getChildComponent();
        Dimension size = GuiUtils.getSizeByChars(charCount, comp);
        ((JComponent)comp).setPreferredSize(size);
        Dimension preferredSize = this.myBrowseButton.getPreferredSize();
        boolean keepHeight = UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderWin10LookAndFeel();
        preferredSize.setSize(size.width + preferredSize.width + 2, keepHeight ? preferredSize.height : preferredSize.height + 2);
        this.setPreferredSize(preferredSize);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myBrowseButton.setEnabled(enabled && this.myButtonEnabled);
        ((JComponent)this.myComponent).setEnabled(enabled);
    }

    public void setButtonEnabled(boolean buttonEnabled) {
        this.myButtonEnabled = buttonEnabled;
        this.setEnabled(this.isEnabled());
    }

    public void setButtonIcon(Icon icon) {
        this.myBrowseButton.setIcon(icon);
        this.myBrowseButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
    }

    public void addActionListener(ActionListener listener) {
        this.myBrowseButton.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.myBrowseButton.removeActionListener(listener);
    }

    public void addBrowseFolderListener(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable @Nls(capitalization=Nls.Capitalization.Sentence) String description, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor<Comp> accessor) {
        this.addActionListener(new BrowseFolderActionListener<Comp>(title, description, this, project, fileChooserDescriptor, accessor));
    }

    @Deprecated
    public void addBrowseFolderListener(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable @Nls(capitalization=Nls.Capitalization.Sentence) String description, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor<Comp> accessor, boolean autoRemoveOnHide) {
        this.addBrowseFolderListener(title, description, project, fileChooserDescriptor, accessor);
    }

    @Deprecated
    public void addBrowseFolderListener(@Nullable Project project, BrowseFolderActionListener<Comp> actionListener) {
        this.addActionListener(actionListener);
    }

    public void dispose() {
        ActionListener[] listeners;
        for (ActionListener listener : listeners = this.myBrowseButton.getActionListeners()) {
            this.myBrowseButton.removeActionListener(listener);
        }
    }

    public FixedSizeButton getButton() {
        return this.myBrowseButton;
    }

    @Override
    public final void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myComponent, true));
    }

    @Override
    public final void setNextFocusableComponent(Component aComponent) {
        super.setNextFocusableComponent(aComponent);
        ((JComponent)this.myComponent).setNextFocusableComponent(aComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (condition == 0 && this.myCurrentEvent != e) {
            try {
                this.myCurrentEvent = e;
                ((Component)this.myComponent).dispatchEvent(e);
            }
            finally {
                this.myCurrentEvent = null;
            }
        }
        if (e.isConsumed()) {
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    @Deprecated
    public void addBrowseFolderListener(@Nullable Project project, BrowseFolderActionListener<Comp> actionListener, boolean autoRemoveOnHide) {
        this.addActionListener(actionListener);
    }

    public static class BrowseFolderActionListener<T extends JComponent>
    implements ActionListener {
        private final String myTitle;
        private final String myDescription;
        protected ComponentWithBrowseButton<T> myTextComponent;
        private final TextComponentAccessor<? super T> myAccessor;
        private Project myProject;
        protected final FileChooserDescriptor myFileChooserDescriptor;

        public BrowseFolderActionListener(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable @Nls(capitalization=Nls.Capitalization.Sentence) String description, ComponentWithBrowseButton<T> textField, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor<? super T> accessor) {
            if (fileChooserDescriptor != null && fileChooserDescriptor.isChooseMultiple()) {
                LOG.error("multiple selection not supported");
                fileChooserDescriptor = new FileChooserDescriptor(fileChooserDescriptor){

                    @Override
                    public boolean isChooseMultiple() {
                        return false;
                    }
                };
            }
            this.myTitle = title;
            this.myDescription = description;
            this.myTextComponent = textField;
            this.myProject = project;
            this.myFileChooserDescriptor = fileChooserDescriptor;
            this.myAccessor = accessor;
        }

        @Nullable
        protected Project getProject() {
            return this.myProject;
        }

        protected void setProject(@Nullable Project project) {
            this.myProject = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileChooserDescriptor fileChooserDescriptor = this.myFileChooserDescriptor;
            if (this.myTitle != null || this.myDescription != null) {
                fileChooserDescriptor = (FileChooserDescriptor)this.myFileChooserDescriptor.clone();
                if (this.myTitle != null) {
                    fileChooserDescriptor.setTitle(this.myTitle);
                }
                if (this.myDescription != null) {
                    fileChooserDescriptor.setDescription(this.myDescription);
                }
            }
            FileChooser.chooseFile(fileChooserDescriptor, this.getProject(), this.myTextComponent, this.getInitialFile(), (Consumer<? super VirtualFile>)((Consumer)this::onFileChosen));
        }

        @Nullable
        protected VirtualFile getInitialFile() {
            int pos;
            String directoryName = this.getComponentText();
            if (StringUtil.isEmptyOrSpaces((String)directoryName)) {
                return null;
            }
            directoryName = FileUtil.toSystemIndependentName((String)directoryName);
            VirtualFile path2 = LocalFileSystem.getInstance().findFileByPath(this.expandPath(directoryName));
            while (path2 == null && directoryName.length() > 0 && (pos = directoryName.lastIndexOf(47)) > 0) {
                directoryName = directoryName.substring(0, pos);
                path2 = LocalFileSystem.getInstance().findFileByPath(directoryName);
            }
            return path2;
        }

        @NotNull
        protected String expandPath(@NotNull String path2) {
            return path2;
        }

        protected String getComponentText() {
            return this.myAccessor.getText(this.myTextComponent.getChildComponent()).trim();
        }

        @NotNull
        protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
            return chosenFile.getPresentableUrl();
        }

        protected void onFileChosen(@NotNull VirtualFile chosenFile) {
            this.myAccessor.setText(this.myTextComponent.getChildComponent(), this.chosenFileToResultingText(chosenFile));
        }
    }

    public static final class MyDoClickAction
    extends DumbAwareAction {
        private final FixedSizeButton myBrowseButton;

        public MyDoClickAction(FixedSizeButton browseButton) {
            this.myBrowseButton = browseButton;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(this.myBrowseButton.isVisible() && this.myBrowseButton.isEnabled());
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myBrowseButton.doClick();
        }

        public void registerShortcut(JComponent textField) {
            CustomShortcutSet shiftEnter = new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64));
            this.registerCustomShortcutSet(shiftEnter, textField);
            this.myBrowseButton.setToolTipText(KeymapUtil.getShortcutsText(shiftEnter.getShortcuts()));
        }

        public static void addTo(FixedSizeButton browseButton, JComponent aComponent) {
            new MyDoClickAction(browseButton).registerShortcut(aComponent);
        }
    }
}

