/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.eventLog.FeatureUsageUiEventsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.MacOtherAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogEarthquakeShaker;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.DialogWrapperPeerFactory;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.ui.DialogWrapper");
    public static final int OK_EXIT_CODE = 0;
    public static final int CANCEL_EXIT_CODE = 1;
    public static final int CLOSE_EXIT_CODE = 1;
    public static final int NEXT_USER_EXIT_CODE = 2;
    @NonNls
    public static final String DEFAULT_ACTION = "DefaultAction";
    @NonNls
    public static final String FOCUSED_ACTION = "FocusedAction";
    @NonNls
    private static final String NO_AUTORESIZE = "NoAutoResizeAndFit";
    private static final KeyStroke SHOW_OPTION_KEYSTROKE = KeyStroke.getKeyStroke(10, 9);
    @NotNull
    private final DialogWrapperPeer myPeer;
    private int myExitCode = 1;
    public static final Border ourDefaultBorder = new JBEmptyBorder(UIUtil.PANEL_REGULAR_INSETS);
    private float myHorizontalStretch = 1.0f;
    private float myVerticalStretch = 1.0f;
    private int myButtonAlignment = 4;
    private boolean myCrossClosesWindow = true;
    protected Action myOKAction;
    protected Action myCancelAction;
    protected Action myHelpAction;
    private final Map<Action, JButton> myButtonMap = new LinkedHashMap<Action, JButton>();
    private final boolean myCreateSouthSection;
    private boolean myClosed = false;
    protected boolean myPerformAction = false;
    private Action myYesAction = null;
    private Action myNoAction = null;
    protected JCheckBox myCheckBoxDoNotShowDialog;
    @Nullable
    private DoNotAskOption myDoNotAsk;
    protected JComponent myPreferredFocusedComponent;
    private Computable<Point> myInitialLocationCallback;
    private Dimension myActualSize = null;
    private List<ValidationInfo> myInfo = Collections.emptyList();
    @NotNull
    protected final Disposable myDisposable = new Disposable(){

        public String toString() {
            return DialogWrapper.this.toString();
        }

        public void dispose() {
            DialogWrapper.this.dispose();
        }
    };
    private final List<JBOptionButton> myOptionsButtons = new ArrayList<JBOptionButton>();
    private int myCurrentOptionsButtonIndex = -1;
    private boolean myResizeInProgress = false;
    private ComponentAdapter myResizeListener;
    private ErrorText myErrorText;
    private final Alarm myErrorTextAlarm = new Alarm();
    public static final Color BALLOON_WARNING_BORDER = new JBColor(new Color(13412457), new Color(5129519));
    public static final Color BALLOON_WARNING_BACKGROUND = new JBColor(new Color(16381166), new Color(5852722));
    private final Alarm myValidationAlarm = new Alarm(this.getValidationThreadToUse(), this.myDisposable);
    private int myValidationDelay = 300;
    private boolean myDisposed = false;
    private boolean myValidationStarted = false;
    private final ErrorPainter myErrorPainter = new ErrorPainter();
    private boolean myErrorPainterInstalled = false;
    private final JBValue BASE_BUTTON_GAP = new JBValue.Float(UIUtil.isUnderWin10LookAndFeel() ? 8.0f : 12.0f);
    public static final Color ERROR_FOREGROUND_COLOR = JBColor.namedColor((String)"Label.errorForeground", (Color)new JBColor(new Color(13050413), (Color)JBColor.RED));

    @NotNull
    protected String getDoNotShowMessage() {
        return CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
    }

    public void setDoNotAskOption(@Nullable DoNotAskOption doNotAsk) {
        this.myDoNotAsk = doNotAsk;
    }

    protected DialogWrapper(@Nullable Project project, boolean canBeParent) {
        this(project, canBeParent, IdeModalityType.IDE);
    }

    protected DialogWrapper(@Nullable Project project, boolean canBeParent, @NotNull IdeModalityType ideModalityType) {
        this(project, null, canBeParent, ideModalityType);
    }

    protected DialogWrapper(@Nullable Project project, @Nullable Component parentComponent, boolean canBeParent, @NotNull IdeModalityType ideModalityType) {
        this(project, parentComponent, canBeParent, ideModalityType, true);
    }

    protected DialogWrapper(@Nullable Project project, @Nullable Component parentComponent, boolean canBeParent, @NotNull IdeModalityType ideModalityType, boolean createSouth) {
        this.myPeer = parentComponent == null ? this.createPeer(project, canBeParent, project == null ? IdeModalityType.IDE : ideModalityType) : this.createPeer(parentComponent, canBeParent);
        this.myCreateSouthSection = createSouth;
        Window window = this.myPeer.getWindow();
        if (window != null) {
            this.myResizeListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (!DialogWrapper.this.myResizeInProgress) {
                        DialogWrapper.this.myActualSize = DialogWrapper.this.myPeer.getSize();
                        if (DialogWrapper.this.myErrorText != null && DialogWrapper.this.myErrorText.isVisible()) {
                            ((DialogWrapper)DialogWrapper.this).myActualSize.height -= ((DialogWrapper)DialogWrapper.this).myErrorText.getMinimumSize().height;
                        }
                    }
                }
            };
            window.addComponentListener(this.myResizeListener);
        }
        this.createDefaultActions();
    }

    protected DialogWrapper(@Nullable Project project) {
        this(project, true);
    }

    protected DialogWrapper(boolean canBeParent) {
        this((Project)null, canBeParent);
    }

    @Deprecated
    protected DialogWrapper(boolean canBeParent, boolean applicationModalIfPossible) {
        this(null, canBeParent, applicationModalIfPossible);
    }

    protected DialogWrapper(Project project, boolean canBeParent, boolean applicationModalIfPossible) {
        DialogWrapper.ensureEventDispatchThread();
        this.myPeer = ApplicationManager.getApplication() != null ? this.createPeer(project != null ? WindowManager.getInstance().suggestParentWindow(project) : WindowManager.getInstance().findVisibleFrame(), canBeParent, applicationModalIfPossible) : this.createPeer(null, canBeParent, applicationModalIfPossible);
        this.myCreateSouthSection = true;
        this.createDefaultActions();
    }

    protected DialogWrapper(@NotNull Component parent, boolean canBeParent) {
        DialogWrapper.ensureEventDispatchThread();
        this.myCreateSouthSection = true;
        this.myPeer = this.createPeer(parent, canBeParent);
        this.createDefaultActions();
    }

    @NotNull
    protected Alarm.ThreadToUse getValidationThreadToUse() {
        return Alarm.ThreadToUse.SWING_THREAD;
    }

    protected boolean postponeValidation() {
        return true;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return null;
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        ValidationInfo vi = this.doValidate();
        return vi != null ? Collections.singletonList(vi) : Collections.EMPTY_LIST;
    }

    public void setValidationDelay(int delay) {
        this.myValidationDelay = delay;
    }

    private void installErrorPainter() {
        if (this.myErrorPainterInstalled) {
            return;
        }
        this.myErrorPainterInstalled = true;
        UIUtil.invokeLaterIfNeeded(() -> IdeGlassPaneUtil.installPainter(this.getContentPanel(), this.myErrorPainter, this.myDisposable));
    }

    protected void updateErrorInfo(@NotNull List<ValidationInfo> info) {
        boolean updateNeeded;
        boolean bl = Registry.is((String)"ide.inplace.validation.tooltip") ? !this.myInfo.equals(info) : (updateNeeded = !this.myErrorText.isTextSet(info));
        if (updateNeeded) {
            SwingUtilities.invokeLater(() -> {
                if (this.myDisposed) {
                    return;
                }
                this.setErrorInfoAll(info);
                this.myPeer.getRootPane().getGlassPane().repaint();
                this.getOKAction().setEnabled(info.isEmpty() || info.stream().allMatch(info1 -> info1.okEnabled));
            });
        }
    }

    protected void createDefaultActions() {
        this.myOKAction = new OkAction();
        this.myCancelAction = new CancelAction();
        this.myHelpAction = new HelpAction();
    }

    public void setUndecorated(boolean undecorated) {
        this.myPeer.setUndecorated(undecorated);
    }

    public final void addMouseListener(@NotNull MouseListener listener) {
        this.myPeer.addMouseListener(listener);
    }

    public final void addMouseListener(@NotNull MouseMotionListener listener) {
        this.myPeer.addMouseListener(listener);
    }

    public final void addKeyListener(@NotNull KeyListener listener) {
        this.myPeer.addKeyListener(listener);
    }

    public final void close(int exitCode, boolean isOk) {
        DialogWrapper.ensureEventDispatchThread();
        if (this.myClosed) {
            return;
        }
        this.myClosed = true;
        this.myExitCode = exitCode;
        Window window = this.getWindow();
        if (window != null && this.myResizeListener != null) {
            window.removeComponentListener(this.myResizeListener);
            this.myResizeListener = null;
        }
        if (isOk) {
            this.processDoNotAskOnOk(exitCode);
        } else {
            this.processDoNotAskOnCancel();
        }
        Disposer.dispose((Disposable)this.myDisposable);
    }

    public final void close(int exitCode) {
        this.logCloseDialogEvent(exitCode);
        this.close(exitCode, exitCode != 1);
    }

    @Nullable
    protected Border createContentPaneBorder() {
        if (this.getStyle() == DialogStyle.COMPACT) {
            return JBUI.Borders.empty();
        }
        return ourDefaultBorder;
    }

    protected static boolean isMoveHelpButtonLeft() {
        return UIUtil.isUnderAquaBasedLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderWin10LookAndFeel();
    }

    private static boolean isRemoveHelpButton() {
        return !ApplicationInfo.contextHelpAvailable() || Registry.is((String)"ide.remove.help.button.from.dialogs");
    }

    protected JComponent createSouthPanel() {
        List<Action> actions = ContainerUtil.filter((Object[])this.createActions(), (Condition)Condition.NOT_NULL);
        List<Action> leftSideActions = ContainerUtil.filter((Object[])this.createLeftSideActions(), (Condition)Condition.NOT_NULL);
        Action helpAction = this.getHelpAction();
        boolean addHelpToLeftSide = false;
        if (DialogWrapper.isRemoveHelpButton()) {
            actions.remove(helpAction);
        } else if (DialogWrapper.isMoveHelpButtonLeft() && actions.remove(helpAction) && !leftSideActions.contains(helpAction)) {
            addHelpToLeftSide = true;
        }
        if (SystemInfo.isMac) {
            int cancelNdx;
            int okNdx;
            Action macOtherAction = (Action)ContainerUtil.find(actions, MacOtherAction.class::isInstance);
            if (macOtherAction != null) {
                leftSideActions.add(macOtherAction);
                actions.remove(macOtherAction);
            }
            if ((okNdx = actions.indexOf(this.getOKAction())) >= 0 && okNdx != actions.size() - 1) {
                actions.remove(this.getOKAction());
                actions.add(this.getOKAction());
            }
            if ((cancelNdx = actions.indexOf(this.getCancelAction())) > 0) {
                actions.remove(this.getCancelAction());
                actions.add(okNdx < 0 ? 0 : actions.size() - 1, this.getCancelAction());
            }
        }
        if (!UISettings.getShadowInstance().getAllowMergeButtons()) {
            actions = DialogWrapper.flattenOptionsActions(actions);
            leftSideActions = DialogWrapper.flattenOptionsActions(leftSideActions);
        }
        List<JButton> leftSideButtons = this.createButtons(leftSideActions);
        List<JButton> rightSideButtons = this.createButtons(actions);
        int index2 = 0;
        this.myButtonMap.clear();
        for (JButton button : ContainerUtil.concat(leftSideButtons, rightSideButtons)) {
            this.myButtonMap.put(button.getAction(), button);
            if (button instanceof JBOptionButton) {
                this.myOptionsButtons.add((JBOptionButton)button);
            }
            TouchbarDataKeys.putDialogButtonDescriptor(button, index2++).setMainGroup(index2 >= leftSideButtons.size());
        }
        return this.createSouthPanel(leftSideButtons, rightSideButtons, addHelpToLeftSide);
    }

    @NotNull
    protected JButton createHelpButton(Insets insets) {
        JButton helpButton = new JButton(this.getHelpAction());
        helpButton.putClientProperty("JButton.buttonType", "help");
        helpButton.setText("");
        helpButton.setMargin(insets);
        this.setHelpTooltip(helpButton);
        helpButton.addPropertyChangeListener("ancestor", evt -> {
            if (evt.getNewValue() == null) {
                HelpTooltip.dispose((JComponent)evt.getSource());
            }
        });
        return helpButton;
    }

    protected void setHelpTooltip(JButton helpButton) {
        helpButton.setToolTipText(ActionsBundle.actionDescription("HelpTopics"));
    }

    @NotNull
    private static List<Action> flattenOptionsActions(@NotNull List<Action> actions) {
        ArrayList<Action> newActions = new ArrayList<Action>();
        for (Action action : actions) {
            newActions.add(action);
            if (!(action instanceof OptionAction)) continue;
            ContainerUtil.addAll(newActions, (Object[])((OptionAction)action).getOptions());
        }
        return newActions;
    }

    protected boolean shouldAddErrorNearButtons() {
        return false;
    }

    @NotNull
    protected DialogStyle getStyle() {
        return DialogStyle.NO_STYLE;
    }

    protected boolean toBeShown() {
        return !this.myCheckBoxDoNotShowDialog.isSelected();
    }

    public boolean isTypeAheadEnabled() {
        return false;
    }

    @NotNull
    private List<JButton> createButtons(@NotNull List<Action> actions) {
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        for (Action action : actions) {
            buttons.add(this.createJButtonForAction(action));
        }
        return buttons;
    }

    @NotNull
    private JPanel createSouthPanel(@NotNull List<JButton> leftSideButtons, @NotNull List<JButton> rightSideButtons, boolean addHelpToLeftSide) {
        JBInsets insets;
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            public Color getBackground() {
                Color bg = UIManager.getColor("DialogWrapper.southPanelBackground");
                if (DialogWrapper.this.getStyle() == DialogStyle.COMPACT && bg != null) {
                    return bg;
                }
                return super.getBackground();
            }
        };
        if (this.myDoNotAsk != null) {
            this.myCheckBoxDoNotShowDialog = new JCheckBox(this.myDoNotAsk.getDoNotShowMessage());
            this.myCheckBoxDoNotShowDialog.setVisible(this.myDoNotAsk.canBeHidden());
            this.myCheckBoxDoNotShowDialog.setSelected(!this.myDoNotAsk.isToBeShown());
            DialogUtil.registerMnemonic(this.myCheckBoxDoNotShowDialog, '&');
        }
        JComponent doNotAskCheckbox = this.createDoNotAskCheckbox();
        NonOpaquePanel lrButtonsPanel = new NonOpaquePanel(new GridBagLayout());
        JBInsets jBInsets = insets = SystemInfo.isMacOSLeopard && UIUtil.isUnderIntelliJLaF() ? JBUI.insets((int)0, (int)8) : JBUI.emptyInsets();
        if (rightSideButtons.size() > 0 || leftSideButtons.size() > 0) {
            JPanel buttonsPanel;
            GridBag bag = new GridBag().setDefaultInsets((Insets)insets);
            if (leftSideButtons.size() > 0) {
                buttonsPanel = this.createButtonsPanel(leftSideButtons);
                if (rightSideButtons.size() > 0) {
                    buttonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
                }
                lrButtonsPanel.add((Component)buttonsPanel, bag.next());
            }
            lrButtonsPanel.add(Box.createHorizontalGlue(), bag.next().weightx(1.0).fillCellHorizontally());
            if (rightSideButtons.size() > 0) {
                buttonsPanel = this.createButtonsPanel(rightSideButtons);
                if (this.shouldAddErrorNearButtons()) {
                    lrButtonsPanel.add((Component)this.myErrorText, bag.next());
                    lrButtonsPanel.add(Box.createHorizontalStrut(10), bag.next());
                }
                lrButtonsPanel.add((Component)buttonsPanel, bag.next());
            }
            if (0 == this.myButtonAlignment && doNotAskCheckbox == null) {
                lrButtonsPanel.add(Box.createHorizontalGlue(), bag.next().weightx(1.0).fillCellHorizontally());
            }
        }
        JButton helpButton = null;
        if (addHelpToLeftSide) {
            helpButton = this.createHelpButton((Insets)insets);
        }
        JPanel eastPanel = this.createSouthAdditionalPanel();
        if (helpButton != null || doNotAskCheckbox != null || eastPanel != null) {
            JPanel leftPanel = new JPanel(new BorderLayout());
            if (helpButton != null) {
                leftPanel.add((Component)helpButton, "West");
            }
            if (doNotAskCheckbox != null) {
                doNotAskCheckbox.setBorder((Border)JBUI.Borders.emptyRight((int)20));
                leftPanel.add((Component)doNotAskCheckbox, "Center");
            }
            if (eastPanel != null) {
                leftPanel.add((Component)eastPanel, "East");
            }
            panel.add((Component)leftPanel, "West");
        }
        panel.add((Component)lrButtonsPanel, "Center");
        if (this.getStyle() == DialogStyle.COMPACT) {
            Color color = UIManager.getColor("DialogWrapper.southPanelDivider");
            CustomLineBorder line = new CustomLineBorder(color != null ? color : OnePixelDivider.BACKGROUND, 1, 0, 0, 0);
            panel.setBorder(new CompoundBorder((Border)line, (Border)JBUI.Borders.empty((int)8, (int)12)));
        } else {
            panel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        }
        return panel;
    }

    @Nullable
    protected JComponent createDoNotAskCheckbox() {
        return this.myCheckBoxDoNotShowDialog != null && this.myCheckBoxDoNotShowDialog.isVisible() ? this.myCheckBoxDoNotShowDialog : null;
    }

    @NotNull
    protected JPanel createButtonsPanel(@NotNull List<? extends JButton> buttons) {
        NonOpaquePanel buttonsPanel = new NonOpaquePanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        for (int i = 0; i < buttons.size(); ++i) {
            JComponent button = buttons.get(i);
            Insets insets = button.getInsets();
            buttonsPanel.add(button);
            if (i >= buttons.size() - 1) continue;
            int gap = UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF() ? this.BASE_BUTTON_GAP.get() - insets.left - insets.right : JBUI.scale((int)8);
            buttonsPanel.add(Box.createRigidArea(new Dimension(gap, 0)));
        }
        return buttonsPanel;
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        return null;
    }

    @Nullable
    protected JButton getButton(@NotNull Action action) {
        return this.myButtonMap.get(action);
    }

    protected JButton createJButtonForAction(Action action) {
        JButton button = action instanceof OptionAction && UISettings.getShadowInstance().getAllowMergeButtons() ? this.createJOptionsButton((OptionAction)action) : new JButton(action);
        if (SystemInfo.isMac) {
            button.putClientProperty("JButton.buttonType", "text");
        }
        Pair<Integer, String> pair = DialogWrapper.extractMnemonic(button.getText());
        button.setText((String)pair.second);
        int mnemonic = (Integer)pair.first;
        Object value = action.getValue("MnemonicKey");
        if (value instanceof Integer) {
            mnemonic = (Integer)value;
        }
        button.setMnemonic(mnemonic);
        Object name = action.getValue("Name");
        if (mnemonic == 89 && "Yes".equals(name)) {
            this.myYesAction = action;
        } else if (mnemonic == 78 && "No".equals(name)) {
            this.myNoAction = action;
        }
        if (action.getValue(DEFAULT_ACTION) != null && !this.myPeer.isHeadless()) {
            this.getRootPane().setDefaultButton(button);
        }
        if (action.getValue(FOCUSED_ACTION) != null) {
            this.myPreferredFocusedComponent = button;
        }
        return button;
    }

    @NotNull
    private JButton createJOptionsButton(@NotNull OptionAction action) {
        JBOptionButton optionButton = new JBOptionButton(action, action.getOptions());
        String tooltip = String.format("Show drop-down menu (%s)", KeymapUtil.getKeystrokeText(SHOW_OPTION_KEYSTROKE));
        optionButton.setOptionTooltipText(tooltip);
        optionButton.setOkToProcessDefaultMnemonics(false);
        return optionButton;
    }

    @NotNull
    public static Pair<Integer, String> extractMnemonic(@Nullable String text) {
        if (text == null) {
            return Pair.create((Object)0, null);
        }
        int mnemonic = 0;
        StringBuilder plainText = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            int ch = text.charAt(i);
            if (ch == 95 || ch == 38) {
                if (++i >= text.length()) break;
                ch = text.charAt(i);
                if (ch != 95 && ch != 38) {
                    int vk = ch;
                    if (vk >= 97 && vk <= 122) {
                        vk -= 32;
                    }
                    mnemonic = vk;
                }
            }
            plainText.append((char)ch);
        }
        return Pair.create((Object)mnemonic, (Object)plainText.toString());
    }

    @NotNull
    protected DialogWrapperPeer createPeer(@NotNull Component parent, boolean canBeParent) {
        return DialogWrapperPeerFactory.getInstance().createPeer(this, parent, canBeParent);
    }

    @Deprecated
    @NotNull
    protected DialogWrapperPeer createPeer(boolean canBeParent, boolean applicationModalIfPossible) {
        return this.createPeer(null, canBeParent, applicationModalIfPossible);
    }

    @NotNull
    protected DialogWrapperPeer createPeer(Window owner, boolean canBeParent, IdeModalityType ideModalityType) {
        return DialogWrapperPeerFactory.getInstance().createPeer(this, owner, canBeParent, ideModalityType);
    }

    @Deprecated
    @NotNull
    protected DialogWrapperPeer createPeer(Window owner, boolean canBeParent, boolean applicationModalIfPossible) {
        return DialogWrapperPeerFactory.getInstance().createPeer(this, owner, canBeParent, applicationModalIfPossible ? IdeModalityType.IDE : IdeModalityType.PROJECT);
    }

    @NotNull
    protected DialogWrapperPeer createPeer(@Nullable Project project, boolean canBeParent, @NotNull IdeModalityType ideModalityType) {
        return DialogWrapperPeerFactory.getInstance().createPeer(this, project, canBeParent, ideModalityType);
    }

    @NotNull
    protected DialogWrapperPeer createPeer(@Nullable Project project, boolean canBeParent) {
        return DialogWrapperPeerFactory.getInstance().createPeer(this, project, canBeParent);
    }

    @Nullable
    protected JComponent createTitlePane() {
        return null;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return null;
    }

    @Nullable
    protected abstract JComponent createCenterPanel();

    public void toFront() {
        this.myPeer.toFront();
    }

    public void toBack() {
        this.myPeer.toBack();
    }

    protected boolean setAutoAdjustable(boolean autoAdjustable) {
        JRootPane rootPane = this.getRootPane();
        if (rootPane == null) {
            return false;
        }
        rootPane.putClientProperty(NO_AUTORESIZE, autoAdjustable ? null : Boolean.TRUE);
        return true;
    }

    public boolean isAutoAdjustable() {
        JRootPane rootPane = this.getRootPane();
        return rootPane == null || rootPane.getClientProperty(NO_AUTORESIZE) == null;
    }

    protected void dispose() {
        DialogWrapper.ensureEventDispatchThread();
        this.myErrorTextAlarm.cancelAllRequests();
        this.myValidationAlarm.cancelAllRequests();
        this.myDisposed = true;
        for (JButton button : this.myButtonMap.values()) {
            button.setAction(null);
        }
        this.myButtonMap.clear();
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            DialogWrapper.unregisterKeyboardActions(rootPane);
            if (this.myActualSize != null && this.isAutoAdjustable()) {
                this.setSize(this.myActualSize.width, this.myActualSize.height);
            }
            this.myPeer.dispose();
        }
    }

    public static void cleanupRootPane(@Nullable JRootPane rootPane) {
        if (rootPane == null) {
            return;
        }
        RepaintManager.currentManager(rootPane).removeInvalidComponent(rootPane);
        DialogWrapper.unregisterKeyboardActions(rootPane);
        Container contentPane = rootPane.getContentPane();
        if (contentPane != null) {
            contentPane.removeAll();
        }
        Disposer.clearOwnFields((Object)rootPane, field -> {
            String clazz = field.getDeclaringClass().getName();
            if (!clazz.startsWith("java.") && !clazz.startsWith("javax.")) {
                return true;
            }
            String name = field.getName();
            return "clientProperties".equals(name);
        });
    }

    public static void unregisterKeyboardActions(@Nullable Component rootPane) {
        int[] flags = new int[]{0, 1, 2};
        for (JComponent eachComp : UIUtil.uiTraverser((Component)rootPane).traverse().filter(JComponent.class)) {
            ActionMap actionMap = eachComp.getActionMap();
            if (actionMap == null) continue;
            for (KeyStroke eachStroke : eachComp.getRegisteredKeyStrokes()) {
                boolean remove = true;
                for (int i : flags) {
                    Action action;
                    Object key = eachComp.getInputMap(i).get(eachStroke);
                    Action action2 = action = key == null ? null : actionMap.get(key);
                    if (!(action instanceof UIResource)) continue;
                    remove = false;
                }
                if (!remove) continue;
                eachComp.unregisterKeyboardAction(eachStroke);
            }
        }
    }

    public static void cleanupWindowListeners(@Nullable Window window) {
        if (window == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            for (WindowListener listener : window.getWindowListeners()) {
                if (!listener.getClass().getName().startsWith("com.intellij.")) continue;
                window.removeWindowListener(listener);
            }
        });
    }

    public void doCancelAction() {
        if (this.getCancelAction().isEnabled()) {
            this.close(1);
        }
    }

    private void processDoNotAskOnCancel() {
        if (this.myDoNotAsk != null && this.myDoNotAsk.shouldSaveOptionsOnCancel() && this.myDoNotAsk.canBeHidden()) {
            this.myDoNotAsk.setToBeShown(this.toBeShown(), 1);
        }
    }

    public void doCancelAction(AWTEvent source) {
        this.recordAction("DialogCancelAction", source);
        this.doCancelAction();
    }

    public void clickDefaultButton() {
        JButton button = this.getRootPane().getDefaultButton();
        if (button != null) {
            button.doClick();
        }
    }

    protected void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            this.close(0);
        }
    }

    protected void processDoNotAskOnOk(int exitCode) {
        if (this.myDoNotAsk != null && this.myDoNotAsk.canBeHidden()) {
            this.myDoNotAsk.setToBeShown(this.toBeShown(), exitCode);
        }
    }

    public boolean shouldCloseOnCross() {
        return this.myCrossClosesWindow;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray;
        Action helpAction = this.getHelpAction();
        if (helpAction == this.myHelpAction && this.getHelpId() == null) {
            Action[] actionArray2 = new Action[2];
            actionArray2[0] = this.getOKAction();
            actionArray = actionArray2;
            actionArray2[1] = this.getCancelAction();
        } else {
            Action[] actionArray3 = new Action[3];
            actionArray3[0] = this.getOKAction();
            actionArray3[1] = this.getCancelAction();
            actionArray = actionArray3;
            actionArray3[2] = helpAction;
        }
        return actionArray;
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        return new Action[0];
    }

    @NotNull
    protected Action getOKAction() {
        return this.myOKAction;
    }

    @NotNull
    protected Action getCancelAction() {
        return this.myCancelAction;
    }

    @NotNull
    protected Action getHelpAction() {
        return this.myHelpAction;
    }

    protected boolean isProgressDialog() {
        return false;
    }

    public final boolean isModalProgress() {
        return this.isProgressDialog();
    }

    public Container getContentPane() {
        return this.myPeer.getContentPane();
    }

    public void validate() {
        this.myPeer.validate();
    }

    public void repaint() {
        this.myPeer.repaint();
    }

    @Nullable
    @NonNls
    protected String getDimensionServiceKey() {
        return null;
    }

    @Nullable
    public final String getDimensionKey() {
        return this.getDimensionServiceKey();
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return SystemInfo.isMac ? this.myPreferredFocusedComponent : null;
    }

    public final float getHorizontalStretch() {
        return this.myHorizontalStretch;
    }

    public final float getVerticalStretch() {
        return this.myVerticalStretch;
    }

    protected final void setHorizontalStretch(float hStretch) {
        this.myHorizontalStretch = hStretch;
    }

    protected final void setVerticalStretch(float vStretch) {
        this.myVerticalStretch = vStretch;
    }

    public Window getOwner() {
        return this.myPeer.getOwner();
    }

    public Window getWindow() {
        return this.myPeer.getWindow();
    }

    public JComponent getContentPanel() {
        return (JComponent)this.myPeer.getContentPane();
    }

    public JRootPane getRootPane() {
        return this.myPeer.getRootPane();
    }

    public Dimension getSize() {
        return this.myPeer.getSize();
    }

    public String getTitle() {
        return this.myPeer.getTitle();
    }

    protected void init() {
        boolean isVisualPaddingCompensatedOnComponentLevel;
        JComponent centerPanel;
        DialogWrapper.ensureEventDispatchThread();
        this.myErrorText = new ErrorText(this.getErrorTextAlignment());
        this.myErrorText.setVisible(false);
        final ComponentAdapter resizeListener = new ComponentAdapter(){
            private int myHeight;

            @Override
            public void componentResized(ComponentEvent event) {
                int height;
                int n = height = !DialogWrapper.this.myErrorText.isVisible() ? 0 : event.getComponent().getHeight();
                if (height != this.myHeight) {
                    this.myHeight = height;
                    DialogWrapper.this.myResizeInProgress = true;
                    DialogWrapper.this.myErrorText.setMinimumSize(new Dimension(0, height));
                    JRootPane root = DialogWrapper.this.myPeer.getRootPane();
                    if (root != null) {
                        root.validate();
                    }
                    if (DialogWrapper.this.myActualSize != null && !DialogWrapper.this.shouldAddErrorNearButtons()) {
                        DialogWrapper.this.myPeer.setSize(((DialogWrapper)DialogWrapper.this).myActualSize.width, ((DialogWrapper)DialogWrapper.this).myActualSize.height + height);
                    }
                    DialogWrapper.this.myErrorText.revalidate();
                    DialogWrapper.this.myResizeInProgress = false;
                }
            }
        };
        this.myErrorText.myLabel.addComponentListener(resizeListener);
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                DialogWrapper.this.myErrorText.myLabel.removeComponentListener(resizeListener);
            }
        });
        JPanel root = new JPanel(this.createRootLayout());
        this.myPeer.setContentPane(root);
        CustomShortcutSet sc = new CustomShortcutSet(SHOW_OPTION_KEYSTROKE);
        DumbAwareAction toggleShowOptions = DumbAwareAction.create((Consumer<? super AnActionEvent>)((Consumer)e -> this.expandNextOptionButton()));
        toggleShowOptions.registerCustomShortcutSet(sc, root, this.myDisposable);
        JComponent titlePane = this.createTitlePane();
        if (titlePane != null) {
            JPanel northSection = new JPanel(new BorderLayout());
            root.add((Component)northSection, "North");
            northSection.add((Component)titlePane, "Center");
        }
        JPanel centerSection = new JPanel(new BorderLayout());
        root.add((Component)centerSection, "Center");
        JComponent n = this.createNorthPanel();
        if (n != null) {
            centerSection.add((Component)n, "North");
        }
        if ((centerPanel = this.createCenterPanel()) != null) {
            centerSection.add((Component)centerPanel, "Center");
        }
        boolean bl = isVisualPaddingCompensatedOnComponentLevel = centerPanel == null || centerPanel.getClientProperty("isVisualPaddingCompensatedOnComponentLevel") == null;
        if (isVisualPaddingCompensatedOnComponentLevel) {
            root.setBorder(this.createContentPaneBorder());
        }
        if (this.myCreateSouthSection) {
            JPanel southSection = new JPanel(new BorderLayout());
            if (!isVisualPaddingCompensatedOnComponentLevel) {
                southSection.setBorder((Border)JBUI.Borders.empty((int)0, (int)12, (int)8, (int)12));
            }
            root.add((Component)southSection, "South");
            southSection.add((Component)this.myErrorText, "Center");
            JComponent south = this.createSouthPanel();
            if (south != null) {
                southSection.add((Component)south, "South");
            }
        }
        MnemonicHelper.init(root);
        if (!this.postponeValidation()) {
            this.startTrackingValidation();
        }
        if (SystemInfo.isWindows) {
            DialogWrapper.installEnterHook(root, this.myDisposable);
        }
        this.myErrorTextAlarm.setActivationComponent(root);
    }

    protected int getErrorTextAlignment() {
        return 10;
    }

    @NotNull
    protected LayoutManager createRootLayout() {
        return new BorderLayout();
    }

    private static void installEnterHook(JComponent root, Disposable disposable) {
        new DumbAwareAction(){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (owner instanceof JButton && owner.isEnabled()) {
                    ((JButton)owner).doClick();
                }
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                e.getPresentation().setEnabled(owner instanceof JButton && owner.isEnabled());
            }
        }.registerCustomShortcutSet(CustomShortcutSet.fromString("ENTER"), root, disposable);
    }

    private void expandNextOptionButton() {
        if (this.myCurrentOptionsButtonIndex >= 0) {
            this.myOptionsButtons.get(this.myCurrentOptionsButtonIndex).closePopup();
        }
        this.myCurrentOptionsButtonIndex = DialogWrapper.getEnabledIndexCyclic(this.myOptionsButtons, this.myCurrentOptionsButtonIndex, true).orElse(-1);
        if (this.myCurrentOptionsButtonIndex >= 0) {
            this.myOptionsButtons.get(this.myCurrentOptionsButtonIndex).showPopup(null, true);
        }
    }

    protected void startTrackingValidation() {
        SwingUtilities.invokeLater(() -> {
            if (!this.myValidationStarted && !this.myDisposed) {
                this.myValidationStarted = true;
                this.initValidation();
            }
        });
    }

    protected final void initValidation() {
        this.myValidationAlarm.cancelAllRequests();
        Runnable validateRequest = () -> {
            if (this.myDisposed) {
                return;
            }
            List<ValidationInfo> result2 = this.doValidateAll();
            if (!result2.isEmpty()) {
                this.installErrorPainter();
            }
            this.myErrorPainter.setValidationInfo(result2);
            this.updateErrorInfo(result2);
            if (!this.myDisposed) {
                this.initValidation();
            }
        };
        if (this.getValidationThreadToUse() == Alarm.ThreadToUse.SWING_THREAD) {
            JRootPane rootPane = this.getRootPane();
            this.myValidationAlarm.addRequest(validateRequest, this.myValidationDelay, ApplicationManager.getApplication() == null ? null : (rootPane == null ? ModalityState.current() : ModalityState.stateForComponent(rootPane)));
        } else {
            this.myValidationAlarm.addRequest(validateRequest, this.myValidationDelay);
        }
    }

    @Deprecated
    protected boolean isNorthStrictedToPreferredSize() {
        return true;
    }

    @Deprecated
    protected boolean isCenterStrictedToPreferredSize() {
        return false;
    }

    @Deprecated
    protected boolean isSouthStrictedToPreferredSize() {
        return true;
    }

    @NotNull
    protected JComponent createContentPane() {
        return new JPanel();
    }

    public void pack() {
        this.myPeer.pack();
    }

    public Dimension getPreferredSize() {
        return this.myPeer.getPreferredSize();
    }

    protected final void setButtonsAlignment(int alignment) {
        if (0 != alignment && 4 != alignment) {
            throw new IllegalArgumentException("unknown alignment: " + alignment);
        }
        this.myButtonAlignment = alignment;
    }

    @Deprecated
    public final void setButtonsMargin(@Nullable Insets insets) {
    }

    public final void setCrossClosesWindow(boolean crossClosesWindow) {
        this.myCrossClosesWindow = crossClosesWindow;
    }

    protected final void setCancelButtonIcon(Icon icon) {
        if (!SystemInfo.isMac) {
            this.myCancelAction.putValue("SmallIcon", icon);
        }
    }

    protected final void setCancelButtonText(String text) {
        this.myCancelAction.putValue("Name", text);
    }

    public void setModal(boolean modal) {
        this.myPeer.setModal(modal);
    }

    public boolean isModal() {
        return this.myPeer.isModal();
    }

    public boolean isOKActionEnabled() {
        return this.myOKAction.isEnabled();
    }

    public void setOKActionEnabled(boolean isEnabled) {
        this.myOKAction.setEnabled(isEnabled);
    }

    protected final void setOKButtonIcon(Icon icon) {
        if (!SystemInfo.isMac) {
            this.myOKAction.putValue("SmallIcon", icon);
        }
    }

    protected final void setOKButtonText(String text) {
        this.myOKAction.putValue("Name", text);
    }

    protected final void setOKButtonMnemonic(int c) {
        this.myOKAction.putValue("MnemonicKey", c);
    }

    protected final void setOKButtonTooltip(String text) {
        this.myOKAction.putValue("ShortDescription", text);
    }

    @Nullable
    protected String getHelpId() {
        return null;
    }

    protected void doHelpAction() {
        if (this.myHelpAction.isEnabled()) {
            String helpId = this.getHelpId();
            if (helpId != null) {
                HelpManager.getInstance().invokeHelp(helpId);
            } else {
                LOG.error("null topic; dialog=" + this.getClass() + "; action=" + this.getHelpAction().getClass());
            }
        }
    }

    public boolean isOK() {
        return this.getExitCode() == 0;
    }

    public boolean isVisible() {
        return this.myPeer.isVisible();
    }

    public boolean isShowing() {
        return this.myPeer.isShowing();
    }

    public void setSize(int width, int height) {
        this.myPeer.setSize(width, height);
    }

    public void setTitle(@Nls(capitalization=Nls.Capitalization.Title) String title) {
        this.myPeer.setTitle(title);
    }

    public void isResizable() {
        this.myPeer.isResizable();
    }

    public void setResizable(boolean resizable) {
        this.myPeer.setResizable(resizable);
    }

    @NotNull
    public Point getLocation() {
        return this.myPeer.getLocation();
    }

    public void setLocation(@NotNull Point p) {
        this.myPeer.setLocation(p);
    }

    public void setLocation(int x, int y) {
        this.myPeer.setLocation(x, y);
    }

    public void centerRelativeToParent() {
        this.myPeer.centerInParent();
    }

    public void show() {
        this.logShowDialogEvent();
        this.invokeShow();
    }

    public boolean showAndGet() {
        if (!this.isModal()) {
            throw new IllegalStateException("The showAndGet() method is for modal dialogs only");
        }
        this.show();
        return this.isOK();
    }

    @NotNull
    public AsyncResult<Boolean> showAndGetOk() {
        if (this.isModal()) {
            throw new IllegalStateException("The showAndGetOk() method is for modeless dialogs only");
        }
        return this.invokeShow();
    }

    @NotNull
    private AsyncResult<Boolean> invokeShow() {
        final AsyncResult<Boolean> result2 = new AsyncResult<Boolean>();
        DialogWrapper.ensureEventDispatchThread();
        this.registerKeyboardShortcuts();
        Disposable uiParent = Disposer.get((String)"ui");
        if (uiParent != null) {
            Disposer.register((Disposable)uiParent, (Disposable)this.myDisposable);
        }
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                result2.setDone(DialogWrapper.this.isOK());
            }
        });
        this.myPeer.show();
        return result2;
    }

    @Nullable
    public Point getInitialLocation() {
        return this.myInitialLocationCallback == null ? null : (Point)this.myInitialLocationCallback.compute();
    }

    public void setInitialLocationCallback(@NotNull Computable<Point> callback) {
        this.myInitialLocationCallback = callback;
    }

    private void registerKeyboardShortcuts() {
        JRootPane rootPane = this.getRootPane();
        if (rootPane == null) {
            return;
        }
        ActionListener cancelKeyboardAction = this.createCancelAction();
        if (cancelKeyboardAction != null) {
            rootPane.registerKeyboardAction(cancelKeyboardAction, KeyStroke.getKeyStroke(27, 0), 2);
            ActionUtil.registerForEveryKeyboardShortcut(this.getRootPane(), cancelKeyboardAction, CommonShortcuts.getCloseActiveWindow());
        }
        if (!DialogWrapper.isRemoveHelpButton() && !this.isProgressDialog()) {
            ActionListener helpAction = e -> this.doHelpAction();
            ActionUtil.registerForEveryKeyboardShortcut(this.getRootPane(), helpAction, CommonShortcuts.getContextHelp());
            rootPane.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(156, 0), 2);
        }
        rootPane.registerKeyboardAction(e -> this.focusButton(false), KeyStroke.getKeyStroke(37, 0), 1);
        rootPane.registerKeyboardAction(e -> this.focusButton(true), KeyStroke.getKeyStroke(39, 0), 1);
        if (this.myYesAction != null) {
            rootPane.registerKeyboardAction(this.myYesAction, KeyStroke.getKeyStroke(89, 0), 2);
        }
        if (this.myNoAction != null) {
            rootPane.registerKeyboardAction(this.myNoAction, KeyStroke.getKeyStroke(78, 0), 2);
        }
    }

    @Nullable
    protected ActionListener createCancelAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PopupUtil.handleEscKeyEvent()) {
                    DialogWrapper.this.doCancelAction(e);
                }
            }
        };
    }

    private void focusButton(boolean next) {
        ArrayList buttons = ContainerUtil.newArrayList(this.myButtonMap.values());
        int focusedIndex = ContainerUtil.indexOf((List)buttons, Component::hasFocus);
        if (focusedIndex >= 0) {
            DialogWrapper.getEnabledIndexCyclic(buttons, focusedIndex, next).ifPresent(i -> ((JButton)buttons.get(i)).requestFocus());
        }
    }

    @NotNull
    private static OptionalInt getEnabledIndexCyclic(@NotNull List<? extends Component> components, int currentIndex, boolean next) {
        assert (-1 <= currentIndex && currentIndex <= components.size());
        int start = !next && currentIndex == -1 ? components.size() : currentIndex;
        return IntStream.range(0, components.size()).map(i -> (next ? start + i + 1 : start + components.size() - i - 1) % components.size()).filter(i -> ((Component)components.get(i)).isEnabled()).findFirst();
    }

    public long getTypeAheadTimeoutMs() {
        return 0L;
    }

    public boolean isToDispatchTypeAhead() {
        return this.isOK();
    }

    public static boolean isMultipleModalDialogs() {
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (c != null) {
            DialogWrapper wrapper = DialogWrapper.findInstance(c);
            return wrapper != null && wrapper.getPeer().getCurrentModalEntities().length > 1;
        }
        return false;
    }

    private void logCloseDialogEvent(int exitCode) {
        String dialogId;
        boolean canRecord = this.canRecordDialogId();
        if (canRecord && StringUtil.isNotEmpty((String)(dialogId = this.getClass().getName()))) {
            FeatureUsageUiEventsKt.getUiEventLogger().logCloseDialog(dialogId, exitCode, this.getClass());
        }
    }

    private void logShowDialogEvent() {
        String dialogId;
        boolean canRecord = this.canRecordDialogId();
        if (canRecord && StringUtil.isNotEmpty((String)(dialogId = this.getClass().getName()))) {
            FeatureUsageUiEventsKt.getUiEventLogger().logShowDialog(dialogId, this.getClass());
        }
    }

    protected boolean canRecordDialogId() {
        return true;
    }

    private void recordAction(String name) {
        this.recordAction(name, EventQueue.getCurrentEvent());
    }

    private void recordAction(String name, AWTEvent event) {
        if (event instanceof KeyEvent && ApplicationManager.getApplication() != null) {
            ActionsCollector.getInstance().record(name, (KeyEvent)event, this.getClass());
        }
    }

    protected void setErrorText(@Nullable String text) {
        this.setErrorText(text, null);
    }

    protected void setErrorText(@Nullable String text, @Nullable JComponent component) {
        this.setErrorInfoAll(text == null ? Collections.EMPTY_LIST : Collections.singletonList(new ValidationInfo(text, component)));
    }

    protected void setErrorInfoAll(@NotNull List<ValidationInfo> info) {
        if (this.myInfo.equals(info)) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        boolean headless = application != null && application.isHeadlessEnvironment();
        this.myErrorTextAlarm.cancelAllRequests();
        Runnable clearErrorRunnable = () -> {
            if (this.myErrorText != null) {
                this.myErrorText.clearError();
            }
        };
        if (headless) {
            clearErrorRunnable.run();
        } else {
            SwingUtilities.invokeLater(clearErrorRunnable);
        }
        List corrected = ContainerUtil.filter(this.myInfo, vi -> !info.contains(vi));
        if (Registry.is((String)"ide.inplace.validation.tooltip")) {
            corrected.stream().filter(vi -> vi.component != null).map(vi -> ComponentValidator.getInstance(vi.component)).forEach(c -> c.ifPresent(vi -> vi.updateInfo(null)));
        }
        this.myInfo = info;
        if (Registry.is((String)"ide.inplace.validation.tooltip") && !this.myInfo.isEmpty()) {
            this.myInfo.forEach(vi -> {
                ComponentValidator v;
                if (vi.component != null && (v = ComponentValidator.getInstance(vi.component).orElseGet(() -> new ComponentValidator(this.getDisposable()).installOn(vi.component))) != null) {
                    v.updateInfo((ValidationInfo)vi);
                    return;
                }
                SwingUtilities.invokeLater(() -> this.myErrorText.appendError(vi.message));
            });
        } else if (!this.myInfo.isEmpty()) {
            Runnable updateErrorTextRunnable = () -> {
                for (ValidationInfo vi : this.myInfo) {
                    this.myErrorText.appendError(vi.message);
                }
            };
            if (headless) {
                updateErrorTextRunnable.run();
            } else {
                this.myErrorTextAlarm.addRequest(updateErrorTextRunnable, 300, (ModalityState)null);
            }
        }
    }

    protected boolean hasErrors(@NotNull JComponent component) {
        return this.myInfo.stream().anyMatch(i -> component.equals(i.component) && !i.warning);
    }

    private void updateSize() {
        if (this.myActualSize == null && !this.myErrorText.isVisible()) {
            this.myActualSize = this.getSize();
        }
    }

    @Nullable
    public static DialogWrapper findInstance(Component c) {
        while (c != null) {
            if (c instanceof DialogWrapperDialog) {
                return ((DialogWrapperDialog)((Object)c)).getDialogWrapper();
            }
            c = c.getParent();
        }
        return null;
    }

    @Nullable
    public static DialogWrapper findInstanceFromFocus() {
        return DialogWrapper.findInstance(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
    }

    private void resizeWithAnimation(final @NotNull Dimension size) {
        this.myResizeInProgress = true;
        if (!Registry.is((String)"enable.animation.on.dialogs")) {
            this.setSize(size.width, size.height);
            this.myResizeInProgress = false;
            return;
        }
        new Thread("DialogWrapper resizer"){
            static final int time = 200;
            static final int steps = 7;

            @Override
            public void run() {
                int step = 0;
                Dimension cur = DialogWrapper.this.getSize();
                int h = (size.height - cur.height) / 7;
                int w = (size.width - cur.width) / 7;
                while (step++ < 7) {
                    DialogWrapper.this.setSize(cur.width + w * step, cur.height + h * step);
                    TimeoutUtil.sleep((long)28L);
                }
                DialogWrapper.this.setSize(size.width, size.height);
                if (DialogWrapper.this.myErrorText.shouldBeVisible()) {
                    DialogWrapper.this.myErrorText.setVisible(true);
                }
                DialogWrapper.this.myResizeInProgress = false;
            }
        }.start();
    }

    @NotNull
    public final DialogWrapperPeer getPeer() {
        return this.myPeer;
    }

    private static void ensureEventDispatchThread() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("The DialogWrapper can only be used in event dispatch thread. Current thread: " + Thread.currentThread());
        }
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.myDisposable;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @NotNull
    private ErrorPaintingType getErrorPaintingType() {
        return ErrorPaintingType.SIGN;
    }

    public static enum DialogStyle {
        NO_STYLE,
        COMPACT;

    }

    private static enum ErrorPaintingType {
        DOT,
        SIGN,
        LINE;

    }

    private class ErrorPainter
    extends AbstractPainter {
        private List<ValidationInfo> info;

        private ErrorPainter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executePaint(Component component, Graphics2D g) {
            block8: for (ValidationInfo i : this.info) {
                if (i.component == null || Registry.is((String)"ide.inplace.errors.outline")) continue;
                int w = i.component.getWidth();
                int h = i.component.getHeight();
                switch (DialogWrapper.this.getErrorPaintingType()) {
                    case DOT: {
                        Point p = SwingUtilities.convertPoint(i.component, 2, h / 2, component);
                        AllIcons.Ide.ErrorPoint.paintIcon(component, g, p.x, p.y);
                        break;
                    }
                    case SIGN: {
                        Point p = SwingUtilities.convertPoint(i.component, w, 0, component);
                        AllIcons.General.Error.paintIcon(component, g, p.x - 8, p.y - 8);
                        break;
                    }
                    case LINE: {
                        Point p = SwingUtilities.convertPoint(i.component, 0, h, component);
                        Graphics g2 = g.create();
                        try {
                            g2.setColor(new Color(255, 0, 0, 100));
                            g2.fillRoundRect(p.x, p.y - 2, w, 4, 2, 2);
                            continue block8;
                        }
                        finally {
                            g2.dispose();
                            continue block8;
                        }
                    }
                }
            }
        }

        @Override
        public boolean needsRepaint() {
            return true;
        }

        private void setValidationInfo(@NotNull List<ValidationInfo> info) {
            this.info = info;
        }
    }

    public static interface DoNotAskOption {
        public boolean isToBeShown();

        public void setToBeShown(boolean var1, int var2);

        public boolean canBeHidden();

        public boolean shouldSaveOptionsOnCancel();

        @NotNull
        public String getDoNotShowMessage();

        public static abstract class Adapter
        implements DoNotAskOption {
            public abstract void rememberChoice(boolean var1, int var2);

            public boolean isSelectedByDefault() {
                return false;
            }

            @Override
            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @Override
            @NotNull
            public String getDoNotShowMessage() {
                return CommonBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]);
            }

            @Override
            public final boolean isToBeShown() {
                return !this.isSelectedByDefault();
            }

            @Override
            public final void setToBeShown(boolean toBeShown, int exitCode) {
                this.rememberChoice(!toBeShown, exitCode);
            }

            @Override
            public final boolean canBeHidden() {
                return true;
            }
        }
    }

    private class ErrorText
    extends JPanel {
        private final JLabel myLabel = new JLabel();
        private final List<String> errors = new ArrayList<String>();

        private ErrorText(int horizontalAlignment) {
            this.setLayout(new BorderLayout());
            this.myLabel.setBorder(this.createErrorTextBorder());
            this.myLabel.setHorizontalAlignment(horizontalAlignment);
            JBScrollPane pane = new JBScrollPane(this.myLabel, 21, 31);
            pane.setBorder((Border)JBUI.Borders.empty());
            pane.setBackground(null);
            pane.getViewport().setBackground(null);
            pane.setOpaque(false);
            this.add((Component)pane, "Center");
        }

        private Border createErrorTextBorder() {
            Border border = DialogWrapper.this.createContentPaneBorder();
            JBInsets contentInsets = border != null ? border.getBorderInsets(null) : JBUI.emptyInsets();
            JBInsets baseInsets = JBUI.insets((int)16, (int)13);
            return new EmptyBorder(baseInsets.top, baseInsets.left > contentInsets.left ? baseInsets.left - contentInsets.left : 0, baseInsets.bottom > contentInsets.bottom ? baseInsets.bottom - contentInsets.bottom : 0, baseInsets.right > contentInsets.right ? baseInsets.right - contentInsets.right : 0);
        }

        private void clearError() {
            this.errors.clear();
            this.myLabel.setBounds(0, 0, 0, 0);
            this.myLabel.setText("");
            this.setVisible(false);
            DialogWrapper.this.updateSize();
        }

        private void appendError(String text) {
            this.errors.add(text);
            this.myLabel.setBounds(0, 0, 0, 0);
            StringBuilder sb = new StringBuilder("<html><font color='#" + ColorUtil.toHex((Color)ERROR_FOREGROUND_COLOR) + "'>");
            this.errors.forEach(error -> sb.append("<left>").append((String)error).append("</left><br/>"));
            sb.append("</font></html>");
            this.myLabel.setText(sb.toString());
            this.setVisible(true);
            DialogWrapper.this.updateSize();
        }

        private boolean shouldBeVisible() {
            return !this.errors.isEmpty();
        }

        private boolean isTextSet(@NotNull List<ValidationInfo> info) {
            if (info.isEmpty()) {
                return this.errors.isEmpty();
            }
            if (this.errors.size() == info.size()) {
                return this.errors.equals(info.stream().map(i -> i.message).collect(Collectors.toList()));
            }
            return false;
        }
    }

    private class HelpAction
    extends AbstractAction {
        private HelpAction() {
            super(CommonBundle.getHelpButtonText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogWrapper.this.doHelpAction();
        }
    }

    protected class DialogWrapperExitAction
    extends DialogWrapperAction {
        protected final int myExitCode;

        public DialogWrapperExitAction(String name, int exitCode) {
            super(name);
            this.myExitCode = exitCode;
        }

        @Override
        protected void doAction(ActionEvent e) {
            if (this.isEnabled()) {
                DialogWrapper.this.close(this.myExitCode);
            }
        }
    }

    protected class CancelAction
    extends DialogWrapperAction {
        private CancelAction() {
            super(CommonBundle.getCancelButtonText());
        }

        @Override
        protected void doAction(ActionEvent e) {
            DialogWrapper.this.doCancelAction();
        }
    }

    protected class OkAction
    extends DialogWrapperAction {
        protected OkAction() {
            super(CommonBundle.getOkButtonText());
            this.putValue(DialogWrapper.DEFAULT_ACTION, Boolean.TRUE);
        }

        @Override
        protected void doAction(ActionEvent e) {
            DialogWrapper.this.recordAction("DialogOkAction");
            List<ValidationInfo> infoList = DialogWrapper.this.doValidateAll();
            if (!infoList.isEmpty()) {
                ValidationInfo info = infoList.get(0);
                if (info.component != null && info.component.isVisible()) {
                    IdeFocusManager.getInstance(null).requestFocus(info.component, true);
                }
                if (!Registry.is((String)"ide.inplace.validation.tooltip")) {
                    DialogEarthquakeShaker.shake(DialogWrapper.this.getPeer().getWindow());
                }
                DialogWrapper.this.startTrackingValidation();
                if (infoList.stream().anyMatch(info1 -> !info1.okEnabled)) {
                    return;
                }
            }
            DialogWrapper.this.doOKAction();
        }
    }

    protected abstract class DialogWrapperAction
    extends AbstractAction {
        protected DialogWrapperAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DialogWrapper.this.myClosed) {
                return;
            }
            if (DialogWrapper.this.myPerformAction) {
                return;
            }
            try {
                DialogWrapper.this.myPerformAction = true;
                this.doAction(e);
            }
            finally {
                DialogWrapper.this.myPerformAction = false;
            }
        }

        protected abstract void doAction(ActionEvent var1);
    }

    public static enum IdeModalityType {
        IDE,
        PROJECT,
        MODELESS;


        @NotNull
        public Dialog.ModalityType toAwtModality() {
            switch (this) {
                case IDE: {
                    return Dialog.ModalityType.APPLICATION_MODAL;
                }
                case PROJECT: {
                    return Dialog.ModalityType.DOCUMENT_MODAL;
                }
                case MODELESS: {
                    return Dialog.ModalityType.MODELESS;
                }
            }
            throw new IllegalStateException(this.toString());
        }
    }
}

