/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.TestDialog;
import com.intellij.openapi.ui.TestInputDialog;
import com.intellij.openapi.ui.messages.MessageDialog;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.MessageException;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.mac.MacMessages;
import com.intellij.util.Function;
import com.intellij.util.PairFunction;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Messages {
    public static final int OK = 0;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    public static final String OK_BUTTON = CommonBundle.getOkButtonText();
    public static final String YES_BUTTON = CommonBundle.getYesButtonText();
    public static final String NO_BUTTON = CommonBundle.getNoButtonText();
    public static final String CANCEL_BUTTON = CommonBundle.getCancelButtonText();
    private static TestDialog ourTestImplementation = TestDialog.DEFAULT;
    private static TestInputDialog ourTestInputImplementation = TestInputDialog.DEFAULT;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.ui.Messages");

    public static TestDialog setTestDialog(TestDialog newValue) {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            LOG.assertTrue(application.isUnitTestMode(), (Object)"This method is available for tests only");
        }
        if (newValue == null) {
            ourTestImplementation = TestDialog.DEFAULT;
            throw new IllegalArgumentException("Attempt to set TestDialog to null: default implementation was restored instead");
        }
        TestDialog oldValue = ourTestImplementation;
        ourTestImplementation = newValue;
        return oldValue;
    }

    public static TestInputDialog setTestInputDialog(TestInputDialog newValue) {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            LOG.assertTrue(application.isUnitTestMode(), (Object)"This method is available for tests only");
        }
        if (newValue == null) {
            ourTestInputImplementation = TestInputDialog.DEFAULT;
            throw new IllegalArgumentException("Attempt to set TestInputDialog to null: default implementation was restored instead");
        }
        TestInputDialog oldValue = ourTestInputImplementation;
        ourTestInputImplementation = newValue;
        return oldValue;
    }

    public static TestDialog getTestImplementation() {
        return ourTestImplementation;
    }

    public static TestInputDialog getTestInputImplementation() {
        return ourTestInputImplementation;
    }

    @NotNull
    public static Icon getErrorIcon() {
        return UIUtil.getErrorIcon();
    }

    @NotNull
    public static Icon getInformationIcon() {
        return UIUtil.getInformationIcon();
    }

    @NotNull
    public static Icon getWarningIcon() {
        return UIUtil.getWarningIcon();
    }

    @NotNull
    public static Icon getQuestionIcon() {
        return UIUtil.getQuestionIcon();
    }

    public static void installHyperlinkSupport(JTextPane messageComponent) {
        Messages.configureMessagePaneUi(messageComponent, "<html></html>");
    }

    @NotNull
    public static JComponent wrapToScrollPaneIfNeeded(@NotNull JComponent comp, int columns, int lines) {
        float fontSize = comp.getFont().getSize2D();
        Dimension maxDim = new Dimension((int)(fontSize * (float)columns), (int)(fontSize * (float)lines));
        Dimension prefDim = comp.getPreferredSize();
        if (prefDim.width <= maxDim.width && prefDim.height <= maxDim.height) {
            return comp;
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(comp);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        int barWidth = UIUtil.getScrollBarWidth();
        Dimension preferredSize = new Dimension(Math.min(prefDim.width, maxDim.width) + barWidth, Math.min(prefDim.height, maxDim.height) + barWidth);
        if (prefDim.width > maxDim.width) {
            preferredSize.height = Math.max(preferredSize.height, (int)(4.0f * fontSize) + barWidth);
        }
        scrollPane.setPreferredSize(preferredSize);
        return scrollPane;
    }

    @NotNull
    public static JTextPane configureMessagePaneUi(JTextPane messageComponent, String message) {
        JTextPane pane = Messages.configureMessagePaneUi(messageComponent, message, null);
        if ("text/html".equals(pane.getContentType())) {
            pane.addHyperlinkListener(BrowserHyperlinkListener.INSTANCE);
        }
        return pane;
    }

    @NotNull
    public static JTextPane configureMessagePaneUi(@NotNull JTextPane messageComponent, @Nullable String message, @Nullable UIUtil.FontSize fontSize) {
        UIUtil.FontSize fixedFontSize = fontSize == null ? UIUtil.FontSize.NORMAL : fontSize;
        messageComponent.setFont(UIUtil.getLabelFont((UIUtil.FontSize)fixedFontSize));
        if (BasicHTML.isHTMLString(message)) {
            messageComponent.setEditorKit(UIUtil.getHTMLEditorKit());
        }
        messageComponent.setText(message);
        messageComponent.setEditable(false);
        if (messageComponent.getCaret() != null) {
            messageComponent.setCaretPosition(0);
        }
        messageComponent.setBackground(UIUtil.getOptionPaneBackground());
        messageComponent.setForeground(UIUtil.getLabelForeground());
        return messageComponent;
    }

    public static int showDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon) {
        return Messages.showDialog(project, message, title, options, defaultOptionIndex, icon, null);
    }

    public static boolean isApplicationInUnitTestOrHeadless() {
        Application application = ApplicationManager.getApplication();
        return application != null && (application.isUnitTestMode() || application.isHeadlessEnvironment());
    }

    @NotNull
    public static Runnable createMessageDialogRemover(@Nullable Project project) {
        Window projectWindow = project == null ? null : WindowManager.getInstance().suggestParentWindow(project);
        return () -> SwingUtilities.invokeLater(() -> Messages.makeCurrentMessageDialogGoAway(projectWindow != null ? projectWindow.getOwnedWindows() : Window.getWindows()));
    }

    private static void makeCurrentMessageDialogGoAway(@NotNull Window[] checkWindows) {
        for (Window w : checkWindows) {
            JButton cancelButton;
            JDialog dialog;
            JDialog jDialog = dialog = w instanceof JDialog ? (JDialog)w : null;
            if (dialog == null || !dialog.isModal() || (cancelButton = (JButton)UIUtil.uiTraverser((Component)dialog.getRootPane()).filter(JButton.class).filter(b -> CommonBundle.getCancelButtonText().equals(b.getText())).first()) == null) continue;
            cancelButton.doClick();
        }
    }

    public static int showDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        return MessagesService.getInstance().showMessageDialog(project, null, message, title, options, defaultOptionIndex, -1, icon, doNotAskOption, false);
    }

    public static int showIdeaMessageDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        return MessagesService.getInstance().showMessageDialog(project, null, message, title, options, defaultOptionIndex, -1, icon, doNotAskOption, true);
    }

    public static boolean canShowMacSheetPanel() {
        return SystemInfo.isMac && ApplicationManager.getApplication() != null && !Messages.isApplicationInUnitTestOrHeadless() && Registry.is((String)"ide.mac.message.dialogs.as.sheets");
    }

    public static boolean isMacSheetEmulation() {
        return SystemInfo.isMac && Registry.is((String)"ide.mac.message.dialogs.as.sheets") && Registry.is((String)"ide.mac.message.sheets.java.emulation");
    }

    public static int showDialog(Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable String moreInfo, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, Icon icon) {
        return MessagesService.getInstance().showMoreInfoMessageDialog(project, message, title, moreInfo, options, defaultOptionIndex, focusedOptionIndex, icon);
    }

    public static int showDialog(@NotNull Component parent, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon) {
        return MessagesService.getInstance().showMessageDialog(null, parent, message, title, options, defaultOptionIndex, -1, icon, null, false);
    }

    public static int showDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        return MessagesService.getInstance().showMessageDialog(null, null, message, title, options, defaultOptionIndex, focusedOptionIndex, icon, doNotAskOption, false);
    }

    public static int showDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        return Messages.showDialog(message, title, options, defaultOptionIndex, defaultOptionIndex, icon, doNotAskOption);
    }

    public static int showDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon) {
        return Messages.showDialog(message, title, options, defaultOptionIndex, icon, null);
    }

    public static void showMessageDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON, WindowManager.getInstance().suggestParentWindow(project));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(project, message, title, new String[]{OK_BUTTON}, 0, icon);
    }

    public static void showMessageDialog(@NotNull Component parent, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON, SwingUtilities.getWindowAncestor(parent));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(parent, message, title, new String[]{OK_BUTTON}, 0, icon);
    }

    public static void showMessageDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON);
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(message, title, new String[]{OK_BUTTON}, 0, icon);
    }

    @YesNoResult
    public static int showYesNoDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yesText, @NotNull String noText, @Nullable Icon icon) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, yesText, noText, WindowManager.getInstance().suggestParentWindow(project));
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result2 = Messages.showDialog(project, message, title, new String[]{yesText, noText}, 0, icon) == 0 ? 0 : 1;
        LOG.assertTrue(result2 == 0 || result2 == 1, (Object)result2);
        return result2;
    }

    @YesNoResult
    public static int showYesNoDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yesText, @NotNull String noText, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, yesText, noText, WindowManager.getInstance().suggestParentWindow(project), doNotAskOption);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result2 = Messages.showDialog(project, message, title, new String[]{yesText, noText}, 0, icon, doNotAskOption) == 0 ? 0 : 1;
        LOG.assertTrue(result2 == 0 || result2 == 1, (Object)result2);
        return result2;
    }

    @YesNoResult
    public static int showYesNoDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, YES_BUTTON, NO_BUTTON, WindowManager.getInstance().suggestParentWindow(project));
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result2 = Messages.showYesNoDialog(project, message, title, YES_BUTTON, NO_BUTTON, icon);
        LOG.assertTrue(result2 == 0 || result2 == 1, (Object)result2);
        return result2;
    }

    @YesNoResult
    public static int showYesNoDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, YES_BUTTON, NO_BUTTON, WindowManager.getInstance().suggestParentWindow(project), doNotAskOption);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result2 = Messages.showYesNoDialog(project, message, title, YES_BUTTON, NO_BUTTON, icon, doNotAskOption);
        LOG.assertTrue(result2 == 0 || result2 == 1, (Object)result2);
        return result2;
    }

    @YesNoResult
    public static int showYesNoDialog(@NotNull Component parent, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, YES_BUTTON, NO_BUTTON, SwingUtilities.getWindowAncestor(parent));
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result2 = Messages.showDialog(parent, message, title, new String[]{YES_BUTTON, NO_BUTTON}, 0, icon) == 0 ? 0 : 1;
        LOG.assertTrue(result2 == 0 || result2 == 1, (Object)result2);
        return result2;
    }

    @YesNoResult
    public static int showYesNoDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yesText, @NotNull String noText, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, yesText, noText, null, doNotAskOption);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
        }
        int result2 = Messages.showDialog(message, title, new String[]{yesText, noText}, 0, icon, doNotAskOption) == 0 ? 0 : 1;
        LOG.assertTrue(result2 == 0 || result2 == 1, (Object)result2);
        return result2;
    }

    @YesNoResult
    public static int showYesNoDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String yesText, String noText, @Nullable Icon icon) {
        return Messages.showYesNoDialog(message, title, yesText, noText, icon, null);
    }

    @YesNoResult
    public static int showYesNoDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, YES_BUTTON, NO_BUTTON, null);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result2 = Messages.showYesNoDialog(message, title, YES_BUTTON, NO_BUTTON, icon);
        LOG.assertTrue(result2 == 0 || result2 == 1, (Object)result2);
        return result2;
    }

    @OkCancelResult
    public static int showOkCancelDialog(Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String okText, @NotNull String cancelText, Icon icon, DialogWrapper.DoNotAskOption doNotAskOption) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                int result2 = MacMessages.getInstance().showYesNoDialog(title, message, okText, cancelText, WindowManager.getInstance().suggestParentWindow(project), doNotAskOption);
                return result2 == 0 ? 0 : 2;
            }
        }
        catch (MessageException result2) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        return Messages.showDialog(project, message, title, new String[]{okText, cancelText}, 0, icon, doNotAskOption) == 0 ? 0 : 2;
    }

    @OkCancelResult
    public static int showOkCancelDialog(Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String okText, @NotNull String cancelText, Icon icon) {
        return Messages.showOkCancelDialog(project, message, title, okText, cancelText, icon, null);
    }

    @Deprecated
    @OkCancelResult
    public static int showOkCancelDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        return Messages.showOkCancelDialog(project, message, title, OK_BUTTON, CANCEL_BUTTON, icon);
    }

    @OkCancelResult
    public static int showOkCancelDialog(@NotNull Component parent, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String okText, @NotNull String cancelText, Icon icon) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                int result2 = MacMessages.getInstance().showYesNoDialog(title, message, okText, cancelText, SwingUtilities.getWindowAncestor(parent));
                return result2 == 0 ? 0 : 2;
            }
        }
        catch (MessageException result2) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        return Messages.showDialog(parent, message, title, new String[]{okText, cancelText}, 0, icon) == 0 ? 0 : 2;
    }

    @Deprecated
    @OkCancelResult
    public static int showOkCancelDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        return Messages.showOkCancelDialog(parent, message, title, OK_BUTTON, CANCEL_BUTTON, icon);
    }

    @Deprecated
    @OkCancelResult
    public static int showOkCancelDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        return Messages.showOkCancelDialog(message, title, OK_BUTTON, CANCEL_BUTTON, icon, null);
    }

    @OkCancelResult
    public static int showOkCancelDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String okText, String cancelText, Icon icon) {
        return Messages.showOkCancelDialog(message, title, okText, cancelText, icon, null);
    }

    @OkCancelResult
    public static int showOkCancelDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String okText, @NotNull String cancelText, Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                int result2 = MacMessages.getInstance().showYesNoDialog(title, message, okText, cancelText, null, doNotAskOption);
                return result2 == 0 ? 0 : 2;
            }
        }
        catch (MessageException result2) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        return Messages.showDialog(message, title, new String[]{okText, cancelText}, 0, icon, doNotAskOption) == 0 ? 0 : 2;
    }

    public static int showCheckboxOkCancelDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String checkboxText, boolean checked, int defaultOptionIndex, int focusedOptionIndex, Icon icon) {
        return Messages.showCheckboxMessageDialog(message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, checkboxText, checked, defaultOptionIndex, focusedOptionIndex, icon, (PairFunction<? super Integer, ? super JCheckBox, Integer>)((PairFunction)(exitCode, cb) -> exitCode == -1 ? 2 : exitCode + (cb.isSelected() ? 1 : 0)));
    }

    public static int showCheckboxMessageDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, String checkboxText, boolean checked, int defaultOptionIndex, int focusedOptionIndex, Icon icon, @Nullable PairFunction<? super Integer, ? super JCheckBox, Integer> exitFunc) {
        return MessagesService.getInstance().showTwoStepConfirmationDialog(message, title, options, checkboxText, checked, defaultOptionIndex, focusedOptionIndex, icon, exitFunc);
    }

    public static int showTwoStepConfirmationDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String checkboxText, Icon icon) {
        return Messages.showCheckboxMessageDialog(message, title, new String[]{OK_BUTTON}, checkboxText, true, -1, -1, icon, null);
    }

    public static void showErrorDialog(@Nullable Project project, @Nls String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, WindowManager.getInstance().suggestParentWindow(project));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(project, message, title, new String[]{OK_BUTTON}, 0, Messages.getErrorIcon());
    }

    public static void showErrorDialog(@NotNull Component component, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, SwingUtilities.getWindowAncestor(component));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(component, message, title, new String[]{OK_BUTTON}, 0, Messages.getErrorIcon());
    }

    public static void showErrorDialog(@NotNull Component component, String message) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(CommonBundle.getErrorTitle(), message, OK_BUTTON, SwingUtilities.getWindowAncestor(component));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(component, message, CommonBundle.getErrorTitle(), new String[]{OK_BUTTON}, 0, Messages.getErrorIcon());
    }

    public static void showErrorDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, null);
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(message, title, new String[]{OK_BUTTON}, 0, Messages.getErrorIcon());
    }

    public static void showWarningDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, WindowManager.getInstance().suggestParentWindow(project));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(project, message, title, new String[]{OK_BUTTON}, 0, Messages.getWarningIcon());
    }

    public static void showWarningDialog(@NotNull Component component, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, SwingUtilities.getWindowAncestor(component));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(component, message, title, new String[]{OK_BUTTON}, 0, Messages.getWarningIcon());
    }

    public static void showWarningDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, null);
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(message, title, new String[]{OK_BUTTON}, 0, Messages.getWarningIcon());
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yes, @NotNull String no, @NotNull String cancel, @Nullable Icon icon) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoCancelDialog(title, message, yes, no, cancel, WindowManager.getInstance().suggestParentWindow(project), null);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int buttonNumber = Messages.showDialog(project, message, title, new String[]{yes, no, cancel}, 0, icon);
        return buttonNumber == 0 ? 0 : (buttonNumber == 1 ? 1 : 2);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        return Messages.showYesNoCancelDialog(project, message, title, YES_BUTTON, NO_BUTTON, CANCEL_BUTTON, icon);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NotNull Component parent, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yes, @NotNull String no, @NotNull String cancel, Icon icon) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoCancelDialog(title, message, yes, no, cancel, SwingUtilities.getWindowAncestor(parent), null);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int buttonNumber = Messages.showDialog(parent, message, title, new String[]{yes, no, cancel}, 0, icon);
        return buttonNumber == 0 ? 0 : (buttonNumber == 1 ? 1 : 2);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        return Messages.showYesNoCancelDialog(parent, message, title, YES_BUTTON, NO_BUTTON, CANCEL_BUTTON, icon);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yes, @NotNull String no, @NotNull String cancel, Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoCancelDialog(title, message, yes, no, cancel, null, doNotAskOption);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int buttonNumber = Messages.showDialog(message, title, new String[]{yes, no, cancel}, 0, icon, doNotAskOption);
        return buttonNumber == 0 ? 0 : (buttonNumber == 1 ? 1 : 2);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String yes, String no, String cancel, Icon icon) {
        return Messages.showYesNoCancelDialog(message, title, yes, no, cancel, icon, null);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        return Messages.showYesNoCancelDialog(message, title, YES_BUTTON, NO_BUTTON, CANCEL_BUTTON, icon);
    }

    @Nullable
    public static String showPasswordDialog(@Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title) {
        return Messages.showPasswordDialog(null, message, title, null, null);
    }

    @Nullable
    public static String showPasswordDialog(Project project, @Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        return Messages.showPasswordDialog(project, message, title, icon, null);
    }

    @Nullable
    public static String showPasswordDialog(@Nullable Project project, @Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable InputValidator validator) {
        return MessagesService.getInstance().showPasswordDialog(project, message, title, icon, validator);
    }

    @Nullable
    public static String showInputDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        return Messages.showInputDialog(project, message, title, icon, null, null);
    }

    @Nullable
    public static String showInputDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        return Messages.showInputDialog(parent, message, title, icon, null, null);
    }

    @Nullable
    public static String showInputDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        return Messages.showInputDialog(message, title, icon, null, null);
    }

    @Nullable
    public static String showInputDialog(@Nullable Project project, @Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
        return MessagesService.getInstance().showInputDialog(project, null, message, title, icon, initialValue, validator, null, null);
    }

    @Nullable
    public static String showInputDialog(Project project, @Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator, @Nullable TextRange selection) {
        return Messages.showInputDialog(project, message, title, icon, initialValue, validator, selection, null);
    }

    @Nullable
    public static String showInputDialog(Project project, @Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator, @Nullable TextRange selection, @Nullable String comment) {
        return MessagesService.getInstance().showInputDialog(project, null, message, title, icon, initialValue, validator, selection, comment);
    }

    @Nullable
    public static String showInputDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
        return MessagesService.getInstance().showInputDialog(null, parent, message, title, icon, initialValue, validator, null, null);
    }

    @Nullable
    public static String showInputDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
        return MessagesService.getInstance().showInputDialog(null, null, message, title, icon, initialValue, validator, null, null);
    }

    @Nullable
    public static String showMultilineInputDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable String initialValue, @Nullable Icon icon, @Nullable InputValidator validator) {
        return MessagesService.getInstance().showMultilineInputDialog(project, message, title, initialValue, icon, validator);
    }

    @NotNull
    public static Pair<String, Boolean> showInputDialogWithCheckBox(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String checkboxText, boolean checked, boolean checkboxEnabled, @Nullable Icon icon, @NonNls String initialValue, @Nullable InputValidator validator) {
        return MessagesService.getInstance().showInputDialogWithCheckBox(message, title, checkboxText, checked, checkboxEnabled, icon, initialValue, validator);
    }

    @Nullable
    public static String showEditableChooseDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, String[] values, String initialValue, @Nullable InputValidator validator) {
        return MessagesService.getInstance().showEditableChooseDialog(message, title, icon, values, initialValue, validator);
    }

    @Deprecated
    public static int showChooseDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String[] values, String initialValue, @Nullable Icon icon) {
        return MessagesService.getInstance().showChooseDialog(null, null, message, title, values, initialValue, icon);
    }

    @Deprecated
    public static int showChooseDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String[] values, String initialValue, Icon icon) {
        return MessagesService.getInstance().showChooseDialog(null, parent, message, title, values, initialValue, icon);
    }

    @Deprecated
    public static int showChooseDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon, String[] values, String initialValue) {
        return MessagesService.getInstance().showChooseDialog(project, null, message, title, values, initialValue, icon);
    }

    public static void showInfoMessage(Component component, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON, SwingUtilities.getWindowAncestor(component));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showMessageDialog(component, message, title, Messages.getInformationIcon());
    }

    public static void showInfoMessage(@Nullable Project project, @Nls String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON, WindowManager.getInstance().suggestParentWindow(project));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showMessageDialog(project, message, title, Messages.getInformationIcon());
    }

    public static void showInfoMessage(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON, null);
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showMessageDialog(message, title, Messages.getInformationIcon());
    }

    public static void showTextAreaDialog(JTextField textField, @Nls(capitalization=Nls.Capitalization.Title) String title, @NonNls String dimensionServiceKey, Function<? super String, ? extends List<String>> parser, Function<? super List<String>, String> lineJoiner) {
        MessagesService.getInstance().showTextAreaDialog(textField, title, dimensionServiceKey, parser, lineJoiner);
    }

    public static void showTextAreaDialog(JTextField textField, @Nls(capitalization=Nls.Capitalization.Title) String title, @NonNls String dimensionServiceKey) {
        Messages.showTextAreaDialog(textField, title, dimensionServiceKey, (Function<? super String, ? extends List<String>>)ParametersListUtil.DEFAULT_LINE_PARSER, (Function<? super List<String>, String>)ParametersListUtil.DEFAULT_LINE_JOINER);
    }

    public static class MultilineInputDialog
    extends InputDialog {
        public MultilineInputDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator, @NotNull String[] options, int defaultOption) {
            super(project, message, title, icon, initialValue, validator, options, defaultOption);
        }

        @Override
        protected JTextComponent createTextFieldComponent() {
            return new JTextArea(7, 50);
        }

        @Override
        protected JComponent createScrollableTextComponent() {
            return new JBScrollPane(this.myField);
        }

        @Override
        protected JComponent createNorthPanel() {
            return null;
        }

        @Override
        protected JComponent createCenterPanel() {
            JPanel messagePanel = new JPanel(new BorderLayout());
            if (this.myMessage != null) {
                JComponent textComponent = this.createTextComponent();
                messagePanel.add((Component)textComponent, "North");
            }
            this.myField = this.createTextFieldComponent();
            messagePanel.add((Component)this.createScrollableTextComponent(), "Center");
            return messagePanel;
        }
    }

    public static class InputDialog
    extends MessageDialog {
        protected JTextComponent myField;
        private final InputValidator myValidator;
        private final String myComment;

        public InputDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator, @NotNull String[] options, int defaultOption, @Nullable String comment) {
            super(project, true);
            this.myComment = comment;
            this.myValidator = validator;
            this._init(title, message, options, defaultOption, -1, icon, null);
            this.myField.setText(initialValue);
            this.enableOkAction();
        }

        public InputDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator, @NotNull String[] options, int defaultOption) {
            this(project, message, title, icon, initialValue, validator, options, defaultOption, null);
        }

        public InputDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
            this(project, message, title, icon, initialValue, validator, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0);
        }

        public InputDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
            super(null, parent, message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, -1, 0, icon, null, true);
            this.myValidator = validator;
            this.myComment = null;
            this.myField.setText(initialValue);
            this.enableOkAction();
        }

        public InputDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
            super(null, null, message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, -1, icon, null, true);
            this.myValidator = validator;
            this.myComment = null;
            this.myField.setText(initialValue);
            this.enableOkAction();
        }

        private void enableOkAction() {
            this.getOKAction().setEnabled(this.myValidator == null || this.myValidator.checkInput(this.myField.getText().trim()));
        }

        @Override
        @NotNull
        protected Action[] createActions() {
            final Action[] actions = new Action[this.myOptions.length];
            for (int i = 0; i < this.myOptions.length; ++i) {
                String option = this.myOptions[i];
                final int exitCode = i;
                if (i == 0) {
                    actions[0] = this.getOKAction();
                    actions[0].putValue("DefaultAction", Boolean.TRUE);
                    this.myField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                        public void textChanged(@NotNull DocumentEvent event) {
                            String text = myField.getText().trim();
                            actions[exitCode].setEnabled(myValidator == null || myValidator.checkInput(text));
                            if (myValidator instanceof InputValidatorEx) {
                                this.setErrorText(((InputValidatorEx)myValidator).getErrorText(text), myField);
                            }
                        }
                    });
                    continue;
                }
                actions[i] = new AbstractAction(option){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.close(exitCode);
                    }
                };
            }
            return actions;
        }

        @Override
        protected void doOKAction() {
            String inputString = this.myField.getText().trim();
            if (this.myValidator == null || this.myValidator.checkInput(inputString) && this.myValidator.canClose(inputString)) {
                this.close(0);
            }
        }

        @Override
        protected JComponent createCenterPanel() {
            return null;
        }

        @Override
        protected JComponent createNorthPanel() {
            JPanel panel = this.createIconPanel();
            JPanel messagePanel = this.createMessagePanel();
            panel.add((Component)messagePanel, "Center");
            if (this.myComment != null) {
                return UI.PanelFactory.panel(panel).withComment(this.myComment).createPanel();
            }
            return panel;
        }

        @Override
        @NotNull
        protected JPanel createMessagePanel() {
            JPanel messagePanel = new JPanel(new BorderLayout());
            if (this.myMessage != null) {
                JComponent textComponent = this.createTextComponent();
                messagePanel.add((Component)textComponent, "North");
            }
            this.myField = this.createTextFieldComponent();
            messagePanel.add((Component)this.createScrollableTextComponent(), "South");
            return messagePanel;
        }

        protected JComponent createScrollableTextComponent() {
            return this.myField;
        }

        protected JComponent createTextComponent() {
            JComponent textComponent;
            if (BasicHTML.isHTMLString(this.myMessage)) {
                textComponent = this.createMessageComponent(this.myMessage);
            } else {
                JLabel textLabel = new JLabel(this.myMessage);
                textLabel.setUI(new MultiLineLabelUI());
                textComponent = textLabel;
            }
            textComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 20));
            return textComponent;
        }

        public JTextComponent getTextField() {
            return this.myField;
        }

        protected JTextComponent createTextFieldComponent() {
            return new JTextField(30);
        }

        @Override
        public JComponent getPreferredFocusedComponent() {
            return this.myField;
        }

        @Nullable
        public String getInputString() {
            if (this.getExitCode() == 0) {
                return this.myField.getText().trim();
            }
            return null;
        }
    }

    public static @interface YesNoCancelResult {
    }

    public static @interface OkCancelResult {
    }

    public static @interface YesNoResult {
    }
}

