/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splittable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.Producer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class OnePixelDivider
extends Divider {
    public static final Color BACKGROUND = new JBColor(() -> {
        Color bg = UIManager.getColor("OnePixelDivider.background");
        return bg != null ? bg : JBColor.border();
    });
    private boolean myVertical;
    private final Splittable mySplitter;
    private boolean myResizeEnabled;
    private boolean mySwitchOrientationEnabled;
    protected Point myPoint;
    private IdeGlassPane myGlassPane;
    private final MouseAdapter myListener = new MyMouseAdapter();
    private Disposable myDisposable;
    private boolean myDragging = false;

    public OnePixelDivider(boolean vertical, Splittable splitter) {
        super((LayoutManager)new GridBagLayout());
        this.mySplitter = splitter;
        this.myResizeEnabled = true;
        this.mySwitchOrientationEnabled = false;
        this.setFocusable(false);
        this.enableEvents(48L);
        this.setOrientation(vertical);
        this.setBackground(BACKGROUND);
    }

    public void paint(Graphics g) {
        Insets insets;
        Producer<Insets> blindZone;
        Rectangle bounds = g.getClipBounds();
        if (this.mySplitter instanceof OnePixelSplitter && (blindZone = ((OnePixelSplitter)this.mySplitter).getBlindZone()) != null && (insets = (Insets)blindZone.produce()) != null) {
            bounds.x += insets.left;
            bounds.y += insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
            g.setColor(this.getBackground());
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            return;
        }
        super.paint(g);
    }

    public void addNotify() {
        super.addNotify();
        this.init();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.myDisposable != null && !Disposer.isDisposed((Disposable)this.myDisposable)) {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
        }
    }

    private void setDragging(boolean dragging) {
        if (this.myDragging != dragging) {
            this.myDragging = dragging;
            this.mySplitter.setDragging(dragging);
        }
    }

    private MouseEvent getTargetEvent(MouseEvent e) {
        return SwingUtilities.convertMouseEvent(e.getComponent(), e, (Component)((Object)this));
    }

    private void init() {
        this.myGlassPane = IdeGlassPaneUtil.find((Component)((Object)this));
        this.myDisposable = Disposer.newDisposable();
        this.myGlassPane.addMouseMotionPreprocessor(this.myListener, this.myDisposable);
        this.myGlassPane.addMousePreprocessor(this.myListener, this.myDisposable);
    }

    public void setOrientation(boolean vertical) {
        this.removeAll();
        this.myVertical = vertical;
        int cursorType = this.isVertical() ? 8 : 10;
        UIUtil.setCursor((Component)((Object)this), (Cursor)Cursor.getPredefinedCursor(cursorType));
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        if (!this.myResizeEnabled) {
            return;
        }
        if (506 == e.getID() && this.myDragging) {
            this.myPoint = SwingUtilities.convertPoint((Component)((Object)this), e.getPoint(), this.mySplitter.asComponent());
            float firstMinProportion = this.mySplitter.getMinProportion(true);
            float secondMinProportion = this.mySplitter.getMinProportion(false);
            if (this.isVertical()) {
                if (this.getHeight() > 0) {
                    float proportion = Math.min(1.0f, Math.max(0.0f, Math.min(Math.max(firstMinProportion, (float)this.myPoint.y / (float)this.mySplitter.asComponent().getHeight()), 1.0f - secondMinProportion)));
                    this.mySplitter.setProportion(proportion);
                }
            } else if (this.getWidth() > 0) {
                float proportion = Math.min(1.0f, Math.max(0.0f, Math.min(Math.max(firstMinProportion, (float)this.myPoint.x / (float)this.mySplitter.asComponent().getWidth()), 1.0f - secondMinProportion)));
                this.mySplitter.setProportion(proportion);
            }
            e.consume();
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.getID() == 500) {
            if (this.mySwitchOrientationEnabled && e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e) && (SystemInfo.isMac ? e.isMetaDown() : e.isControlDown())) {
                this.mySplitter.setOrientation(!this.mySplitter.getOrientation());
            }
            if (this.myResizeEnabled && e.getClickCount() == 2) {
                this.mySplitter.setProportion(0.5f);
            }
        }
    }

    public void setResizeEnabled(boolean resizeEnabled) {
        this.myResizeEnabled = resizeEnabled;
        if (!this.myResizeEnabled) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.setCursor(this.isVertical() ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(10));
        }
    }

    public void setSwitchOrientationEnabled(boolean switchOrientationEnabled) {
        this.mySwitchOrientationEnabled = switchOrientationEnabled;
    }

    public boolean isVertical() {
        return this.myVertical;
    }

    private class MyMouseAdapter
    extends MouseAdapter
    implements Weighted {
        private MyMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            OnePixelDivider.this.setDragging(this.isInDragZone(e));
            this._processMouseEvent(e);
            if (OnePixelDivider.this.myDragging) {
                e.consume();
            }
        }

        boolean isInDragZone(MouseEvent e) {
            MouseEvent event = OnePixelDivider.this.getTargetEvent(e);
            Point p = event.getPoint();
            boolean vertical = OnePixelDivider.this.isVertical();
            OnePixelDivider d = OnePixelDivider.this;
            if ((vertical ? p.x : p.y) < 0 || vertical && p.x > d.getWidth() || !vertical && p.y > d.getHeight()) {
                return false;
            }
            int r = Math.abs(vertical ? p.y : p.x);
            return r < JBUI.scale((int)Registry.intValue((String)"ide.splitter.mouseZone"));
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this._processMouseEvent(e);
            if (OnePixelDivider.this.myDragging) {
                e.consume();
            }
            OnePixelDivider.this.setDragging(false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            OnePixelDivider divider = OnePixelDivider.this;
            if (this.isInDragZone(e)) {
                OnePixelDivider.this.myGlassPane.setCursor(divider.getCursor(), (Object)divider);
            } else {
                OnePixelDivider.this.myGlassPane.setCursor(null, (Object)divider);
            }
            this._processMouseMotionEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this._processMouseMotionEvent(e);
        }

        @Override
        public double getWeight() {
            return 1.0;
        }

        private void _processMouseMotionEvent(MouseEvent e) {
            MouseEvent event = OnePixelDivider.this.getTargetEvent(e);
            if (event == null) {
                OnePixelDivider.this.myGlassPane.setCursor(null, OnePixelDivider.this.myListener);
                return;
            }
            OnePixelDivider.this.processMouseMotionEvent(event);
            if (event.isConsumed()) {
                e.consume();
            }
        }

        private void _processMouseEvent(MouseEvent e) {
            MouseEvent event = OnePixelDivider.this.getTargetEvent(e);
            if (event == null) {
                OnePixelDivider.this.myGlassPane.setCursor(null, OnePixelDivider.this.myListener);
                return;
            }
            OnePixelDivider.this.processMouseEvent(event);
            if (event.isConsumed()) {
                e.consume();
            }
        }
    }
}

