/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.panel;

import com.intellij.openapi.ui.panel.GridBagPanelBuilder;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class PanelGridBuilder
implements PanelBuilder {
    private boolean expand;
    private final List<GridBagPanelBuilder> builders = new ArrayList<GridBagPanelBuilder>();

    public PanelGridBuilder add(@NotNull PanelBuilder builder) {
        this.builders.add((GridBagPanelBuilder)builder);
        return this;
    }

    public PanelGridBuilder resize() {
        this.expand = true;
        return this;
    }

    @Override
    @NotNull
    public JPanel createPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, null, 0, 0);
        this.addToPanel(panel, gc);
        return panel;
    }

    @Override
    public boolean constrainsValid() {
        return this.builders.stream().allMatch(b -> b.constrainsValid());
    }

    private int gridWidth() {
        return this.builders.stream().map(b -> b.gridWidth()).max(Integer::compareTo).orElse(0);
    }

    private void addToPanel(JPanel panel, GridBagConstraints gc) {
        this.builders.stream().filter(b -> b.constrainsValid()).forEach(b -> b.addToPanel(panel, gc));
        if (!this.expand) {
            gc.gridx = 0;
            gc.anchor = 20;
            gc.fill = 1;
            gc.weighty = 1.0;
            gc.insets = JBUI.insets((int)0);
            gc.gridwidth = this.gridWidth();
            panel.add((Component)new JPanel(), gc);
        }
    }
}

