/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup;

import com.intellij.openapi.ui.ListComponentUpdater;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopupChooserBuilder<T>
implements IPopupChooserBuilder<T> {
    private final PopupComponentAdapter<T> myChooserComponent;
    private String myTitle;
    private final ArrayList<KeyStroke> myAdditionalKeystrokes = new ArrayList();
    private Runnable myItemChosenRunnable;
    private JComponent mySouthComponent;
    private JComponent myEastComponent;
    private JBPopup myPopup;
    private boolean myRequestFocus = true;
    private boolean myForceResizable = false;
    private boolean myForceMovable = false;
    private String myDimensionServiceKey = null;
    private Computable<Boolean> myCancelCallback;
    private boolean myAutoselect = true;
    private float myAlpha;
    private Component[] myFocusOwners = new Component[0];
    private boolean myCancelKeyEnabled = true;
    private final List<JBPopupListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private String myAd;
    private Dimension myMinSize;
    private ActiveComponent myCommandButton;
    private final List<Pair<ActionListener, KeyStroke>> myKeyboardActions = new ArrayList<Pair<ActionListener, KeyStroke>>();
    private Component mySettingsButtons;
    private boolean myAutoselectOnMouseMove = true;
    private Function<Object, String> myItemsNamer = null;
    private boolean myMayBeParent;
    private int myAdAlignment = 2;
    private boolean myModalContext;
    private boolean myCloseOnEnter = true;
    private boolean myCancelOnWindowDeactivation = true;
    private boolean myUseForXYLocation;
    @Nullable
    private Processor<JBPopup> myCouldPin;
    private int myVisibleRowCount = 15;
    private boolean myAutoPackHeightOnFiltering = true;
    private boolean myCancelOnClickOutside = true;
    private JScrollPane myScrollPane;

    @Override
    public PopupChooserBuilder<T> setCancelOnClickOutside(boolean cancelOnClickOutside) {
        this.myCancelOnClickOutside = cancelOnClickOutside;
        return this;
    }

    public JScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    public PopupChooserBuilder(@NotNull JList list) {
        this.myChooserComponent = JBPopupFactory.getInstance().createPopupComponentAdapter(this, list);
    }

    public PopupChooserBuilder(@NotNull JTable table) {
        this.myChooserComponent = JBPopupFactory.getInstance().createPopupComponentAdapter(this, table);
    }

    public PopupChooserBuilder(@NotNull JTree tree) {
        this.myChooserComponent = JBPopupFactory.getInstance().createPopupComponentAdapter(this, tree);
    }

    @Override
    @NotNull
    public PopupChooserBuilder<T> setTitle(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        this.myTitle = title;
        return this;
    }

    @NotNull
    public PopupChooserBuilder<T> addAdditionalChooseKeystroke(@Nullable KeyStroke keyStroke) {
        if (keyStroke != null) {
            this.myAdditionalKeystrokes.add(keyStroke);
        }
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> setRenderer(ListCellRenderer renderer) {
        this.myChooserComponent.setRenderer(renderer);
        return this;
    }

    public JComponent getChooserComponent() {
        return this.myChooserComponent.getComponent();
    }

    @Override
    @NotNull
    public IPopupChooserBuilder<T> setItemChosenCallback(@NotNull Consumer<T> callback) {
        this.myChooserComponent.setItemChosenCallback(callback);
        return this;
    }

    @Override
    @NotNull
    public IPopupChooserBuilder<T> setItemsChosenCallback(@NotNull Consumer<? super Set<T>> callback) {
        this.myChooserComponent.setItemsChosenCallback(callback);
        return this;
    }

    @NotNull
    public PopupChooserBuilder<T> setItemChoosenCallback(@NotNull Runnable runnable) {
        this.myItemChosenRunnable = runnable;
        return this;
    }

    @NotNull
    public PopupChooserBuilder<T> setSouthComponent(@NotNull JComponent cmp) {
        this.mySouthComponent = cmp;
        return this;
    }

    @Override
    @NotNull
    public PopupChooserBuilder<T> setCouldPin(@Nullable Processor<JBPopup> callback) {
        this.myCouldPin = callback;
        return this;
    }

    @NotNull
    public PopupChooserBuilder<T> setEastComponent(@NotNull JComponent cmp) {
        this.myEastComponent = cmp;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setResizable(boolean forceResizable) {
        this.myForceResizable = forceResizable;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setMovable(boolean forceMovable) {
        this.myForceMovable = forceMovable;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setDimensionServiceKey(@NonNls String key) {
        this.myDimensionServiceKey = key;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setUseDimensionServiceForXYLocation(boolean use) {
        this.myUseForXYLocation = use;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setCancelCallback(Computable<Boolean> callback) {
        this.addCancelCallback(callback);
        return this;
    }

    public PopupChooserBuilder<T> setCommandButton(@NotNull ActiveComponent commandButton) {
        this.myCommandButton = commandButton;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setAlpha(float alpha) {
        this.myAlpha = alpha;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setAutoselectOnMouseMove(boolean doAutoSelect) {
        this.myAutoselectOnMouseMove = doAutoSelect;
        return this;
    }

    public boolean isAutoselectOnMouseMove() {
        return this.myAutoselectOnMouseMove;
    }

    public PopupChooserBuilder<T> setFilteringEnabled(Function<Object, String> namer) {
        this.myItemsNamer = namer;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setNamerForFiltering(Function<T, String> namer) {
        this.myItemsNamer = namer;
        return this;
    }

    public Function<Object, String> getItemsNamer() {
        return this.myItemsNamer;
    }

    @Override
    public IPopupChooserBuilder<T> setAutoPackHeightOnFiltering(boolean autoPackHeightOnFiltering) {
        this.myAutoPackHeightOnFiltering = autoPackHeightOnFiltering;
        return this;
    }

    public boolean isAutoPackHeightOnFiltering() {
        return this.myAutoPackHeightOnFiltering;
    }

    @Override
    public PopupChooserBuilder<T> setModalContext(boolean modalContext) {
        this.myModalContext = modalContext;
        return this;
    }

    @Override
    @NotNull
    public JBPopup createPopup() {
        JPanel contentPane = new JPanel(new BorderLayout());
        if (!this.myForceMovable && this.myTitle != null) {
            JLabel label = new JLabel(this.myTitle);
            label.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            label.setHorizontalAlignment(0);
            contentPane.add((Component)label, "North");
        }
        if (this.myAutoselect) {
            this.myChooserComponent.autoSelect();
        }
        this.myChooserComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (UIUtil.isActionClick((MouseEvent)e, (int)502) && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !e.isConsumed()) {
                    if (PopupChooserBuilder.this.myCloseOnEnter) {
                        PopupChooserBuilder.this.closePopup(true, e, true);
                    } else {
                        PopupChooserBuilder.this.myItemChosenRunnable.run();
                    }
                }
            }
        });
        this.registerClosePopupKeyboardAction(KeyStroke.getKeyStroke(27, 0), false);
        if (this.myCloseOnEnter) {
            this.registerClosePopupKeyboardAction(KeyStroke.getKeyStroke(10, 0), true);
        } else {
            this.registerKeyboardAction(KeyStroke.getKeyStroke(10, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    PopupChooserBuilder.this.myItemChosenRunnable.run();
                }
            });
        }
        for (KeyStroke keystroke : this.myAdditionalKeystrokes) {
            this.registerClosePopupKeyboardAction(keystroke, true);
        }
        JComponent finalComponent = this.myChooserComponent.buildFinalComponent();
        this.myScrollPane = this.myChooserComponent.createScrollPane();
        this.myScrollPane.getViewport().setCursor(Cursor.getPredefinedCursor(12));
        Insets viewportPadding = UIUtil.getListViewportPadding();
        ((JComponent)this.myScrollPane.getViewport().getView()).setBorder(BorderFactory.createEmptyBorder(viewportPadding.top, viewportPadding.left, viewportPadding.bottom, viewportPadding.right));
        if (this.myChooserComponent.hasOwnScrollPane()) {
            this.addCenterComponentToContentPane(contentPane, finalComponent);
        } else {
            this.addCenterComponentToContentPane(contentPane, this.myScrollPane);
        }
        if (this.mySouthComponent != null) {
            this.addSouthComponentToContentPane(contentPane, this.mySouthComponent);
        }
        if (this.myEastComponent != null) {
            this.addEastComponentToContentPane(contentPane, this.myEastComponent);
        }
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder(contentPane, finalComponent);
        for (JBPopupListener each : this.myListeners) {
            builder.addListener(each);
        }
        builder.setDimensionServiceKey(null, this.myDimensionServiceKey, this.myUseForXYLocation).setRequestFocus(this.myRequestFocus).setResizable(this.myForceResizable).setMovable(this.myForceMovable).setTitle(this.myForceMovable ? this.myTitle : null).setCancelCallback(this.myCancelCallback).setAlpha(this.myAlpha).setFocusOwners(this.myFocusOwners).setCancelKeyEnabled(this.myCancelKeyEnabled).setAdText(this.myAd, this.myAdAlignment).setKeyboardActions(this.myKeyboardActions).setMayBeParent(this.myMayBeParent).setLocateWithinScreenBounds(true).setCancelOnOtherWindowOpen(true).setModalContext(this.myModalContext).setCancelOnWindowDeactivation(this.myCancelOnWindowDeactivation).setCancelOnClickOutside(this.myCancelOnClickOutside).setCouldPin(this.myCouldPin);
        BooleanFunction<KeyEvent> keyEventHandler = this.myChooserComponent.getKeyEventHandler();
        if (keyEventHandler != null) {
            builder.setKeyEventHandler(keyEventHandler);
        }
        if (this.myCommandButton != null) {
            builder.setCommandButton(this.myCommandButton);
        }
        if (this.myMinSize != null) {
            builder.setMinSize(this.myMinSize);
        }
        if (this.mySettingsButtons != null) {
            builder.setSettingButtons(this.mySettingsButtons);
        }
        this.myPopup = builder.createPopup();
        return this.myPopup;
    }

    protected void addEastComponentToContentPane(JPanel contentPane, JComponent component) {
        contentPane.add((Component)component, "East");
    }

    protected void addSouthComponentToContentPane(JPanel contentPane, JComponent component) {
        contentPane.add((Component)component, "South");
    }

    protected void addCenterComponentToContentPane(JPanel contentPane, JComponent component) {
        contentPane.add((Component)component, "Center");
    }

    @Override
    public PopupChooserBuilder<T> setMinSize(Dimension dimension) {
        this.myMinSize = dimension;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> registerKeyboardAction(KeyStroke keyStroke, ActionListener actionListener) {
        this.myKeyboardActions.add((Pair<ActionListener, KeyStroke>)Pair.create((Object)actionListener, (Object)keyStroke));
        return this;
    }

    private void registerClosePopupKeyboardAction(KeyStroke keyStroke, final boolean shouldPerformAction) {
        this.registerPopupKeyboardAction(keyStroke, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!shouldPerformAction && PopupChooserBuilder.this.myChooserComponent.checkResetFilter()) {
                    return;
                }
                PopupChooserBuilder.this.closePopup(shouldPerformAction, null, shouldPerformAction);
            }
        });
    }

    private void registerPopupKeyboardAction(KeyStroke keyStroke, AbstractAction action) {
        this.myChooserComponent.getComponent().registerKeyboardAction(action, keyStroke, 1);
    }

    private void closePopup(boolean shouldPerformAction, MouseEvent e, boolean isOk) {
        if (shouldPerformAction) {
            this.myPopup.setFinalRunnable(this.myItemChosenRunnable);
        }
        if (isOk) {
            this.myPopup.closeOk(e);
        } else {
            this.myPopup.cancel(e);
        }
    }

    @Override
    public PopupChooserBuilder<T> setAutoSelectIfEmpty(boolean autoselect) {
        this.myAutoselect = autoselect;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setCancelKeyEnabled(boolean enabled) {
        this.myCancelKeyEnabled = enabled;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> addListener(JBPopupListener listener) {
        this.myListeners.add(listener);
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setSettingButton(Component button) {
        this.mySettingsButtons = button;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setMayBeParent(boolean mayBeParent) {
        this.myMayBeParent = mayBeParent;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setCloseOnEnter(boolean closeOnEnter) {
        this.myCloseOnEnter = closeOnEnter;
        return this;
    }

    @NotNull
    public PopupChooserBuilder<T> setFocusOwners(@NotNull Component[] focusOwners) {
        this.myFocusOwners = focusOwners;
        return this;
    }

    @Override
    @NotNull
    public PopupChooserBuilder<T> setAdText(String ad) {
        this.setAdText(ad, 2);
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setAdText(String ad, int alignment) {
        this.myAd = ad;
        this.myAdAlignment = alignment;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setCancelOnWindowDeactivation(boolean cancelOnWindowDeactivation) {
        this.myCancelOnWindowDeactivation = cancelOnWindowDeactivation;
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> setSelectionMode(int selection) {
        this.myChooserComponent.setSelectionMode(selection);
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> setSelectedValue(T preselection, boolean shouldScroll) {
        this.myChooserComponent.setSelectedValue(preselection, shouldScroll);
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> setAccessibleName(String title) {
        AccessibleContextUtil.setName((Component)this.myChooserComponent.getComponent(), (String)title);
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> setItemSelectedCallback(Consumer<? super T> c) {
        this.myChooserComponent.setItemSelectedCallback(c);
        return this;
    }

    private void addCancelCallback(Computable<Boolean> cbb) {
        Computable<Boolean> callback = this.myCancelCallback;
        this.myCancelCallback = () -> (Boolean)cbb.compute() != false && (callback == null || (Boolean)callback.compute() != false);
    }

    @Override
    public IPopupChooserBuilder<T> withHintUpdateSupply() {
        HintUpdateSupply.installSimpleHintUpdateSupply(this.myChooserComponent.getComponent());
        this.addCancelCallback((Computable<Boolean>)((Computable)() -> {
            HintUpdateSupply.hideHint(this.myChooserComponent.getComponent());
            return true;
        }));
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> setFont(Font f) {
        this.myChooserComponent.setFont(f);
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> setVisibleRowCount(int visibleRowCount) {
        this.myVisibleRowCount = visibleRowCount;
        return this;
    }

    public int getVisibleRowCount() {
        return this.myVisibleRowCount;
    }

    @Override
    public ListComponentUpdater getBackgroundUpdater() {
        return this.myChooserComponent.getBackgroundUpdater();
    }

    public static interface PopupComponentAdapter<T> {
        public JComponent getComponent();

        default public void setRenderer(ListCellRenderer renderer) {
        }

        public void setItemChosenCallback(Consumer<? super T> var1);

        public void setItemsChosenCallback(Consumer<? super Set<T>> var1);

        public JScrollPane createScrollPane();

        default public boolean hasOwnScrollPane() {
            return false;
        }

        default public void addMouseListener(MouseListener listener) {
            this.getComponent().addMouseListener(listener);
        }

        default public void autoSelect() {
        }

        default public void setSelectionMode(int selection) {
        }

        default public ListComponentUpdater getBackgroundUpdater() {
            return null;
        }

        default public void setSelectedValue(T preselection, boolean shouldScroll) {
            throw new UnsupportedOperationException("Not supported for this popup type");
        }

        default public void setItemSelectedCallback(Consumer<? super T> c) {
            throw new UnsupportedOperationException("Not supported for this popup type");
        }

        default public boolean checkResetFilter() {
            return false;
        }

        @Nullable
        default public BooleanFunction<KeyEvent> getKeyEventHandler() {
            return null;
        }

        default public void setFont(Font f) {
            this.getComponent().setFont(f);
        }

        default public JComponent buildFinalComponent() {
            return this.getComponent();
        }
    }
}

