/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExecutionCallback;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.OrderedSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionCallback
implements Disposable {
    public static final ActionCallback DONE = new Done();
    public static final ActionCallback REJECTED = new Rejected();
    private final ExecutionCallback myDone;
    private final ExecutionCallback myRejected;
    protected String myError;
    private final String myName;

    public ActionCallback() {
        this(null);
    }

    public ActionCallback(String name) {
        this.myName = name;
        this.myDone = new ExecutionCallback();
        this.myRejected = new ExecutionCallback();
    }

    private ActionCallback(@NotNull ExecutionCallback done2, @NotNull ExecutionCallback rejected2) {
        this.myDone = done2;
        this.myRejected = rejected2;
        this.myName = null;
    }

    public ActionCallback(int countToDone) {
        this(null, countToDone);
    }

    public ActionCallback(String name, int countToDone) {
        this.myName = name;
        assert (countToDone >= 0) : "count=" + countToDone;
        this.myDone = new ExecutionCallback(countToDone >= 1 ? countToDone : 1);
        this.myRejected = new ExecutionCallback();
        if (countToDone < 1) {
            this.setDone();
        }
    }

    public void setDone() {
        if (this.myDone.setExecuted()) {
            this.myRejected.clear();
            Disposer.dispose((Disposable)this);
        }
    }

    public boolean isDone() {
        return this.myDone.isExecuted();
    }

    public boolean isRejected() {
        return this.myRejected.isExecuted();
    }

    public boolean isProcessed() {
        return this.isDone() || this.isRejected();
    }

    public void setRejected() {
        if (this.myRejected.setExecuted()) {
            this.myDone.clear();
            Disposer.dispose((Disposable)this);
        }
    }

    @NotNull
    public ActionCallback reject(String error) {
        this.myError = error;
        this.setRejected();
        return this;
    }

    @Nullable
    public String getError() {
        return this.myError;
    }

    @NotNull
    public final ActionCallback doWhenDone(@NotNull Runnable runnable) {
        this.myDone.doWhenExecuted(runnable);
        return this;
    }

    @NotNull
    public final ActionCallback doWhenRejected(@NotNull Runnable runnable) {
        this.myRejected.doWhenExecuted(runnable);
        return this;
    }

    @NotNull
    public final ActionCallback doWhenRejected(@NotNull Consumer<? super String> consumer) {
        this.myRejected.doWhenExecuted(() -> consumer.consume((Object)this.myError));
        return this;
    }

    @NotNull
    public final ActionCallback doWhenProcessed(@NotNull Runnable runnable) {
        this.doWhenDone(runnable);
        this.doWhenRejected(runnable);
        return this;
    }

    @NotNull
    public final ActionCallback notifyWhenDone(@NotNull ActionCallback child) {
        return this.doWhenDone(child.createSetDoneRunnable());
    }

    @NotNull
    public final ActionCallback notifyWhenRejected(@NotNull ActionCallback child) {
        return this.doWhenRejected(() -> child.reject(this.myError));
    }

    @NotNull
    public ActionCallback notify(@NotNull ActionCallback child) {
        return this.doWhenDone(child.createSetDoneRunnable()).notifyWhenRejected(child);
    }

    @NotNull
    public final ActionCallback processOnDone(@NotNull Runnable runnable, boolean requiresDone) {
        if (requiresDone) {
            return this.doWhenDone(runnable);
        }
        runnable.run();
        return this;
    }

    @NonNls
    public String toString() {
        String name = this.myName != null ? this.myName : super.toString();
        return name + " done=[" + this.myDone + "] rejected=[" + this.myRejected + "]";
    }

    public void dispose() {
    }

    @NotNull
    public Runnable createSetDoneRunnable() {
        return () -> this.setDone();
    }

    public boolean waitFor(long msTimeout) {
        if (this.isProcessed()) {
            return true;
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.doWhenProcessed(() -> semaphore.up());
        try {
            if (msTimeout == -1L) {
                semaphore.waitForUnsafe();
            } else if (!semaphore.waitForUnsafe(msTimeout)) {
                this.reject("Time limit exceeded");
                return false;
            }
        }
        catch (InterruptedException e) {
            this.reject(e.getMessage());
            return false;
        }
        return true;
    }

    public static class Chunk {
        private final Set<ActionCallback> myCallbacks = new OrderedSet();

        public void add(@NotNull ActionCallback callback) {
            this.myCallbacks.add(callback);
        }

        @NotNull
        public ActionCallback create() {
            if (this.isEmpty()) {
                return DONE;
            }
            ActionCallback result2 = new ActionCallback(this.myCallbacks.size());
            Runnable doneRunnable = result2.createSetDoneRunnable();
            for (ActionCallback each : this.myCallbacks) {
                each.doWhenDone(doneRunnable).notifyWhenRejected(result2);
            }
            return result2;
        }

        public boolean isEmpty() {
            return this.myCallbacks.isEmpty();
        }

        public int getSize() {
            return this.myCallbacks.size();
        }

        @NotNull
        public ActionCallback getWhenProcessed() {
            if (this.myCallbacks.isEmpty()) {
                return DONE;
            }
            ActionCallback result2 = new ActionCallback(this.myCallbacks.size());
            Runnable setDoneRunnable = result2.createSetDoneRunnable();
            for (ActionCallback each : this.myCallbacks) {
                each.doWhenProcessed(setDoneRunnable);
            }
            return result2;
        }
    }

    private static class IgnoreExecutionCallback
    extends ExecutionCallback {
        private IgnoreExecutionCallback() {
        }

        @Override
        void doWhenExecuted(@NotNull Runnable runnable) {
        }

        @Override
        boolean setExecuted() {
            throw new IllegalStateException("Forbidden");
        }

        @Override
        boolean isExecuted() {
            return false;
        }
    }

    private static class ExecutedExecutionCallback
    extends ExecutionCallback {
        ExecutedExecutionCallback() {
            super(0);
        }

        @Override
        void doWhenExecuted(@NotNull Runnable runnable) {
            runnable.run();
        }

        @Override
        boolean setExecuted() {
            throw new IllegalStateException("Forbidden");
        }

        @Override
        boolean isExecuted() {
            return true;
        }
    }

    public static class Rejected
    extends ActionCallback {
        public Rejected() {
            super(new IgnoreExecutionCallback(), new ExecutedExecutionCallback());
        }
    }

    public static class Done
    extends ActionCallback {
        public Done() {
            super(new ExecutedExecutionCallback(), new IgnoreExecutionCallback());
        }
    }
}

